/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVBindlessTexture {
    public final long GetTextureHandleNV;
    public final long GetTextureSamplerHandleNV;
    public final long MakeTextureHandleResidentNV;
    public final long MakeTextureHandleNonResidentNV;
    public final long GetImageHandleNV;
    public final long MakeImageHandleResidentNV;
    public final long MakeImageHandleNonResidentNV;
    public final long UniformHandleui64NV;
    public final long UniformHandleui64vNV;
    public final long ProgramUniformHandleui64NV;
    public final long ProgramUniformHandleui64vNV;
    public final long IsTextureHandleResidentNV;
    public final long IsImageHandleResidentNV;

    protected NVBindlessTexture() {
        throw new UnsupportedOperationException();
    }

    public NVBindlessTexture(FunctionProvider provider) {
        this.GetTextureHandleNV = provider.getFunctionAddress("glGetTextureHandleNV");
        this.GetTextureSamplerHandleNV = provider.getFunctionAddress("glGetTextureSamplerHandleNV");
        this.MakeTextureHandleResidentNV = provider.getFunctionAddress("glMakeTextureHandleResidentNV");
        this.MakeTextureHandleNonResidentNV = provider.getFunctionAddress("glMakeTextureHandleNonResidentNV");
        this.GetImageHandleNV = provider.getFunctionAddress("glGetImageHandleNV");
        this.MakeImageHandleResidentNV = provider.getFunctionAddress("glMakeImageHandleResidentNV");
        this.MakeImageHandleNonResidentNV = provider.getFunctionAddress("glMakeImageHandleNonResidentNV");
        this.UniformHandleui64NV = provider.getFunctionAddress("glUniformHandleui64NV");
        this.UniformHandleui64vNV = provider.getFunctionAddress("glUniformHandleui64vNV");
        this.ProgramUniformHandleui64NV = provider.getFunctionAddress("glProgramUniformHandleui64NV");
        this.ProgramUniformHandleui64vNV = provider.getFunctionAddress("glProgramUniformHandleui64vNV");
        this.IsTextureHandleResidentNV = provider.getFunctionAddress("glIsTextureHandleResidentNV");
        this.IsImageHandleResidentNV = provider.getFunctionAddress("glIsImageHandleResidentNV");
    }

    public static NVBindlessTexture getInstance() {
        return NVBindlessTexture.getInstance(GL.getCapabilities());
    }

    public static NVBindlessTexture getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVBindlessTexture);
    }

    static NVBindlessTexture create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_bindless_texture")) {
            return null;
        }
        NVBindlessTexture funcs = new NVBindlessTexture(provider);
        boolean supported = Checks.checkFunctions(funcs.GetTextureHandleNV, funcs.GetTextureSamplerHandleNV, funcs.MakeTextureHandleResidentNV, funcs.MakeTextureHandleNonResidentNV, funcs.GetImageHandleNV, funcs.MakeImageHandleResidentNV, funcs.MakeImageHandleNonResidentNV, funcs.UniformHandleui64NV, funcs.UniformHandleui64vNV, funcs.ProgramUniformHandleui64NV, funcs.ProgramUniformHandleui64vNV, funcs.IsTextureHandleResidentNV, funcs.IsImageHandleResidentNV);
        return GL.checkExtension("GL_NV_bindless_texture", funcs, supported);
    }

    public static long glGetTextureHandleNV(int texture) {
        long __functionAddress = NVBindlessTexture.getInstance().GetTextureHandleNV;
        return JNI.callIJ(__functionAddress, texture);
    }

    public static long glGetTextureSamplerHandleNV(int texture, int sampler) {
        long __functionAddress = NVBindlessTexture.getInstance().GetTextureSamplerHandleNV;
        return JNI.callIIJ(__functionAddress, texture, sampler);
    }

    public static void glMakeTextureHandleResidentNV(long handle) {
        long __functionAddress = NVBindlessTexture.getInstance().MakeTextureHandleResidentNV;
        JNI.callJV(__functionAddress, handle);
    }

    public static void glMakeTextureHandleNonResidentNV(long handle) {
        long __functionAddress = NVBindlessTexture.getInstance().MakeTextureHandleNonResidentNV;
        JNI.callJV(__functionAddress, handle);
    }

    public static long glGetImageHandleNV(int texture, int level, boolean layered, int layer, int format) {
        long __functionAddress = NVBindlessTexture.getInstance().GetImageHandleNV;
        return JNI.callIIZIIJ(__functionAddress, texture, level, layered, layer, format);
    }

    public static void glMakeImageHandleResidentNV(long handle, int access) {
        long __functionAddress = NVBindlessTexture.getInstance().MakeImageHandleResidentNV;
        JNI.callJIV(__functionAddress, handle, access);
    }

    public static void glMakeImageHandleNonResidentNV(long handle) {
        long __functionAddress = NVBindlessTexture.getInstance().MakeImageHandleNonResidentNV;
        JNI.callJV(__functionAddress, handle);
    }

    public static void glUniformHandleui64NV(int location, long value) {
        long __functionAddress = NVBindlessTexture.getInstance().UniformHandleui64NV;
        JNI.callIJV(__functionAddress, location, value);
    }

    public static void nglUniformHandleui64vNV(int location, int count, long values) {
        long __functionAddress = NVBindlessTexture.getInstance().UniformHandleui64vNV;
        JNI.callIIPV(__functionAddress, location, count, values);
    }

    public static void glUniformHandleui64vNV(int location, int count, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, count << 3);
        }
        NVBindlessTexture.nglUniformHandleui64vNV(location, count, MemoryUtil.memAddress(values));
    }

    public static void glUniformHandleui64vNV(int location, LongBuffer values) {
        NVBindlessTexture.nglUniformHandleui64vNV(location, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static void glProgramUniformHandleui64NV(int program, int location, long value) {
        long __functionAddress = NVBindlessTexture.getInstance().ProgramUniformHandleui64NV;
        JNI.callIIJV(__functionAddress, program, location, value);
    }

    public static void nglProgramUniformHandleui64vNV(int program, int location, int count, long values) {
        long __functionAddress = NVBindlessTexture.getInstance().ProgramUniformHandleui64vNV;
        JNI.callIIIPV(__functionAddress, program, location, count, values);
    }

    public static void glProgramUniformHandleui64vNV(int program, int location, int count, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, count << 3);
        }
        NVBindlessTexture.nglProgramUniformHandleui64vNV(program, location, count, MemoryUtil.memAddress(values));
    }

    public static void glProgramUniformHandleui64vNV(int program, int location, LongBuffer values) {
        NVBindlessTexture.nglProgramUniformHandleui64vNV(program, location, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static boolean glIsTextureHandleResidentNV(long handle) {
        long __functionAddress = NVBindlessTexture.getInstance().IsTextureHandleResidentNV;
        return JNI.callJZ(__functionAddress, handle);
    }

    public static boolean glIsImageHandleResidentNV(long handle) {
        long __functionAddress = NVBindlessTexture.getInstance().IsImageHandleResidentNV;
        return JNI.callJZ(__functionAddress, handle);
    }
}

