/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class WGLARBBufferRegion {
    public static final int WGL_FRONT_COLOR_BUFFER_BIT_ARB = 1;
    public static final int WGL_BACK_COLOR_BUFFER_BIT_ARB = 2;
    public static final int WGL_DEPTH_BUFFER_BIT_ARB = 4;
    public static final int WGL_STENCIL_BUFFER_BIT_ARB = 8;
    public final long CreateBufferRegionARB;
    public final long DeleteBufferRegionARB;
    public final long SaveBufferRegionARB;
    public final long RestoreBufferRegionARB;

    protected WGLARBBufferRegion() {
        throw new UnsupportedOperationException();
    }

    public WGLARBBufferRegion(FunctionProvider provider) {
        this.CreateBufferRegionARB = provider.getFunctionAddress("wglCreateBufferRegionARB");
        this.DeleteBufferRegionARB = provider.getFunctionAddress("wglDeleteBufferRegionARB");
        this.SaveBufferRegionARB = provider.getFunctionAddress("wglSaveBufferRegionARB");
        this.RestoreBufferRegionARB = provider.getFunctionAddress("wglRestoreBufferRegionARB");
    }

    public static WGLARBBufferRegion getInstance() {
        return WGLARBBufferRegion.getInstance(GL.getCapabilities());
    }

    public static WGLARBBufferRegion getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__WGLARBBufferRegion);
    }

    static WGLARBBufferRegion create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_ARB_buffer_region")) {
            return null;
        }
        WGLARBBufferRegion funcs = new WGLARBBufferRegion(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateBufferRegionARB, funcs.DeleteBufferRegionARB, funcs.SaveBufferRegionARB, funcs.RestoreBufferRegionARB);
        return GL.checkExtension("WGL_ARB_buffer_region", funcs, supported);
    }

    public static long wglCreateBufferRegionARB(long hdc, int layerPlane, int type) {
        long __functionAddress = WGLARBBufferRegion.getInstance().CreateBufferRegionARB;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPIIP(__functionAddress, hdc, layerPlane, type);
    }

    public static void wglDeleteBufferRegionARB(long region) {
        long __functionAddress = WGLARBBufferRegion.getInstance().DeleteBufferRegionARB;
        if (Checks.CHECKS) {
            Checks.checkPointer(region);
        }
        JNI.callPV(__functionAddress, region);
    }

    public static int wglSaveBufferRegionARB(long region, int x, int y, int width, int height) {
        long __functionAddress = WGLARBBufferRegion.getInstance().SaveBufferRegionARB;
        if (Checks.CHECKS) {
            Checks.checkPointer(region);
        }
        return JNI.callPIIIII(__functionAddress, region, x, y, width, height);
    }

    public static int wglRestoreBufferRegionARB(long region, int x, int y, int width, int height, int xSrc, int ySrc) {
        long __functionAddress = WGLARBBufferRegion.getInstance().RestoreBufferRegionARB;
        if (Checks.CHECKS) {
            Checks.checkPointer(region);
        }
        return JNI.callPIIIIIII(__functionAddress, region, x, y, width, height, xSrc, ySrc);
    }
}

