/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GPU_DEVICE;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class WGLNVGPUAffinity {
    public static final int ERROR_INCOMPATIBLE_AFFINITY_MASKS_NV = 8400;
    public static final int ERROR_MISSING_AFFINITY_MASK_NV = 8401;
    public final long EnumGpusNV;
    public final long EnumGpuDevicesNV;
    public final long CreateAffinityDCNV;
    public final long EnumGpusFromAffinityDCNV;
    public final long DeleteDCNV;

    protected WGLNVGPUAffinity() {
        throw new UnsupportedOperationException();
    }

    public WGLNVGPUAffinity(FunctionProvider provider) {
        this.EnumGpusNV = provider.getFunctionAddress("wglEnumGpusNV");
        this.EnumGpuDevicesNV = provider.getFunctionAddress("wglEnumGpuDevicesNV");
        this.CreateAffinityDCNV = provider.getFunctionAddress("wglCreateAffinityDCNV");
        this.EnumGpusFromAffinityDCNV = provider.getFunctionAddress("wglEnumGpusFromAffinityDCNV");
        this.DeleteDCNV = provider.getFunctionAddress("wglDeleteDCNV");
    }

    public static WGLNVGPUAffinity getInstance() {
        return WGLNVGPUAffinity.getInstance(GL.getCapabilities());
    }

    public static WGLNVGPUAffinity getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__WGLNVGPUAffinity);
    }

    static WGLNVGPUAffinity create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_NV_gpu_affinity")) {
            return null;
        }
        WGLNVGPUAffinity funcs = new WGLNVGPUAffinity(provider);
        boolean supported = Checks.checkFunctions(funcs.EnumGpusNV, funcs.EnumGpuDevicesNV, funcs.CreateAffinityDCNV, funcs.EnumGpusFromAffinityDCNV, funcs.DeleteDCNV);
        return GL.checkExtension("WGL_NV_gpu_affinity", funcs, supported);
    }

    public static int nwglEnumGpusNV(int gpuIndex, long gpu) {
        long __functionAddress = WGLNVGPUAffinity.getInstance().EnumGpusNV;
        return JNI.callIPI(__functionAddress, gpuIndex, gpu);
    }

    public static int wglEnumGpusNV(int gpuIndex, ByteBuffer gpu) {
        return WGLNVGPUAffinity.nwglEnumGpusNV(gpuIndex, MemoryUtil.memAddress(gpu));
    }

    public static int wglEnumGpusNV(int gpuIndex, PointerBuffer gpu) {
        return WGLNVGPUAffinity.nwglEnumGpusNV(gpuIndex, MemoryUtil.memAddress(gpu));
    }

    public static int nwglEnumGpuDevicesNV(long gpu, int deviceIndex, long gpuDevice) {
        long __functionAddress = WGLNVGPUAffinity.getInstance().EnumGpuDevicesNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(gpu);
        }
        return JNI.callPIPI(__functionAddress, gpu, deviceIndex, gpuDevice);
    }

    public static int wglEnumGpuDevicesNV(long gpu, int deviceIndex, GPU_DEVICE gpuDevice) {
        return WGLNVGPUAffinity.nwglEnumGpuDevicesNV(gpu, deviceIndex, gpuDevice.address());
    }

    public static long nwglCreateAffinityDCNV(long gpuList) {
        long __functionAddress = WGLNVGPUAffinity.getInstance().CreateAffinityDCNV;
        return JNI.callPP(__functionAddress, gpuList);
    }

    public static long wglCreateAffinityDCNV(ByteBuffer gpuList) {
        if (Checks.CHECKS) {
            Checks.checkNTP(gpuList);
        }
        return WGLNVGPUAffinity.nwglCreateAffinityDCNV(MemoryUtil.memAddress(gpuList));
    }

    public static long wglCreateAffinityDCNV(PointerBuffer gpuList) {
        if (Checks.CHECKS) {
            Checks.checkNT(gpuList);
        }
        return WGLNVGPUAffinity.nwglCreateAffinityDCNV(MemoryUtil.memAddress(gpuList));
    }

    public static int nwglEnumGpusFromAffinityDCNV(long affinityDC, int gpuIndex, long gpu) {
        long __functionAddress = WGLNVGPUAffinity.getInstance().EnumGpusFromAffinityDCNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(affinityDC);
        }
        return JNI.callPIPI(__functionAddress, affinityDC, gpuIndex, gpu);
    }

    public static int wglEnumGpusFromAffinityDCNV(long affinityDC, int gpuIndex, ByteBuffer gpu) {
        return WGLNVGPUAffinity.nwglEnumGpusFromAffinityDCNV(affinityDC, gpuIndex, MemoryUtil.memAddress(gpu));
    }

    public static int wglEnumGpusFromAffinityDCNV(long affinityDC, int gpuIndex, PointerBuffer gpu) {
        return WGLNVGPUAffinity.nwglEnumGpusFromAffinityDCNV(affinityDC, gpuIndex, MemoryUtil.memAddress(gpu));
    }

    public static int wglDeleteDCNV(long hdc) {
        long __functionAddress = WGLNVGPUAffinity.getInstance().DeleteDCNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPI(__functionAddress, hdc);
    }
}

