/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ANGLETranslatedShaderSource {
    public static final int GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE = 37792;
    public final long GetTranslatedShaderSourceANGLE;

    protected ANGLETranslatedShaderSource() {
        throw new UnsupportedOperationException();
    }

    public ANGLETranslatedShaderSource(FunctionProvider provider) {
        this.GetTranslatedShaderSourceANGLE = provider.getFunctionAddress("glGetTranslatedShaderSourceANGLE");
    }

    public static ANGLETranslatedShaderSource getInstance() {
        return ANGLETranslatedShaderSource.getInstance(GLES.getCapabilities());
    }

    public static ANGLETranslatedShaderSource getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__ANGLETranslatedShaderSource);
    }

    static ANGLETranslatedShaderSource create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ANGLE_translated_shader_source")) {
            return null;
        }
        ANGLETranslatedShaderSource funcs = new ANGLETranslatedShaderSource(provider);
        boolean supported = Checks.checkFunctions(funcs.GetTranslatedShaderSourceANGLE);
        return GLES.checkExtension("GL_ANGLE_translated_shader_source", funcs, supported);
    }

    public static void nglGetTranslatedShaderSourceANGLE(int shader, int bufsize, long length, long source) {
        long __functionAddress = ANGLETranslatedShaderSource.getInstance().GetTranslatedShaderSourceANGLE;
        JNI.callIIPPV(__functionAddress, shader, bufsize, length, source);
    }

    public static void glGetTranslatedShaderSourceANGLE(int shader, int bufsize, ByteBuffer length, ByteBuffer source) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)source, bufsize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ANGLETranslatedShaderSource.nglGetTranslatedShaderSourceANGLE(shader, bufsize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static void glGetTranslatedShaderSourceANGLE(int shader, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ANGLETranslatedShaderSource.nglGetTranslatedShaderSourceANGLE(shader, source.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static String glGetTranslatedShaderSourceANGLE(int shader, int bufsize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(bufsize);
        ANGLETranslatedShaderSource.nglGetTranslatedShaderSourceANGLE(shader, bufsize, __buffer.address(length), __buffer.address(source));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), source);
    }

    public static String glGetTranslatedShaderSourceANGLE(int shader) {
        int bufsize = GLES20.glGetShaderi(shader, 37792);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(bufsize);
        ANGLETranslatedShaderSource.nglGetTranslatedShaderSourceANGLE(shader, bufsize, __buffer.address(length), __buffer.address(source));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), source);
    }
}

