/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDiscardFramebuffer {
    public static final int GL_COLOR_EXT = 6144;
    public static final int GL_DEPTH_EXT = 6145;
    public static final int GL_STENCIL_EXT = 6146;
    public final long DiscardFramebufferEXT;

    protected EXTDiscardFramebuffer() {
        throw new UnsupportedOperationException();
    }

    public EXTDiscardFramebuffer(FunctionProvider provider) {
        this.DiscardFramebufferEXT = provider.getFunctionAddress("glDiscardFramebufferEXT");
    }

    public static EXTDiscardFramebuffer getInstance() {
        return EXTDiscardFramebuffer.getInstance(GLES.getCapabilities());
    }

    public static EXTDiscardFramebuffer getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTDiscardFramebuffer);
    }

    static EXTDiscardFramebuffer create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_discard_framebuffer")) {
            return null;
        }
        EXTDiscardFramebuffer funcs = new EXTDiscardFramebuffer(provider);
        boolean supported = Checks.checkFunctions(funcs.DiscardFramebufferEXT);
        return GLES.checkExtension("GL_EXT_discard_framebuffer", funcs, supported);
    }

    public static void nglDiscardFramebufferEXT(int target, int numAttachments, long attachments) {
        long __functionAddress = EXTDiscardFramebuffer.getInstance().DiscardFramebufferEXT;
        JNI.callIIPV(__functionAddress, target, numAttachments, attachments);
    }

    public static void glDiscardFramebufferEXT(int target, int numAttachments, ByteBuffer attachments) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        EXTDiscardFramebuffer.nglDiscardFramebufferEXT(target, numAttachments, MemoryUtil.memAddress(attachments));
    }

    public static void glDiscardFramebufferEXT(int target, IntBuffer attachments) {
        EXTDiscardFramebuffer.nglDiscardFramebufferEXT(target, attachments.remaining(), MemoryUtil.memAddress(attachments));
    }

    public static void glDiscardFramebufferEXT(int target, int attachment) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        EXTDiscardFramebuffer.nglDiscardFramebufferEXT(target, 1, __buffer.address(attachments));
    }
}

