/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDisjointTimerQuery {
    public static final int GL_QUERY_COUNTER_BITS_EXT = 34916;
    public static final int GL_CURRENT_QUERY_EXT = 34917;
    public static final int GL_QUERY_RESULT_EXT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE_EXT = 34919;
    public static final int GL_TIME_ELAPSED_EXT = 35007;
    public static final int GL_TIMESTAMP_EXT = 36392;
    public static final int GL_GPU_DISJOINT_EXT = 36795;
    public final long GenQueriesEXT;
    public final long DeleteQueriesEXT;
    public final long IsQueryEXT;
    public final long BeginQueryEXT;
    public final long EndQueryEXT;
    public final long QueryCounterEXT;
    public final long GetQueryivEXT;
    public final long GetQueryObjectivEXT;
    public final long GetQueryObjectuivEXT;
    public final long GetQueryObjecti64vEXT;
    public final long GetQueryObjectui64vEXT;

    protected EXTDisjointTimerQuery() {
        throw new UnsupportedOperationException();
    }

    public EXTDisjointTimerQuery(FunctionProvider provider) {
        this.GenQueriesEXT = provider.getFunctionAddress("glGenQueriesEXT");
        this.DeleteQueriesEXT = provider.getFunctionAddress("glDeleteQueriesEXT");
        this.IsQueryEXT = provider.getFunctionAddress("glIsQueryEXT");
        this.BeginQueryEXT = provider.getFunctionAddress("glBeginQueryEXT");
        this.EndQueryEXT = provider.getFunctionAddress("glEndQueryEXT");
        this.QueryCounterEXT = provider.getFunctionAddress("glQueryCounterEXT");
        this.GetQueryivEXT = provider.getFunctionAddress("glGetQueryivEXT");
        this.GetQueryObjectivEXT = provider.getFunctionAddress("glGetQueryObjectivEXT");
        this.GetQueryObjectuivEXT = provider.getFunctionAddress("glGetQueryObjectuivEXT");
        this.GetQueryObjecti64vEXT = provider.getFunctionAddress("glGetQueryObjecti64vEXT");
        this.GetQueryObjectui64vEXT = provider.getFunctionAddress("glGetQueryObjectui64vEXT");
    }

    public static EXTDisjointTimerQuery getInstance() {
        return EXTDisjointTimerQuery.getInstance(GLES.getCapabilities());
    }

    public static EXTDisjointTimerQuery getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTDisjointTimerQuery);
    }

    static EXTDisjointTimerQuery create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_disjoint_timer_query")) {
            return null;
        }
        EXTDisjointTimerQuery funcs = new EXTDisjointTimerQuery(provider);
        boolean supported = Checks.checkFunctions(funcs.GenQueriesEXT, funcs.DeleteQueriesEXT, funcs.IsQueryEXT, funcs.BeginQueryEXT, funcs.EndQueryEXT, funcs.QueryCounterEXT, funcs.GetQueryivEXT, funcs.GetQueryObjectivEXT, funcs.GetQueryObjectuivEXT, funcs.GetQueryObjecti64vEXT, funcs.GetQueryObjectui64vEXT);
        return GLES.checkExtension("GL_EXT_disjoint_timer_query", funcs, supported);
    }

    public static void nglGenQueriesEXT(int n, long ids) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().GenQueriesEXT;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glGenQueriesEXT(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        EXTDisjointTimerQuery.nglGenQueriesEXT(n, MemoryUtil.memAddress(ids));
    }

    public static void glGenQueriesEXT(IntBuffer ids) {
        EXTDisjointTimerQuery.nglGenQueriesEXT(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glGenQueriesEXT() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        EXTDisjointTimerQuery.nglGenQueriesEXT(1, __buffer.address(ids));
        return __buffer.intValue(ids);
    }

    public static void nglDeleteQueriesEXT(int n, long ids) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().DeleteQueriesEXT;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glDeleteQueriesEXT(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        EXTDisjointTimerQuery.nglDeleteQueriesEXT(n, MemoryUtil.memAddress(ids));
    }

    public static void glDeleteQueriesEXT(IntBuffer ids) {
        EXTDisjointTimerQuery.nglDeleteQueriesEXT(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static void glDeleteQueriesEXT(int id) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        EXTDisjointTimerQuery.nglDeleteQueriesEXT(1, __buffer.address(ids));
    }

    public static boolean glIsQueryEXT(int id) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().IsQueryEXT;
        return JNI.callIZ(__functionAddress, id);
    }

    public static void glBeginQueryEXT(int target, int id) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().BeginQueryEXT;
        JNI.callIIV(__functionAddress, target, id);
    }

    public static void glEndQueryEXT(int target) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().EndQueryEXT;
        JNI.callIV(__functionAddress, target);
    }

    public static void glQueryCounterEXT(int id, int target) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().QueryCounterEXT;
        JNI.callIIV(__functionAddress, id, target);
    }

    public static void nglGetQueryivEXT(int target, int pname, long params) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().GetQueryivEXT;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetQueryivEXT(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDisjointTimerQuery.nglGetQueryivEXT(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryivEXT(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDisjointTimerQuery.nglGetQueryivEXT(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryiEXT(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        EXTDisjointTimerQuery.nglGetQueryivEXT(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetQueryObjectivEXT(int id, int pname, long params) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().GetQueryObjectivEXT;
        JNI.callIIPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectivEXT(int id, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDisjointTimerQuery.nglGetQueryObjectivEXT(id, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryObjectivEXT(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDisjointTimerQuery.nglGetQueryObjectivEXT(id, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryObjectiEXT(int id, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        EXTDisjointTimerQuery.nglGetQueryObjectivEXT(id, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetQueryObjectuivEXT(int id, int pname, long params) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().GetQueryObjectuivEXT;
        JNI.callIIPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectuivEXT(int id, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTDisjointTimerQuery.nglGetQueryObjectuivEXT(id, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryObjectuivEXT(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDisjointTimerQuery.nglGetQueryObjectuivEXT(id, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryObjectuiEXT(int id, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        EXTDisjointTimerQuery.nglGetQueryObjectuivEXT(id, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetQueryObjecti64vEXT(int id, int pname, long params) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().GetQueryObjecti64vEXT;
        JNI.callIIPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjecti64vEXT(int id, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        EXTDisjointTimerQuery.nglGetQueryObjecti64vEXT(id, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryObjecti64vEXT(int id, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDisjointTimerQuery.nglGetQueryObjecti64vEXT(id, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetQueryObjecti64EXT(int id, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        EXTDisjointTimerQuery.nglGetQueryObjecti64vEXT(id, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static void nglGetQueryObjectui64vEXT(int id, int pname, long params) {
        long __functionAddress = EXTDisjointTimerQuery.getInstance().GetQueryObjectui64vEXT;
        JNI.callIIPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectui64vEXT(int id, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        EXTDisjointTimerQuery.nglGetQueryObjectui64vEXT(id, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryObjectui64vEXT(int id, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDisjointTimerQuery.nglGetQueryObjectui64vEXT(id, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetQueryObjectui64EXT(int id, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        EXTDisjointTimerQuery.nglGetQueryObjectui64vEXT(id, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }
}

