/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class EXTMultiDrawArrays {
    public final long MultiDrawArraysEXT;
    public final long MultiDrawElementsEXT;

    protected EXTMultiDrawArrays() {
        throw new UnsupportedOperationException();
    }

    public EXTMultiDrawArrays(FunctionProvider provider) {
        this.MultiDrawArraysEXT = provider.getFunctionAddress("glMultiDrawArraysEXT");
        this.MultiDrawElementsEXT = provider.getFunctionAddress("glMultiDrawElementsEXT");
    }

    public static EXTMultiDrawArrays getInstance() {
        return EXTMultiDrawArrays.getInstance(GLES.getCapabilities());
    }

    public static EXTMultiDrawArrays getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTMultiDrawArrays);
    }

    static EXTMultiDrawArrays create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_multi_draw_arrays")) {
            return null;
        }
        EXTMultiDrawArrays funcs = new EXTMultiDrawArrays(provider);
        boolean supported = Checks.checkFunctions(funcs.MultiDrawArraysEXT, funcs.MultiDrawElementsEXT);
        return GLES.checkExtension("GL_EXT_multi_draw_arrays", funcs, supported);
    }

    public static void nglMultiDrawArraysEXT(int mode, long first, long count, int primcount) {
        long __functionAddress = EXTMultiDrawArrays.getInstance().MultiDrawArraysEXT;
        JNI.callIPPIV(__functionAddress, mode, first, count, primcount);
    }

    public static void glMultiDrawArraysEXT(int mode, ByteBuffer first, ByteBuffer count, int primcount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)first, primcount << 2);
            Checks.checkBuffer((Buffer)count, primcount << 2);
        }
        EXTMultiDrawArrays.nglMultiDrawArraysEXT(mode, MemoryUtil.memAddress(first), MemoryUtil.memAddress(count), primcount);
    }

    public static void glMultiDrawArraysEXT(int mode, IntBuffer first, IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, first.remaining());
        }
        EXTMultiDrawArrays.nglMultiDrawArraysEXT(mode, MemoryUtil.memAddress(first), MemoryUtil.memAddress(count), first.remaining());
    }

    public static void nglMultiDrawElementsEXT(int mode, long count, int type, long indices, int primcount) {
        long __functionAddress = EXTMultiDrawArrays.getInstance().MultiDrawElementsEXT;
        JNI.callIPIPIV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glMultiDrawElementsEXT(int mode, ByteBuffer count, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, primcount << 2);
            Checks.checkBuffer((Buffer)indices, primcount << Pointer.POINTER_SHIFT);
        }
        EXTMultiDrawArrays.nglMultiDrawElementsEXT(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glMultiDrawElementsEXT(int mode, IntBuffer count, int type, PointerBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(indices, count.remaining());
        }
        EXTMultiDrawArrays.nglMultiDrawElementsEXT(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining());
    }
}

