/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GLES30 {
    public static final int GL_READ_BUFFER = 3074;
    public static final int GL_UNPACK_ROW_LENGTH = 3314;
    public static final int GL_UNPACK_SKIP_ROWS = 3315;
    public static final int GL_UNPACK_SKIP_PIXELS = 3316;
    public static final int GL_PACK_ROW_LENGTH = 3330;
    public static final int GL_PACK_SKIP_ROWS = 3331;
    public static final int GL_PACK_SKIP_PIXELS = 3332;
    public static final int GL_COLOR = 6144;
    public static final int GL_DEPTH = 6145;
    public static final int GL_STENCIL = 6146;
    public static final int GL_RED = 6403;
    public static final int GL_RGB8 = 32849;
    public static final int GL_RGBA8 = 32856;
    public static final int GL_RGB10_A2 = 32857;
    public static final int GL_TEXTURE_BINDING_3D = 32874;
    public static final int GL_UNPACK_SKIP_IMAGES = 32877;
    public static final int GL_UNPACK_IMAGE_HEIGHT = 32878;
    public static final int GL_TEXTURE_3D = 32879;
    public static final int GL_TEXTURE_WRAP_R = 32882;
    public static final int GL_MAX_3D_TEXTURE_SIZE = 32883;
    public static final int GL_UNSIGNED_INT_2_10_10_10_REV = 33640;
    public static final int GL_MAX_ELEMENTS_VERTICES = 33000;
    public static final int GL_MAX_ELEMENTS_INDICES = 33001;
    public static final int GL_TEXTURE_MIN_LOD = 33082;
    public static final int GL_TEXTURE_MAX_LOD = 33083;
    public static final int GL_TEXTURE_BASE_LEVEL = 33084;
    public static final int GL_TEXTURE_MAX_LEVEL = 33085;
    public static final int GL_MIN = 32775;
    public static final int GL_MAX = 32776;
    public static final int GL_DEPTH_COMPONENT24 = 33190;
    public static final int GL_MAX_TEXTURE_LOD_BIAS = 34045;
    public static final int GL_TEXTURE_COMPARE_MODE = 34892;
    public static final int GL_TEXTURE_COMPARE_FUNC = 34893;
    public static final int GL_CURRENT_QUERY = 34917;
    public static final int GL_QUERY_RESULT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE = 34919;
    public static final int GL_BUFFER_MAPPED = 35004;
    public static final int GL_BUFFER_MAP_POINTER = 35005;
    public static final int GL_STREAM_READ = 35041;
    public static final int GL_STREAM_COPY = 35042;
    public static final int GL_STATIC_READ = 35045;
    public static final int GL_STATIC_COPY = 35046;
    public static final int GL_DYNAMIC_READ = 35049;
    public static final int GL_DYNAMIC_COPY = 35050;
    public static final int GL_MAX_DRAW_BUFFERS = 34852;
    public static final int GL_DRAW_BUFFER0 = 34853;
    public static final int GL_DRAW_BUFFER1 = 34854;
    public static final int GL_DRAW_BUFFER2 = 34855;
    public static final int GL_DRAW_BUFFER3 = 34856;
    public static final int GL_DRAW_BUFFER4 = 34857;
    public static final int GL_DRAW_BUFFER5 = 34858;
    public static final int GL_DRAW_BUFFER6 = 34859;
    public static final int GL_DRAW_BUFFER7 = 34860;
    public static final int GL_DRAW_BUFFER8 = 34861;
    public static final int GL_DRAW_BUFFER9 = 34862;
    public static final int GL_DRAW_BUFFER10 = 34863;
    public static final int GL_DRAW_BUFFER11 = 34864;
    public static final int GL_DRAW_BUFFER12 = 34865;
    public static final int GL_DRAW_BUFFER13 = 34866;
    public static final int GL_DRAW_BUFFER14 = 34867;
    public static final int GL_DRAW_BUFFER15 = 34868;
    public static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_SAMPLER_3D = 35679;
    public static final int GL_SAMPLER_2D_SHADOW = 35682;
    public static final int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public static final int GL_PIXEL_PACK_BUFFER = 35051;
    public static final int GL_PIXEL_UNPACK_BUFFER = 35052;
    public static final int GL_PIXEL_PACK_BUFFER_BINDING = 35053;
    public static final int GL_PIXEL_UNPACK_BUFFER_BINDING = 35055;
    public static final int GL_FLOAT_MAT2x3 = 35685;
    public static final int GL_FLOAT_MAT2x4 = 35686;
    public static final int GL_FLOAT_MAT3x2 = 35687;
    public static final int GL_FLOAT_MAT3x4 = 35688;
    public static final int GL_FLOAT_MAT4x2 = 35689;
    public static final int GL_FLOAT_MAT4x3 = 35690;
    public static final int GL_SRGB = 35904;
    public static final int GL_SRGB8 = 35905;
    public static final int GL_SRGB8_ALPHA8 = 35907;
    public static final int GL_COMPARE_REF_TO_TEXTURE = 34894;
    public static final int GL_MAJOR_VERSION = 33307;
    public static final int GL_MINOR_VERSION = 33308;
    public static final int GL_NUM_EXTENSIONS = 33309;
    public static final int GL_RGBA32F = 34836;
    public static final int GL_RGB32F = 34837;
    public static final int GL_RGBA16F = 34842;
    public static final int GL_RGB16F = 34843;
    public static final int GL_VERTEX_ATTRIB_ARRAY_INTEGER = 35069;
    public static final int GL_MAX_ARRAY_TEXTURE_LAYERS = 35071;
    public static final int GL_MIN_PROGRAM_TEXEL_OFFSET = 35076;
    public static final int GL_MAX_PROGRAM_TEXEL_OFFSET = 35077;
    public static final int GL_MAX_VARYING_COMPONENTS = 35659;
    public static final int GL_TEXTURE_2D_ARRAY = 35866;
    public static final int GL_TEXTURE_BINDING_2D_ARRAY = 35869;
    public static final int GL_R11F_G11F_B10F = 35898;
    public static final int GL_UNSIGNED_INT_10F_11F_11F_REV = 35899;
    public static final int GL_RGB9_E5 = 35901;
    public static final int GL_UNSIGNED_INT_5_9_9_9_REV = 35902;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 35958;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE = 35967;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 35976;
    public static final int GL_RASTERIZER_DISCARD = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 35979;
    public static final int GL_INTERLEAVED_ATTRIBS = 35980;
    public static final int GL_SEPARATE_ATTRIBS = 35981;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = 35983;
    public static final int GL_RGBA32UI = 36208;
    public static final int GL_RGB32UI = 36209;
    public static final int GL_RGBA16UI = 36214;
    public static final int GL_RGB16UI = 36215;
    public static final int GL_RGBA8UI = 36220;
    public static final int GL_RGB8UI = 36221;
    public static final int GL_RGBA32I = 36226;
    public static final int GL_RGB32I = 36227;
    public static final int GL_RGBA16I = 36232;
    public static final int GL_RGB16I = 36233;
    public static final int GL_RGBA8I = 36238;
    public static final int GL_RGB8I = 36239;
    public static final int GL_RED_INTEGER = 36244;
    public static final int GL_RGB_INTEGER = 36248;
    public static final int GL_RGBA_INTEGER = 36249;
    public static final int GL_SAMPLER_2D_ARRAY = 36289;
    public static final int GL_SAMPLER_2D_ARRAY_SHADOW = 36292;
    public static final int GL_SAMPLER_CUBE_SHADOW = 36293;
    public static final int GL_UNSIGNED_INT_VEC2 = 36294;
    public static final int GL_UNSIGNED_INT_VEC3 = 36295;
    public static final int GL_UNSIGNED_INT_VEC4 = 36296;
    public static final int GL_INT_SAMPLER_2D = 36298;
    public static final int GL_INT_SAMPLER_3D = 36299;
    public static final int GL_INT_SAMPLER_CUBE = 36300;
    public static final int GL_INT_SAMPLER_2D_ARRAY = 36303;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D = 36306;
    public static final int GL_UNSIGNED_INT_SAMPLER_3D = 36307;
    public static final int GL_UNSIGNED_INT_SAMPLER_CUBE = 36308;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 36311;
    public static final int GL_BUFFER_ACCESS_FLAGS = 37151;
    public static final int GL_BUFFER_MAP_LENGTH = 37152;
    public static final int GL_BUFFER_MAP_OFFSET = 37153;
    public static final int GL_DEPTH_COMPONENT32F = 36012;
    public static final int GL_DEPTH32F_STENCIL8 = 36013;
    public static final int GL_FLOAT_32_UNSIGNED_INT_24_8_REV = 36269;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 33296;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 33297;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 33298;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 33299;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 33300;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 33301;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 33302;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 33303;
    public static final int GL_FRAMEBUFFER_DEFAULT = 33304;
    public static final int GL_FRAMEBUFFER_UNDEFINED = 33305;
    public static final int GL_DEPTH_STENCIL_ATTACHMENT = 33306;
    public static final int GL_DEPTH_STENCIL = 34041;
    public static final int GL_UNSIGNED_INT_24_8 = 34042;
    public static final int GL_DEPTH24_STENCIL8 = 35056;
    public static final int GL_UNSIGNED_NORMALIZED = 35863;
    public static final int GL_DRAW_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_READ_FRAMEBUFFER = 36008;
    public static final int GL_DRAW_FRAMEBUFFER = 36009;
    public static final int GL_READ_FRAMEBUFFER_BINDING = 36010;
    public static final int GL_RENDERBUFFER_SAMPLES = 36011;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 36052;
    public static final int GL_MAX_COLOR_ATTACHMENTS = 36063;
    public static final int GL_COLOR_ATTACHMENT1 = 36065;
    public static final int GL_COLOR_ATTACHMENT2 = 36066;
    public static final int GL_COLOR_ATTACHMENT3 = 36067;
    public static final int GL_COLOR_ATTACHMENT4 = 36068;
    public static final int GL_COLOR_ATTACHMENT5 = 36069;
    public static final int GL_COLOR_ATTACHMENT6 = 36070;
    public static final int GL_COLOR_ATTACHMENT7 = 36071;
    public static final int GL_COLOR_ATTACHMENT8 = 36072;
    public static final int GL_COLOR_ATTACHMENT9 = 36073;
    public static final int GL_COLOR_ATTACHMENT10 = 36074;
    public static final int GL_COLOR_ATTACHMENT11 = 36075;
    public static final int GL_COLOR_ATTACHMENT12 = 36076;
    public static final int GL_COLOR_ATTACHMENT13 = 36077;
    public static final int GL_COLOR_ATTACHMENT14 = 36078;
    public static final int GL_COLOR_ATTACHMENT15 = 36079;
    public static final int GL_COLOR_ATTACHMENT16 = 36080;
    public static final int GL_COLOR_ATTACHMENT17 = 36081;
    public static final int GL_COLOR_ATTACHMENT18 = 36082;
    public static final int GL_COLOR_ATTACHMENT19 = 36083;
    public static final int GL_COLOR_ATTACHMENT20 = 36084;
    public static final int GL_COLOR_ATTACHMENT21 = 36085;
    public static final int GL_COLOR_ATTACHMENT22 = 36086;
    public static final int GL_COLOR_ATTACHMENT23 = 36087;
    public static final int GL_COLOR_ATTACHMENT24 = 36088;
    public static final int GL_COLOR_ATTACHMENT25 = 36089;
    public static final int GL_COLOR_ATTACHMENT26 = 36090;
    public static final int GL_COLOR_ATTACHMENT27 = 36091;
    public static final int GL_COLOR_ATTACHMENT28 = 36092;
    public static final int GL_COLOR_ATTACHMENT29 = 36093;
    public static final int GL_COLOR_ATTACHMENT30 = 36094;
    public static final int GL_COLOR_ATTACHMENT31 = 36095;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 36182;
    public static final int GL_MAX_SAMPLES = 36183;
    public static final int GL_HALF_FLOAT = 5131;
    public static final int GL_MAP_READ_BIT = 1;
    public static final int GL_MAP_WRITE_BIT = 2;
    public static final int GL_MAP_INVALIDATE_RANGE_BIT = 4;
    public static final int GL_MAP_INVALIDATE_BUFFER_BIT = 8;
    public static final int GL_MAP_FLUSH_EXPLICIT_BIT = 16;
    public static final int GL_MAP_UNSYNCHRONIZED_BIT = 32;
    public static final int GL_RG = 33319;
    public static final int GL_RG_INTEGER = 33320;
    public static final int GL_R8 = 33321;
    public static final int GL_RG8 = 33323;
    public static final int GL_R16F = 33325;
    public static final int GL_R32F = 33326;
    public static final int GL_RG16F = 33327;
    public static final int GL_RG32F = 33328;
    public static final int GL_R8I = 33329;
    public static final int GL_R8UI = 33330;
    public static final int GL_R16I = 33331;
    public static final int GL_R16UI = 33332;
    public static final int GL_R32I = 33333;
    public static final int GL_R32UI = 33334;
    public static final int GL_RG8I = 33335;
    public static final int GL_RG8UI = 33336;
    public static final int GL_RG16I = 33337;
    public static final int GL_RG16UI = 33338;
    public static final int GL_RG32I = 33339;
    public static final int GL_RG32UI = 33340;
    public static final int GL_VERTEX_ARRAY_BINDING = 34229;
    public static final int GL_R8_SNORM = 36756;
    public static final int GL_RG8_SNORM = 36757;
    public static final int GL_RGB8_SNORM = 36758;
    public static final int GL_RGBA8_SNORM = 36759;
    public static final int GL_SIGNED_NORMALIZED = 36764;
    public static final int GL_PRIMITIVE_RESTART_FIXED_INDEX = 36201;
    public static final int GL_COPY_READ_BUFFER = 36662;
    public static final int GL_COPY_WRITE_BUFFER = 36663;
    public static final int GL_COPY_READ_BUFFER_BINDING = 36662;
    public static final int GL_COPY_WRITE_BUFFER_BINDING = 36663;
    public static final int GL_UNIFORM_BUFFER = 35345;
    public static final int GL_UNIFORM_BUFFER_BINDING = 35368;
    public static final int GL_UNIFORM_BUFFER_START = 35369;
    public static final int GL_UNIFORM_BUFFER_SIZE = 35370;
    public static final int GL_MAX_VERTEX_UNIFORM_BLOCKS = 35371;
    public static final int GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 35373;
    public static final int GL_MAX_COMBINED_UNIFORM_BLOCKS = 35374;
    public static final int GL_MAX_UNIFORM_BUFFER_BINDINGS = 35375;
    public static final int GL_MAX_UNIFORM_BLOCK_SIZE = 35376;
    public static final int GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 35377;
    public static final int GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 35379;
    public static final int GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 35380;
    public static final int GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 35381;
    public static final int GL_ACTIVE_UNIFORM_BLOCKS = 35382;
    public static final int GL_UNIFORM_TYPE = 35383;
    public static final int GL_UNIFORM_SIZE = 35384;
    public static final int GL_UNIFORM_NAME_LENGTH = 35385;
    public static final int GL_UNIFORM_BLOCK_INDEX = 35386;
    public static final int GL_UNIFORM_OFFSET = 35387;
    public static final int GL_UNIFORM_ARRAY_STRIDE = 35388;
    public static final int GL_UNIFORM_MATRIX_STRIDE = 35389;
    public static final int GL_UNIFORM_IS_ROW_MAJOR = 35390;
    public static final int GL_UNIFORM_BLOCK_BINDING = 35391;
    public static final int GL_UNIFORM_BLOCK_DATA_SIZE = 35392;
    public static final int GL_UNIFORM_BLOCK_NAME_LENGTH = 35393;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 35394;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 35395;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 35396;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 35398;
    public static final int GL_INVALID_INDEX = -1;
    public static final int GL_MAX_VERTEX_OUTPUT_COMPONENTS = 37154;
    public static final int GL_MAX_FRAGMENT_INPUT_COMPONENTS = 37157;
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final int GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 35070;
    public static final int GL_ANY_SAMPLES_PASSED = 35887;
    public static final int GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 36202;
    public static final int GL_SAMPLER_BINDING = 35097;
    public static final int GL_RGB10_A2UI = 36975;
    public static final int GL_TEXTURE_SWIZZLE_R = 36418;
    public static final int GL_TEXTURE_SWIZZLE_G = 36419;
    public static final int GL_TEXTURE_SWIZZLE_B = 36420;
    public static final int GL_TEXTURE_SWIZZLE_A = 36421;
    public static final int GL_GREEN = 6404;
    public static final int GL_BLUE = 6405;
    public static final int GL_INT_2_10_10_10_REV = 36255;
    public static final int GL_TRANSFORM_FEEDBACK = 36386;
    public static final int GL_TRANSFORM_FEEDBACK_PAUSED = 36387;
    public static final int GL_TRANSFORM_FEEDBACK_ACTIVE = 36388;
    public static final int GL_TRANSFORM_FEEDBACK_BINDING = 36389;
    public static final int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 33367;
    public static final int GL_PROGRAM_BINARY_LENGTH = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS = 34815;
    public static final int GL_COMPRESSED_R11_EAC = 37488;
    public static final int GL_COMPRESSED_SIGNED_R11_EAC = 37489;
    public static final int GL_COMPRESSED_RG11_EAC = 37490;
    public static final int GL_COMPRESSED_SIGNED_RG11_EAC = 37491;
    public static final int GL_COMPRESSED_RGB8_ETC2 = 37492;
    public static final int GL_COMPRESSED_SRGB8_ETC2 = 37493;
    public static final int GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37494;
    public static final int GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37495;
    public static final int GL_COMPRESSED_RGBA8_ETC2_EAC = 37496;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 37497;
    public static final int GL_TEXTURE_IMMUTABLE_FORMAT = 37167;
    public static final int GL_MAX_ELEMENT_INDEX = 36203;
    public static final int GL_NUM_SAMPLE_COUNTS = 37760;
    public static final int GL_TEXTURE_IMMUTABLE_LEVELS = 33503;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public final long ReadBuffer;
    public final long DrawRangeElements;
    public final long TexImage3D;
    public final long TexSubImage3D;
    public final long CopyTexSubImage3D;
    public final long CompressedTexImage3D;
    public final long CompressedTexSubImage3D;
    public final long GenQueries;
    public final long DeleteQueries;
    public final long IsQuery;
    public final long BeginQuery;
    public final long EndQuery;
    public final long GetQueryiv;
    public final long GetQueryObjectuiv;
    public final long UnmapBuffer;
    public final long GetBufferPointerv;
    public final long DrawBuffers;
    public final long UniformMatrix2x3fv;
    public final long UniformMatrix3x2fv;
    public final long UniformMatrix2x4fv;
    public final long UniformMatrix4x2fv;
    public final long UniformMatrix3x4fv;
    public final long UniformMatrix4x3fv;
    public final long BlitFramebuffer;
    public final long RenderbufferStorageMultisample;
    public final long FramebufferTextureLayer;
    public final long MapBufferRange;
    public final long FlushMappedBufferRange;
    public final long BindVertexArray;
    public final long DeleteVertexArrays;
    public final long GenVertexArrays;
    public final long IsVertexArray;
    public final long GetIntegeri_v;
    public final long BeginTransformFeedback;
    public final long EndTransformFeedback;
    public final long BindBufferRange;
    public final long BindBufferBase;
    public final long TransformFeedbackVaryings;
    public final long GetTransformFeedbackVarying;
    public final long VertexAttribIPointer;
    public final long GetVertexAttribIiv;
    public final long GetVertexAttribIuiv;
    public final long VertexAttribI4i;
    public final long VertexAttribI4ui;
    public final long VertexAttribI4iv;
    public final long VertexAttribI4uiv;
    public final long GetUniformuiv;
    public final long GetFragDataLocation;
    public final long Uniform1ui;
    public final long Uniform2ui;
    public final long Uniform3ui;
    public final long Uniform4ui;
    public final long Uniform1uiv;
    public final long Uniform2uiv;
    public final long Uniform3uiv;
    public final long Uniform4uiv;
    public final long ClearBufferiv;
    public final long ClearBufferuiv;
    public final long ClearBufferfv;
    public final long ClearBufferfi;
    public final long GetStringi;
    public final long CopyBufferSubData;
    public final long GetUniformIndices;
    public final long GetActiveUniformsiv;
    public final long GetUniformBlockIndex;
    public final long GetActiveUniformBlockiv;
    public final long GetActiveUniformBlockName;
    public final long UniformBlockBinding;
    public final long DrawArraysInstanced;
    public final long DrawElementsInstanced;
    public final long FenceSync;
    public final long IsSync;
    public final long DeleteSync;
    public final long ClientWaitSync;
    public final long WaitSync;
    public final long GetInteger64v;
    public final long GetSynciv;
    public final long GetInteger64i_v;
    public final long GetBufferParameteri64v;
    public final long GenSamplers;
    public final long DeleteSamplers;
    public final long IsSampler;
    public final long BindSampler;
    public final long SamplerParameteri;
    public final long SamplerParameteriv;
    public final long SamplerParameterf;
    public final long SamplerParameterfv;
    public final long GetSamplerParameteriv;
    public final long GetSamplerParameterfv;
    public final long VertexAttribDivisor;
    public final long BindTransformFeedback;
    public final long DeleteTransformFeedbacks;
    public final long GenTransformFeedbacks;
    public final long IsTransformFeedback;
    public final long PauseTransformFeedback;
    public final long ResumeTransformFeedback;
    public final long GetProgramBinary;
    public final long ProgramBinary;
    public final long ProgramParameteri;
    public final long InvalidateFramebuffer;
    public final long InvalidateSubFramebuffer;
    public final long TexStorage2D;
    public final long TexStorage3D;
    public final long GetInternalformativ;

    protected GLES30() {
        throw new UnsupportedOperationException();
    }

    public GLES30(FunctionProvider provider) {
        this.ReadBuffer = provider.getFunctionAddress("glReadBuffer");
        this.DrawRangeElements = provider.getFunctionAddress("glDrawRangeElements");
        this.TexImage3D = provider.getFunctionAddress("glTexImage3D");
        this.TexSubImage3D = provider.getFunctionAddress("glTexSubImage3D");
        this.CopyTexSubImage3D = provider.getFunctionAddress("glCopyTexSubImage3D");
        this.CompressedTexImage3D = provider.getFunctionAddress("glCompressedTexImage3D");
        this.CompressedTexSubImage3D = provider.getFunctionAddress("glCompressedTexSubImage3D");
        this.GenQueries = provider.getFunctionAddress("glGenQueries");
        this.DeleteQueries = provider.getFunctionAddress("glDeleteQueries");
        this.IsQuery = provider.getFunctionAddress("glIsQuery");
        this.BeginQuery = provider.getFunctionAddress("glBeginQuery");
        this.EndQuery = provider.getFunctionAddress("glEndQuery");
        this.GetQueryiv = provider.getFunctionAddress("glGetQueryiv");
        this.GetQueryObjectuiv = provider.getFunctionAddress("glGetQueryObjectuiv");
        this.UnmapBuffer = provider.getFunctionAddress("glUnmapBuffer");
        this.GetBufferPointerv = provider.getFunctionAddress("glGetBufferPointerv");
        this.DrawBuffers = provider.getFunctionAddress("glDrawBuffers");
        this.UniformMatrix2x3fv = provider.getFunctionAddress("glUniformMatrix2x3fv");
        this.UniformMatrix3x2fv = provider.getFunctionAddress("glUniformMatrix3x2fv");
        this.UniformMatrix2x4fv = provider.getFunctionAddress("glUniformMatrix2x4fv");
        this.UniformMatrix4x2fv = provider.getFunctionAddress("glUniformMatrix4x2fv");
        this.UniformMatrix3x4fv = provider.getFunctionAddress("glUniformMatrix3x4fv");
        this.UniformMatrix4x3fv = provider.getFunctionAddress("glUniformMatrix4x3fv");
        this.BlitFramebuffer = provider.getFunctionAddress("glBlitFramebuffer");
        this.RenderbufferStorageMultisample = provider.getFunctionAddress("glRenderbufferStorageMultisample");
        this.FramebufferTextureLayer = provider.getFunctionAddress("glFramebufferTextureLayer");
        this.MapBufferRange = provider.getFunctionAddress("glMapBufferRange");
        this.FlushMappedBufferRange = provider.getFunctionAddress("glFlushMappedBufferRange");
        this.BindVertexArray = provider.getFunctionAddress("glBindVertexArray");
        this.DeleteVertexArrays = provider.getFunctionAddress("glDeleteVertexArrays");
        this.GenVertexArrays = provider.getFunctionAddress("glGenVertexArrays");
        this.IsVertexArray = provider.getFunctionAddress("glIsVertexArray");
        this.GetIntegeri_v = provider.getFunctionAddress("glGetIntegeri_v");
        this.BeginTransformFeedback = provider.getFunctionAddress("glBeginTransformFeedback");
        this.EndTransformFeedback = provider.getFunctionAddress("glEndTransformFeedback");
        this.BindBufferRange = provider.getFunctionAddress("glBindBufferRange");
        this.BindBufferBase = provider.getFunctionAddress("glBindBufferBase");
        this.TransformFeedbackVaryings = provider.getFunctionAddress("glTransformFeedbackVaryings");
        this.GetTransformFeedbackVarying = provider.getFunctionAddress("glGetTransformFeedbackVarying");
        this.VertexAttribIPointer = provider.getFunctionAddress("glVertexAttribIPointer");
        this.GetVertexAttribIiv = provider.getFunctionAddress("glGetVertexAttribIiv");
        this.GetVertexAttribIuiv = provider.getFunctionAddress("glGetVertexAttribIuiv");
        this.VertexAttribI4i = provider.getFunctionAddress("glVertexAttribI4i");
        this.VertexAttribI4ui = provider.getFunctionAddress("glVertexAttribI4ui");
        this.VertexAttribI4iv = provider.getFunctionAddress("glVertexAttribI4iv");
        this.VertexAttribI4uiv = provider.getFunctionAddress("glVertexAttribI4uiv");
        this.GetUniformuiv = provider.getFunctionAddress("glGetUniformuiv");
        this.GetFragDataLocation = provider.getFunctionAddress("glGetFragDataLocation");
        this.Uniform1ui = provider.getFunctionAddress("glUniform1ui");
        this.Uniform2ui = provider.getFunctionAddress("glUniform2ui");
        this.Uniform3ui = provider.getFunctionAddress("glUniform3ui");
        this.Uniform4ui = provider.getFunctionAddress("glUniform4ui");
        this.Uniform1uiv = provider.getFunctionAddress("glUniform1uiv");
        this.Uniform2uiv = provider.getFunctionAddress("glUniform2uiv");
        this.Uniform3uiv = provider.getFunctionAddress("glUniform3uiv");
        this.Uniform4uiv = provider.getFunctionAddress("glUniform4uiv");
        this.ClearBufferiv = provider.getFunctionAddress("glClearBufferiv");
        this.ClearBufferuiv = provider.getFunctionAddress("glClearBufferuiv");
        this.ClearBufferfv = provider.getFunctionAddress("glClearBufferfv");
        this.ClearBufferfi = provider.getFunctionAddress("glClearBufferfi");
        this.GetStringi = provider.getFunctionAddress("glGetStringi");
        this.CopyBufferSubData = provider.getFunctionAddress("glCopyBufferSubData");
        this.GetUniformIndices = provider.getFunctionAddress("glGetUniformIndices");
        this.GetActiveUniformsiv = provider.getFunctionAddress("glGetActiveUniformsiv");
        this.GetUniformBlockIndex = provider.getFunctionAddress("glGetUniformBlockIndex");
        this.GetActiveUniformBlockiv = provider.getFunctionAddress("glGetActiveUniformBlockiv");
        this.GetActiveUniformBlockName = provider.getFunctionAddress("glGetActiveUniformBlockName");
        this.UniformBlockBinding = provider.getFunctionAddress("glUniformBlockBinding");
        this.DrawArraysInstanced = provider.getFunctionAddress("glDrawArraysInstanced");
        this.DrawElementsInstanced = provider.getFunctionAddress("glDrawElementsInstanced");
        this.FenceSync = provider.getFunctionAddress("glFenceSync");
        this.IsSync = provider.getFunctionAddress("glIsSync");
        this.DeleteSync = provider.getFunctionAddress("glDeleteSync");
        this.ClientWaitSync = provider.getFunctionAddress("glClientWaitSync");
        this.WaitSync = provider.getFunctionAddress("glWaitSync");
        this.GetInteger64v = provider.getFunctionAddress("glGetInteger64v");
        this.GetSynciv = provider.getFunctionAddress("glGetSynciv");
        this.GetInteger64i_v = provider.getFunctionAddress("glGetInteger64i_v");
        this.GetBufferParameteri64v = provider.getFunctionAddress("glGetBufferParameteri64v");
        this.GenSamplers = provider.getFunctionAddress("glGenSamplers");
        this.DeleteSamplers = provider.getFunctionAddress("glDeleteSamplers");
        this.IsSampler = provider.getFunctionAddress("glIsSampler");
        this.BindSampler = provider.getFunctionAddress("glBindSampler");
        this.SamplerParameteri = provider.getFunctionAddress("glSamplerParameteri");
        this.SamplerParameteriv = provider.getFunctionAddress("glSamplerParameteriv");
        this.SamplerParameterf = provider.getFunctionAddress("glSamplerParameterf");
        this.SamplerParameterfv = provider.getFunctionAddress("glSamplerParameterfv");
        this.GetSamplerParameteriv = provider.getFunctionAddress("glGetSamplerParameteriv");
        this.GetSamplerParameterfv = provider.getFunctionAddress("glGetSamplerParameterfv");
        this.VertexAttribDivisor = provider.getFunctionAddress("glVertexAttribDivisor");
        this.BindTransformFeedback = provider.getFunctionAddress("glBindTransformFeedback");
        this.DeleteTransformFeedbacks = provider.getFunctionAddress("glDeleteTransformFeedbacks");
        this.GenTransformFeedbacks = provider.getFunctionAddress("glGenTransformFeedbacks");
        this.IsTransformFeedback = provider.getFunctionAddress("glIsTransformFeedback");
        this.PauseTransformFeedback = provider.getFunctionAddress("glPauseTransformFeedback");
        this.ResumeTransformFeedback = provider.getFunctionAddress("glResumeTransformFeedback");
        this.GetProgramBinary = provider.getFunctionAddress("glGetProgramBinary");
        this.ProgramBinary = provider.getFunctionAddress("glProgramBinary");
        this.ProgramParameteri = provider.getFunctionAddress("glProgramParameteri");
        this.InvalidateFramebuffer = provider.getFunctionAddress("glInvalidateFramebuffer");
        this.InvalidateSubFramebuffer = provider.getFunctionAddress("glInvalidateSubFramebuffer");
        this.TexStorage2D = provider.getFunctionAddress("glTexStorage2D");
        this.TexStorage3D = provider.getFunctionAddress("glTexStorage3D");
        this.GetInternalformativ = provider.getFunctionAddress("glGetInternalformativ");
    }

    public static GLES30 getInstance() {
        return GLES30.getInstance(GLES.getCapabilities());
    }

    public static GLES30 getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLES30);
    }

    static GLES30 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLES30")) {
            return null;
        }
        GLES30 funcs = new GLES30(provider);
        boolean supported = Checks.checkFunctions(funcs.ReadBuffer, funcs.DrawRangeElements, funcs.TexImage3D, funcs.TexSubImage3D, funcs.CopyTexSubImage3D, funcs.CompressedTexImage3D, funcs.CompressedTexSubImage3D, funcs.GenQueries, funcs.DeleteQueries, funcs.IsQuery, funcs.BeginQuery, funcs.EndQuery, funcs.GetQueryiv, funcs.GetQueryObjectuiv, funcs.UnmapBuffer, funcs.GetBufferPointerv, funcs.DrawBuffers, funcs.UniformMatrix2x3fv, funcs.UniformMatrix3x2fv, funcs.UniformMatrix2x4fv, funcs.UniformMatrix4x2fv, funcs.UniformMatrix3x4fv, funcs.UniformMatrix4x3fv, funcs.BlitFramebuffer, funcs.RenderbufferStorageMultisample, funcs.FramebufferTextureLayer, funcs.MapBufferRange, funcs.FlushMappedBufferRange, funcs.BindVertexArray, funcs.DeleteVertexArrays, funcs.GenVertexArrays, funcs.IsVertexArray, funcs.GetIntegeri_v, funcs.BeginTransformFeedback, funcs.EndTransformFeedback, funcs.BindBufferRange, funcs.BindBufferBase, funcs.TransformFeedbackVaryings, funcs.GetTransformFeedbackVarying, funcs.VertexAttribIPointer, funcs.GetVertexAttribIiv, funcs.GetVertexAttribIuiv, funcs.VertexAttribI4i, funcs.VertexAttribI4ui, funcs.VertexAttribI4iv, funcs.VertexAttribI4uiv, funcs.GetUniformuiv, funcs.GetFragDataLocation, funcs.Uniform1ui, funcs.Uniform2ui, funcs.Uniform3ui, funcs.Uniform4ui, funcs.Uniform1uiv, funcs.Uniform2uiv, funcs.Uniform3uiv, funcs.Uniform4uiv, funcs.ClearBufferiv, funcs.ClearBufferuiv, funcs.ClearBufferfv, funcs.ClearBufferfi, funcs.GetStringi, funcs.CopyBufferSubData, funcs.GetUniformIndices, funcs.GetActiveUniformsiv, funcs.GetUniformBlockIndex, funcs.GetActiveUniformBlockiv, funcs.GetActiveUniformBlockName, funcs.UniformBlockBinding, funcs.DrawArraysInstanced, funcs.DrawElementsInstanced, funcs.FenceSync, funcs.IsSync, funcs.DeleteSync, funcs.ClientWaitSync, funcs.WaitSync, funcs.GetInteger64v, funcs.GetSynciv, funcs.GetInteger64i_v, funcs.GetBufferParameteri64v, funcs.GenSamplers, funcs.DeleteSamplers, funcs.IsSampler, funcs.BindSampler, funcs.SamplerParameteri, funcs.SamplerParameteriv, funcs.SamplerParameterf, funcs.SamplerParameterfv, funcs.GetSamplerParameteriv, funcs.GetSamplerParameterfv, funcs.VertexAttribDivisor, funcs.BindTransformFeedback, funcs.DeleteTransformFeedbacks, funcs.GenTransformFeedbacks, funcs.IsTransformFeedback, funcs.PauseTransformFeedback, funcs.ResumeTransformFeedback, funcs.GetProgramBinary, funcs.ProgramBinary, funcs.ProgramParameteri, funcs.InvalidateFramebuffer, funcs.InvalidateSubFramebuffer, funcs.TexStorage2D, funcs.TexStorage3D, funcs.GetInternalformativ);
        return GLES.checkExtension("GLES30", funcs, supported);
    }

    public static void glReadBuffer(int src) {
        long __functionAddress = GLES30.getInstance().ReadBuffer;
        JNI.callIV(__functionAddress, src);
    }

    public static void nglDrawRangeElements(int mode, int start, int end, int count, int type, long indices) {
        long __functionAddress = GLES30.getInstance().DrawRangeElements;
        JNI.callIIIIIPV(__functionAddress, mode, start, end, count, type, indices);
    }

    public static void glDrawRangeElements(int mode, int start, int end, int count, int type, ByteBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES30.nglDrawRangeElements(mode, start, end, count, type, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, int count, int type, long indicesOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        GLES30.nglDrawRangeElements(mode, start, end, count, type, indicesOffset);
    }

    public static void glDrawRangeElements(int mode, int start, int end, int type, ByteBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, ByteBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, ShortBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, IntBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices));
    }

    public static void nglTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixels) {
        long __functionAddress = GLES30.getInstance().TexImage3D;
        JNI.callIIIIIIIIIPV(__functionAddress, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES30.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixelsOffset);
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void nglTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        long __functionAddress = GLES30.getInstance().TexSubImage3D;
        JNI.callIIIIIIIIIIPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixelsOffset);
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        long __functionAddress = GLES30.getInstance().CopyTexSubImage3D;
        JNI.callIIIIIIIIIV(__functionAddress, target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }

    public static void nglCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long data) {
        long __functionAddress = GLES30.getInstance().CompressedTexImage3D;
        JNI.callIIIIIIIIPV(__functionAddress, target, level, internalformat, width, height, depth, border, imageSize, data);
    }

    public static void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            if (data != null) {
                Checks.checkBuffer((Buffer)data, imageSize);
            }
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, MemoryUtil.memAddressSafe(data));
    }

    public static void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES30.nglCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, dataOffset);
    }

    public static void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglCompressedTexImage3D(target, level, internalformat, width, height, depth, border, data == null ? 0 : data.remaining(), MemoryUtil.memAddressSafe(data));
    }

    public static void nglCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        long __functionAddress = GLES30.getInstance().CompressedTexSubImage3D;
        JNI.callIIIIIIIIIIPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }

    public static void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES30.nglCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataOffset);
    }

    public static void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES30.nglCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglGenQueries(int n, long ids) {
        long __functionAddress = GLES30.getInstance().GenQueries;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glGenQueries(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GLES30.nglGenQueries(n, MemoryUtil.memAddress(ids));
    }

    public static void glGenQueries(IntBuffer ids) {
        GLES30.nglGenQueries(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glGenQueries() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        GLES30.nglGenQueries(1, __buffer.address(ids));
        return __buffer.intValue(ids);
    }

    public static void nglDeleteQueries(int n, long ids) {
        long __functionAddress = GLES30.getInstance().DeleteQueries;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glDeleteQueries(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GLES30.nglDeleteQueries(n, MemoryUtil.memAddress(ids));
    }

    public static void glDeleteQueries(IntBuffer ids) {
        GLES30.nglDeleteQueries(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static void glDeleteQueries(int id) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        GLES30.nglDeleteQueries(1, __buffer.address(ids));
    }

    public static boolean glIsQuery(int id) {
        long __functionAddress = GLES30.getInstance().IsQuery;
        return JNI.callIZ(__functionAddress, id);
    }

    public static void glBeginQuery(int target, int id) {
        long __functionAddress = GLES30.getInstance().BeginQuery;
        JNI.callIIV(__functionAddress, target, id);
    }

    public static void glEndQuery(int target) {
        long __functionAddress = GLES30.getInstance().EndQuery;
        JNI.callIV(__functionAddress, target);
    }

    public static void nglGetQueryiv(int target, int pname, long params) {
        long __functionAddress = GLES30.getInstance().GetQueryiv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetQueryiv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES30.nglGetQueryiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryiv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES30.nglGetQueryiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryi(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES30.nglGetQueryiv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetQueryObjectuiv(int id, int pname, long params) {
        long __functionAddress = GLES30.getInstance().GetQueryObjectuiv;
        JNI.callIIPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectuiv(int id, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES30.nglGetQueryObjectuiv(id, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryObjectuiv(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES30.nglGetQueryObjectuiv(id, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryObjectui(int id, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES30.nglGetQueryObjectuiv(id, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static boolean glUnmapBuffer(int target) {
        long __functionAddress = GLES30.getInstance().UnmapBuffer;
        return JNI.callIZ(__functionAddress, target);
    }

    public static void nglGetBufferPointerv(int target, int pname, long params) {
        long __functionAddress = GLES30.getInstance().GetBufferPointerv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferPointerv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1 << Pointer.POINTER_SHIFT);
        }
        GLES30.nglGetBufferPointerv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferPointerv(int target, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        GLES30.nglGetBufferPointerv(target, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetBufferPointer(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.pointerParam();
        GLES30.nglGetBufferPointerv(target, pname, __buffer.address(params));
        return __buffer.pointerValue(params);
    }

    public static void nglDrawBuffers(int n, long bufs) {
        long __functionAddress = GLES30.getInstance().DrawBuffers;
        JNI.callIPV(__functionAddress, n, bufs);
    }

    public static void glDrawBuffers(int n, ByteBuffer bufs) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)bufs, n << 2);
        }
        GLES30.nglDrawBuffers(n, MemoryUtil.memAddress(bufs));
    }

    public static void glDrawBuffers(IntBuffer bufs) {
        GLES30.nglDrawBuffers(bufs.remaining(), MemoryUtil.memAddress(bufs));
    }

    public static void glDrawBuffers(int buf) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufs = __buffer.intParam(buf);
        GLES30.nglDrawBuffers(1, __buffer.address(bufs));
    }

    public static void nglUniformMatrix2x3fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES30.getInstance().UniformMatrix2x3fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2x3fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        GLES30.nglUniformMatrix2x3fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2x3fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix2x3fv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3x2fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES30.getInstance().UniformMatrix3x2fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3x2fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        GLES30.nglUniformMatrix3x2fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3x2fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix3x2fv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2x4fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES30.getInstance().UniformMatrix2x4fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2x4fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        GLES30.nglUniformMatrix2x4fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2x4fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix2x4fv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4x2fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES30.getInstance().UniformMatrix4x2fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4x2fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        GLES30.nglUniformMatrix4x2fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4x2fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix4x2fv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3x4fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES30.getInstance().UniformMatrix3x4fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3x4fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        GLES30.nglUniformMatrix3x4fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3x4fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix3x4fv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4x3fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES30.getInstance().UniformMatrix4x3fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4x3fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        GLES30.nglUniformMatrix4x3fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4x3fv(int location, boolean transpose, FloatBuffer value) {
        GLES30.nglUniformMatrix4x3fv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        long __functionAddress = GLES30.getInstance().BlitFramebuffer;
        JNI.callIIIIIIIIIIV(__functionAddress, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }

    public static void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height) {
        long __functionAddress = GLES30.getInstance().RenderbufferStorageMultisample;
        JNI.callIIIIIV(__functionAddress, target, samples, internalformat, width, height);
    }

    public static void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer) {
        long __functionAddress = GLES30.getInstance().FramebufferTextureLayer;
        JNI.callIIIIIV(__functionAddress, target, attachment, texture, level, layer);
    }

    public static long nglMapBufferRange(int target, long offset, long length, int access) {
        long __functionAddress = GLES30.getInstance().MapBufferRange;
        return JNI.callIPPIP(__functionAddress, target, offset, length, access);
    }

    public static ByteBuffer glMapBufferRange(int target, long offset, long length, int access) {
        long __result = GLES30.nglMapBufferRange(target, offset, length, access);
        return MemoryUtil.memByteBuffer(__result, (int)length);
    }

    public static ByteBuffer glMapBufferRange(int target, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = GLES30.nglMapBufferRange(target, offset, length, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static void glFlushMappedBufferRange(int target, long offset, long length) {
        long __functionAddress = GLES30.getInstance().FlushMappedBufferRange;
        JNI.callIPPV(__functionAddress, target, offset, length);
    }

    public static void glBindVertexArray(int array) {
        long __functionAddress = GLES30.getInstance().BindVertexArray;
        JNI.callIV(__functionAddress, array);
    }

    public static void nglDeleteVertexArrays(int n, long arrays) {
        long __functionAddress = GLES30.getInstance().DeleteVertexArrays;
        JNI.callIPV(__functionAddress, n, arrays);
    }

    public static void glDeleteVertexArrays(int n, ByteBuffer arrays) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, n << 2);
        }
        GLES30.nglDeleteVertexArrays(n, MemoryUtil.memAddress(arrays));
    }

    public static void glDeleteVertexArrays(IntBuffer arrays) {
        GLES30.nglDeleteVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    public static void glDeleteVertexArrays(int array) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arrays = __buffer.intParam(array);
        GLES30.nglDeleteVertexArrays(1, __buffer.address(arrays));
    }

    public static void nglGenVertexArrays(int n, long arrays) {
        long __functionAddress = GLES30.getInstance().GenVertexArrays;
        JNI.callIPV(__functionAddress, n, arrays);
    }

    public static void glGenVertexArrays(int n, ByteBuffer arrays) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, n << 2);
        }
        GLES30.nglGenVertexArrays(n, MemoryUtil.memAddress(arrays));
    }

    public static void glGenVertexArrays(IntBuffer arrays) {
        GLES30.nglGenVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    public static int glGenVertexArrays() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arrays = __buffer.intParam();
        GLES30.nglGenVertexArrays(1, __buffer.address(arrays));
        return __buffer.intValue(arrays);
    }

    public static boolean glIsVertexArray(int array) {
        long __functionAddress = GLES30.getInstance().IsVertexArray;
        return JNI.callIZ(__functionAddress, array);
    }

    public static void nglGetIntegeri_v(int target, int index, long data) {
        long __functionAddress = GLES30.getInstance().GetIntegeri_v;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetIntegeri_v(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        GLES30.nglGetIntegeri_v(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetIntegeri_v(int target, int index, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GLES30.nglGetIntegeri_v(target, index, MemoryUtil.memAddress(data));
    }

    public static int glGetIntegeri(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.intParam();
        GLES30.nglGetIntegeri_v(target, index, __buffer.address(data));
        return __buffer.intValue(data);
    }

    public static void glBeginTransformFeedback(int primitiveMode) {
        long __functionAddress = GLES30.getInstance().BeginTransformFeedback;
        JNI.callIV(__functionAddress, primitiveMode);
    }

    public static void glEndTransformFeedback() {
        long __functionAddress = GLES30.getInstance().EndTransformFeedback;
        JNI.callV(__functionAddress);
    }

    public static void glBindBufferRange(int target, int index, int buffer, long offset, long size) {
        long __functionAddress = GLES30.getInstance().BindBufferRange;
        JNI.callIIIPPV(__functionAddress, target, index, buffer, offset, size);
    }

    public static void glBindBufferBase(int target, int index, int buffer) {
        long __functionAddress = GLES30.getInstance().BindBufferBase;
        JNI.callIIIV(__functionAddress, target, index, buffer);
    }

    public static void nglTransformFeedbackVaryings(int program, int count, long varyings, int bufferMode) {
        long __functionAddress = GLES30.getInstance().TransformFeedbackVaryings;
        JNI.callIIPIV(__functionAddress, program, count, varyings, bufferMode);
    }

    public static void glTransformFeedbackVaryings(int program, int count, ByteBuffer varyings, int bufferMode) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)varyings, count << Pointer.POINTER_SHIFT);
        }
        GLES30.nglTransformFeedbackVaryings(program, count, MemoryUtil.memAddress(varyings), bufferMode);
    }

    public static void glTransformFeedbackVaryings(int program, PointerBuffer varyings, int bufferMode) {
        GLES30.nglTransformFeedbackVaryings(program, varyings.remaining(), MemoryUtil.memAddress(varyings), bufferMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glTransformFeedbackVaryings(int program, CharSequence[] varyings, int bufferMode) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int varyingsAddress = __buffer.pointerArrayParamASCII(varyings);
        try {
            GLES30.nglTransformFeedbackVaryings(program, varyings.length, __buffer.address(varyingsAddress), bufferMode);
        }
        finally {
            __buffer.pointerArrayFree(varyingsAddress, varyings.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glTransformFeedbackVaryings(int program, CharSequence varying, int bufferMode) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int varyingsAddress = __buffer.pointerArrayParamASCII(varying);
        try {
            GLES30.nglTransformFeedbackVaryings(program, 1, __buffer.address(varyingsAddress), bufferMode);
        }
        finally {
            __buffer.pointerArrayFree(varyingsAddress, 1);
        }
    }

    public static void nglGetTransformFeedbackVarying(int program, int index, int bufSize, long length, long size, long type, long name) {
        long __functionAddress = GLES30.getInstance().GetTransformFeedbackVarying;
        JNI.callIIIPPPPV(__functionAddress, program, index, bufSize, length, size, type, name);
    }

    public static void glGetTransformFeedbackVarying(int program, int index, int bufSize, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        GLES30.nglGetTransformFeedbackVarying(program, index, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetTransformFeedbackVarying(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        GLES30.nglGetTransformFeedbackVarying(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetTransformFeedbackVarying(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        GLES30.nglGetTransformFeedbackVarying(program, index, bufSize, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetTransformFeedbackVarying(int program, int index, IntBuffer size, IntBuffer type) {
        int bufSize = GLES20.glGetProgrami(program, 35958);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        GLES30.nglGetTransformFeedbackVarying(program, index, bufSize, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglVertexAttribIPointer(int index, int size, int type, int stride, long pointer) {
        long __functionAddress = GLES30.getInstance().VertexAttribIPointer;
        JNI.callIIIIPV(__functionAddress, index, size, type, stride, pointer);
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES30.nglVertexAttribIPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, long pointerOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, true);
        }
        GLES30.nglVertexAttribIPointer(index, size, type, stride, pointerOffset);
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, ShortBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES30.nglVertexAttribIPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, IntBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES30.nglVertexAttribIPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void nglGetVertexAttribIiv(int index, int pname, long params) {
        long __functionAddress = GLES30.getInstance().GetVertexAttribIiv;
        JNI.callIIPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribIiv(int index, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES30.nglGetVertexAttribIiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribIiv(int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES30.nglGetVertexAttribIiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetVertexAttribIi(int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES30.nglGetVertexAttribIiv(index, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetVertexAttribIuiv(int index, int pname, long params) {
        long __functionAddress = GLES30.getInstance().GetVertexAttribIuiv;
        JNI.callIIPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribIuiv(int index, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES30.nglGetVertexAttribIuiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribIuiv(int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES30.nglGetVertexAttribIuiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetVertexAttribIui(int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES30.nglGetVertexAttribIuiv(index, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void glVertexAttribI4i(int index, int x, int y, int z, int w) {
        long __functionAddress = GLES30.getInstance().VertexAttribI4i;
        JNI.callIIIIIV(__functionAddress, index, x, y, z, w);
    }

    public static void glVertexAttribI4ui(int index, int x, int y, int z, int w) {
        long __functionAddress = GLES30.getInstance().VertexAttribI4ui;
        JNI.callIIIIIV(__functionAddress, index, x, y, z, w);
    }

    public static void nglVertexAttribI4iv(int index, long v) {
        long __functionAddress = GLES30.getInstance().VertexAttribI4iv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribI4iv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GLES30.nglVertexAttribI4iv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribI4iv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GLES30.nglVertexAttribI4iv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribI4uiv(int index, long v) {
        long __functionAddress = GLES30.getInstance().VertexAttribI4uiv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribI4uiv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GLES30.nglVertexAttribI4uiv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribI4uiv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GLES30.nglVertexAttribI4uiv(index, MemoryUtil.memAddress(v));
    }

    public static void nglGetUniformuiv(int program, int location, long params) {
        long __functionAddress = GLES30.getInstance().GetUniformuiv;
        JNI.callIIPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformuiv(int program, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES30.nglGetUniformuiv(program, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformuiv(int program, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES30.nglGetUniformuiv(program, location, MemoryUtil.memAddress(params));
    }

    public static int glGetUniformui(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES30.nglGetUniformuiv(program, location, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static int nglGetFragDataLocation(int program, long name) {
        long __functionAddress = GLES30.getInstance().GetFragDataLocation;
        return JNI.callIPI(__functionAddress, program, name);
    }

    public static int glGetFragDataLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GLES30.nglGetFragDataLocation(program, MemoryUtil.memAddress(name));
    }

    public static int glGetFragDataLocation(int program, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GLES30.nglGetFragDataLocation(program, __buffer.address(nameEncoded));
    }

    public static void glUniform1ui(int location, int v0) {
        long __functionAddress = GLES30.getInstance().Uniform1ui;
        JNI.callIIV(__functionAddress, location, v0);
    }

    public static void glUniform2ui(int location, int v0, int v1) {
        long __functionAddress = GLES30.getInstance().Uniform2ui;
        JNI.callIIIV(__functionAddress, location, v0, v1);
    }

    public static void glUniform3ui(int location, int v0, int v1, int v2) {
        long __functionAddress = GLES30.getInstance().Uniform3ui;
        JNI.callIIIIV(__functionAddress, location, v0, v1, v2);
    }

    public static void glUniform4ui(int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GLES30.getInstance().Uniform4ui;
        JNI.callIIIIIV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void nglUniform1uiv(int location, int count, long value) {
        long __functionAddress = GLES30.getInstance().Uniform1uiv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform1uiv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GLES30.nglUniform1uiv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1uiv(int location, IntBuffer value) {
        GLES30.nglUniform1uiv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2uiv(int location, int count, long value) {
        long __functionAddress = GLES30.getInstance().Uniform2uiv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform2uiv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GLES30.nglUniform2uiv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2uiv(int location, IntBuffer value) {
        GLES30.nglUniform2uiv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3uiv(int location, int count, long value) {
        long __functionAddress = GLES30.getInstance().Uniform3uiv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform3uiv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        GLES30.nglUniform3uiv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3uiv(int location, IntBuffer value) {
        GLES30.nglUniform3uiv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4uiv(int location, int count, long value) {
        long __functionAddress = GLES30.getInstance().Uniform4uiv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform4uiv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GLES30.nglUniform4uiv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4uiv(int location, IntBuffer value) {
        GLES30.nglUniform4uiv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglClearBufferiv(int buffer, int drawbuffer, long value) {
        long __functionAddress = GLES30.getInstance().ClearBufferiv;
        JNI.callIIPV(__functionAddress, buffer, drawbuffer, value);
    }

    public static void glClearBufferiv(int buffer, int drawbuffer, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GLES30.nglClearBufferiv(buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearBufferiv(int buffer, int drawbuffer, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GLES30.nglClearBufferiv(buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void nglClearBufferuiv(int buffer, int drawbuffer, long value) {
        long __functionAddress = GLES30.getInstance().ClearBufferuiv;
        JNI.callIIPV(__functionAddress, buffer, drawbuffer, value);
    }

    public static void glClearBufferuiv(int buffer, int drawbuffer, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GLES30.nglClearBufferuiv(buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearBufferuiv(int buffer, int drawbuffer, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GLES30.nglClearBufferuiv(buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void nglClearBufferfv(int buffer, int drawbuffer, long value) {
        long __functionAddress = GLES30.getInstance().ClearBufferfv;
        JNI.callIIPV(__functionAddress, buffer, drawbuffer, value);
    }

    public static void glClearBufferfv(int buffer, int drawbuffer, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GLES30.nglClearBufferfv(buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearBufferfv(int buffer, int drawbuffer, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GLES30.nglClearBufferfv(buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil) {
        long __functionAddress = GLES30.getInstance().ClearBufferfi;
        JNI.callIIFIV(__functionAddress, buffer, drawbuffer, depth, stencil);
    }

    public static long nglGetStringi(int name, int index) {
        long __functionAddress = GLES30.getInstance().GetStringi;
        return JNI.callIIP(__functionAddress, name, index);
    }

    public static String glGetStringi(int name, int index) {
        long __result = GLES30.nglGetStringi(name, index);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size) {
        long __functionAddress = GLES30.getInstance().CopyBufferSubData;
        JNI.callIIPPPV(__functionAddress, readTarget, writeTarget, readOffset, writeOffset, size);
    }

    public static void nglGetUniformIndices(int program, int uniformCount, long uniformNames, long uniformIndices) {
        long __functionAddress = GLES30.getInstance().GetUniformIndices;
        JNI.callIIPPV(__functionAddress, program, uniformCount, uniformNames, uniformIndices);
    }

    public static void glGetUniformIndices(int program, int uniformCount, ByteBuffer uniformNames, ByteBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformNames, uniformCount << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)uniformIndices, uniformCount << 2);
        }
        GLES30.nglGetUniformIndices(program, uniformCount, MemoryUtil.memAddress(uniformNames), MemoryUtil.memAddress(uniformIndices));
    }

    public static void glGetUniformIndices(int program, PointerBuffer uniformNames, IntBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, uniformNames.remaining());
        }
        GLES30.nglGetUniformIndices(program, uniformNames.remaining(), MemoryUtil.memAddress(uniformNames), MemoryUtil.memAddress(uniformIndices));
    }

    public static void nglGetActiveUniformsiv(int program, int uniformCount, long uniformIndices, int pname, long params) {
        long __functionAddress = GLES30.getInstance().GetActiveUniformsiv;
        JNI.callIIPIPV(__functionAddress, program, uniformCount, uniformIndices, pname, params);
    }

    public static void glGetActiveUniformsiv(int program, int uniformCount, ByteBuffer uniformIndices, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, uniformCount << 2);
            Checks.checkBuffer((Buffer)params, uniformCount << 2);
        }
        GLES30.nglGetActiveUniformsiv(program, uniformCount, MemoryUtil.memAddress(uniformIndices), pname, MemoryUtil.memAddress(params));
    }

    public static void glGetActiveUniformsiv(int program, IntBuffer uniformIndices, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, uniformIndices.remaining());
        }
        GLES30.nglGetActiveUniformsiv(program, uniformIndices.remaining(), MemoryUtil.memAddress(uniformIndices), pname, MemoryUtil.memAddress(params));
    }

    public static int nglGetUniformBlockIndex(int program, long uniformBlockName) {
        long __functionAddress = GLES30.getInstance().GetUniformBlockIndex;
        return JNI.callIPI(__functionAddress, program, uniformBlockName);
    }

    public static int glGetUniformBlockIndex(int program, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(uniformBlockName);
        }
        return GLES30.nglGetUniformBlockIndex(program, MemoryUtil.memAddress(uniformBlockName));
    }

    public static int glGetUniformBlockIndex(int program, CharSequence uniformBlockName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int uniformBlockNameEncoded = __buffer.stringParamASCII(uniformBlockName, true);
        return GLES30.nglGetUniformBlockIndex(program, __buffer.address(uniformBlockNameEncoded));
    }

    public static void nglGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, long params) {
        long __functionAddress = GLES30.getInstance().GetActiveUniformBlockiv;
        JNI.callIIIPV(__functionAddress, program, uniformBlockIndex, pname, params);
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES30.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES30.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetActiveUniformBlocki(int program, int uniformBlockIndex, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES30.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, long length, long uniformBlockName) {
        long __functionAddress = GLES30.getInstance().GetActiveUniformBlockName;
        JNI.callIIIPPV(__functionAddress, program, uniformBlockIndex, bufSize, length, uniformBlockName);
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, ByteBuffer length, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformBlockName, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GLES30.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformBlockName));
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, IntBuffer length, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES30.nglGetActiveUniformBlockName(program, uniformBlockIndex, uniformBlockName.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformBlockName));
    }

    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int uniformBlockName = __buffer.bufferParam(bufSize);
        GLES30.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, __buffer.address(length), __buffer.address(uniformBlockName));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), uniformBlockName);
    }

    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex) {
        int bufSize = GLES30.glGetActiveUniformBlocki(program, uniformBlockIndex, 35393);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int uniformBlockName = __buffer.bufferParam(bufSize);
        GLES30.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, __buffer.address(length), __buffer.address(uniformBlockName));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), uniformBlockName);
    }

    public static void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        long __functionAddress = GLES30.getInstance().UniformBlockBinding;
        JNI.callIIIV(__functionAddress, program, uniformBlockIndex, uniformBlockBinding);
    }

    public static void glDrawArraysInstanced(int mode, int first, int count, int instancecount) {
        long __functionAddress = GLES30.getInstance().DrawArraysInstanced;
        JNI.callIIIIV(__functionAddress, mode, first, count, instancecount);
    }

    public static void nglDrawElementsInstanced(int mode, int count, int type, long indices, int instancecount) {
        long __functionAddress = GLES30.getInstance().DrawElementsInstanced;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, instancecount);
    }

    public static void glDrawElementsInstanced(int mode, int count, int type, ByteBuffer indices, int instancecount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES30.nglDrawElementsInstanced(mode, count, type, MemoryUtil.memAddress(indices), instancecount);
    }

    public static void glDrawElementsInstanced(int mode, int count, int type, long indicesOffset, int instancecount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        GLES30.nglDrawElementsInstanced(mode, count, type, indicesOffset, instancecount);
    }

    public static void glDrawElementsInstanced(int mode, int type, ByteBuffer indices, int instancecount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES30.nglDrawElementsInstanced(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount);
    }

    public static void glDrawElementsInstanced(int mode, ByteBuffer indices, int instancecount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES30.nglDrawElementsInstanced(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount);
    }

    public static void glDrawElementsInstanced(int mode, ShortBuffer indices, int instancecount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES30.nglDrawElementsInstanced(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount);
    }

    public static void glDrawElementsInstanced(int mode, IntBuffer indices, int instancecount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES30.nglDrawElementsInstanced(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount);
    }

    public static long glFenceSync(int condition, int flags) {
        long __functionAddress = GLES30.getInstance().FenceSync;
        return JNI.callIIP(__functionAddress, condition, flags);
    }

    public static boolean glIsSync(long sync) {
        long __functionAddress = GLES30.getInstance().IsSync;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        return JNI.callPZ(__functionAddress, sync);
    }

    public static void glDeleteSync(long sync) {
        long __functionAddress = GLES30.getInstance().DeleteSync;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        JNI.callPV(__functionAddress, sync);
    }

    public static int glClientWaitSync(long sync, int flags, long timeout) {
        long __functionAddress = GLES30.getInstance().ClientWaitSync;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        return JNI.callPIJI(__functionAddress, sync, flags, timeout);
    }

    public static void glWaitSync(long sync, int flags, long timeout) {
        long __functionAddress = GLES30.getInstance().WaitSync;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        JNI.callPIJV(__functionAddress, sync, flags, timeout);
    }

    public static void nglGetInteger64v(int pname, long data) {
        long __functionAddress = GLES30.getInstance().GetInteger64v;
        JNI.callIPV(__functionAddress, pname, data);
    }

    public static void glGetInteger64v(int pname, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 8);
        }
        GLES30.nglGetInteger64v(pname, MemoryUtil.memAddress(data));
    }

    public static void glGetInteger64v(int pname, LongBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GLES30.nglGetInteger64v(pname, MemoryUtil.memAddress(data));
    }

    public static long glGetInteger64(int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.longParam();
        GLES30.nglGetInteger64v(pname, __buffer.address(data));
        return __buffer.longValue(data);
    }

    public static void nglGetSynciv(long sync, int pname, int bufSize, long length, long values) {
        long __functionAddress = GLES30.getInstance().GetSynciv;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        JNI.callPIIPPV(__functionAddress, sync, pname, bufSize, length, values);
    }

    public static void glGetSynciv(long sync, int pname, int bufSize, ByteBuffer length, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, bufSize << 2);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GLES30.nglGetSynciv(sync, pname, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    public static void glGetSynciv(long sync, int pname, IntBuffer length, IntBuffer values) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES30.nglGetSynciv(sync, pname, values.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    public static int glGetSynci(long sync, int pname, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.intParam();
        GLES30.nglGetSynciv(sync, pname, 1, MemoryUtil.memAddressSafe(length), __buffer.address(values));
        return __buffer.intValue(values);
    }

    public static void nglGetInteger64i_v(int target, int index, long data) {
        long __functionAddress = GLES30.getInstance().GetInteger64i_v;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetInteger64i_v(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 8);
        }
        GLES30.nglGetInteger64i_v(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetInteger64i_v(int target, int index, LongBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GLES30.nglGetInteger64i_v(target, index, MemoryUtil.memAddress(data));
    }

    public static long glGetInteger64i(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.longParam();
        GLES30.nglGetInteger64i_v(target, index, __buffer.address(data));
        return __buffer.longValue(data);
    }

    public static void nglGetBufferParameteri64v(int target, int pname, long params) {
        long __functionAddress = GLES30.getInstance().GetBufferParameteri64v;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferParameteri64v(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        GLES30.nglGetBufferParameteri64v(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferParameteri64v(int target, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES30.nglGetBufferParameteri64v(target, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetBufferParameteri64(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        GLES30.nglGetBufferParameteri64v(target, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static void nglGenSamplers(int count, long samplers) {
        long __functionAddress = GLES30.getInstance().GenSamplers;
        JNI.callIPV(__functionAddress, count, samplers);
    }

    public static void glGenSamplers(int count, ByteBuffer samplers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)samplers, count << 2);
        }
        GLES30.nglGenSamplers(count, MemoryUtil.memAddress(samplers));
    }

    public static void glGenSamplers(IntBuffer samplers) {
        GLES30.nglGenSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    public static int glGenSamplers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int samplers = __buffer.intParam();
        GLES30.nglGenSamplers(1, __buffer.address(samplers));
        return __buffer.intValue(samplers);
    }

    public static void nglDeleteSamplers(int count, long samplers) {
        long __functionAddress = GLES30.getInstance().DeleteSamplers;
        JNI.callIPV(__functionAddress, count, samplers);
    }

    public static void glDeleteSamplers(int count, ByteBuffer samplers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)samplers, count << 2);
        }
        GLES30.nglDeleteSamplers(count, MemoryUtil.memAddress(samplers));
    }

    public static void glDeleteSamplers(IntBuffer samplers) {
        GLES30.nglDeleteSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    public static void glDeleteSamplers(int sampler) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int samplers = __buffer.intParam(sampler);
        GLES30.nglDeleteSamplers(1, __buffer.address(samplers));
    }

    public static boolean glIsSampler(int sampler) {
        long __functionAddress = GLES30.getInstance().IsSampler;
        return JNI.callIZ(__functionAddress, sampler);
    }

    public static void glBindSampler(int unit, int sampler) {
        long __functionAddress = GLES30.getInstance().BindSampler;
        JNI.callIIV(__functionAddress, unit, sampler);
    }

    public static void glSamplerParameteri(int sampler, int pname, int param) {
        long __functionAddress = GLES30.getInstance().SamplerParameteri;
        JNI.callIIIV(__functionAddress, sampler, pname, param);
    }

    public static void nglSamplerParameteriv(int sampler, int pname, long param) {
        long __functionAddress = GLES30.getInstance().SamplerParameteriv;
        JNI.callIIPV(__functionAddress, sampler, pname, param);
    }

    public static void glSamplerParameteriv(int sampler, int pname, ByteBuffer param) {
        GLES30.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(param));
    }

    public static void glSamplerParameteriv(int sampler, int pname, IntBuffer param) {
        GLES30.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(param));
    }

    public static void glSamplerParameterf(int sampler, int pname, float param) {
        long __functionAddress = GLES30.getInstance().SamplerParameterf;
        JNI.callIIFV(__functionAddress, sampler, pname, param);
    }

    public static void nglSamplerParameterfv(int sampler, int pname, long param) {
        long __functionAddress = GLES30.getInstance().SamplerParameterfv;
        JNI.callIIPV(__functionAddress, sampler, pname, param);
    }

    public static void glSamplerParameterfv(int sampler, int pname, ByteBuffer param) {
        GLES30.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(param));
    }

    public static void glSamplerParameterfv(int sampler, int pname, FloatBuffer param) {
        GLES30.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(param));
    }

    public static void nglGetSamplerParameteriv(int sampler, int pname, long params) {
        long __functionAddress = GLES30.getInstance().GetSamplerParameteriv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameteriv(int sampler, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES30.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES30.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetSamplerParameteri(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES30.nglGetSamplerParameteriv(sampler, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetSamplerParameterfv(int sampler, int pname, long params) {
        long __functionAddress = GLES30.getInstance().GetSamplerParameterfv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterfv(int sampler, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES30.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES30.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetSamplerParameterf(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GLES30.nglGetSamplerParameterfv(sampler, pname, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void glVertexAttribDivisor(int index, int divisor) {
        long __functionAddress = GLES30.getInstance().VertexAttribDivisor;
        JNI.callIIV(__functionAddress, index, divisor);
    }

    public static void glBindTransformFeedback(int target, int id) {
        long __functionAddress = GLES30.getInstance().BindTransformFeedback;
        JNI.callIIV(__functionAddress, target, id);
    }

    public static void nglDeleteTransformFeedbacks(int n, long ids) {
        long __functionAddress = GLES30.getInstance().DeleteTransformFeedbacks;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glDeleteTransformFeedbacks(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GLES30.nglDeleteTransformFeedbacks(n, MemoryUtil.memAddress(ids));
    }

    public static void glDeleteTransformFeedbacks(IntBuffer ids) {
        GLES30.nglDeleteTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static void glDeleteTransformFeedbacks(int id) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        GLES30.nglDeleteTransformFeedbacks(1, __buffer.address(ids));
    }

    public static void nglGenTransformFeedbacks(int n, long ids) {
        long __functionAddress = GLES30.getInstance().GenTransformFeedbacks;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glGenTransformFeedbacks(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GLES30.nglGenTransformFeedbacks(n, MemoryUtil.memAddress(ids));
    }

    public static void glGenTransformFeedbacks(IntBuffer ids) {
        GLES30.nglGenTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glGenTransformFeedbacks() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        GLES30.nglGenTransformFeedbacks(1, __buffer.address(ids));
        return __buffer.intValue(ids);
    }

    public static boolean glIsTransformFeedback(int id) {
        long __functionAddress = GLES30.getInstance().IsTransformFeedback;
        return JNI.callIZ(__functionAddress, id);
    }

    public static void glPauseTransformFeedback() {
        long __functionAddress = GLES30.getInstance().PauseTransformFeedback;
        JNI.callV(__functionAddress);
    }

    public static void glResumeTransformFeedback() {
        long __functionAddress = GLES30.getInstance().ResumeTransformFeedback;
        JNI.callV(__functionAddress);
    }

    public static void nglGetProgramBinary(int program, int bufSize, long length, long binaryFormat, long binary) {
        long __functionAddress = GLES30.getInstance().GetProgramBinary;
        JNI.callIIPPPV(__functionAddress, program, bufSize, length, binaryFormat, binary);
    }

    public static void glGetProgramBinary(int program, int bufSize, ByteBuffer length, ByteBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binary, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 4);
        }
        GLES30.nglGetProgramBinary(program, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static void glGetProgramBinary(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        GLES30.nglGetProgramBinary(program, binary.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static ByteBuffer glGetProgramBinary(int program, int bufSize, IntBuffer binaryFormat) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        ByteBuffer binary = BufferUtils.createByteBuffer(bufSize);
        GLES30.nglGetProgramBinary(program, bufSize, __buffer.address(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
        binary.limit(__buffer.intValue(length));
        return binary.slice();
    }

    public static ByteBuffer glGetProgramBinary(int program, IntBuffer binaryFormat) {
        int bufSize = GLES20.glGetProgrami(program, 34625);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        ByteBuffer binary = BufferUtils.createByteBuffer(bufSize);
        GLES30.nglGetProgramBinary(program, bufSize, __buffer.address(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
        binary.limit(__buffer.intValue(length));
        return binary.slice();
    }

    public static void nglProgramBinary(int program, int binaryFormat, long binary, int length) {
        long __functionAddress = GLES30.getInstance().ProgramBinary;
        JNI.callIIPIV(__functionAddress, program, binaryFormat, binary, length);
    }

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary, int length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binary, length);
        }
        GLES30.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), length);
    }

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary) {
        GLES30.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void glProgramParameteri(int program, int pname, int value) {
        long __functionAddress = GLES30.getInstance().ProgramParameteri;
        JNI.callIIIV(__functionAddress, program, pname, value);
    }

    public static void nglInvalidateFramebuffer(int target, int numAttachments, long attachments) {
        long __functionAddress = GLES30.getInstance().InvalidateFramebuffer;
        JNI.callIIPV(__functionAddress, target, numAttachments, attachments);
    }

    public static void glInvalidateFramebuffer(int target, int numAttachments, ByteBuffer attachments) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        GLES30.nglInvalidateFramebuffer(target, numAttachments, MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateFramebuffer(int target, IntBuffer attachments) {
        GLES30.nglInvalidateFramebuffer(target, attachments.remaining(), MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateFramebuffer(int target, int attachment) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        GLES30.nglInvalidateFramebuffer(target, 1, __buffer.address(attachments));
    }

    public static void nglInvalidateSubFramebuffer(int target, int numAttachments, long attachments, int x, int y, int width, int height) {
        long __functionAddress = GLES30.getInstance().InvalidateSubFramebuffer;
        JNI.callIIPIIIIV(__functionAddress, target, numAttachments, attachments, x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, int numAttachments, ByteBuffer attachments, int x, int y, int width, int height) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        GLES30.nglInvalidateSubFramebuffer(target, numAttachments, MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, IntBuffer attachments, int x, int y, int width, int height) {
        GLES30.nglInvalidateSubFramebuffer(target, attachments.remaining(), MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, int attachment, int x, int y, int width, int height) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        GLES30.nglInvalidateSubFramebuffer(target, 1, __buffer.address(attachments), x, y, width, height);
    }

    public static void glTexStorage2D(int target, int levels, int internalformat, int width, int height) {
        long __functionAddress = GLES30.getInstance().TexStorage2D;
        JNI.callIIIIIV(__functionAddress, target, levels, internalformat, width, height);
    }

    public static void glTexStorage3D(int target, int levels, int internalformat, int width, int height, int depth) {
        long __functionAddress = GLES30.getInstance().TexStorage3D;
        JNI.callIIIIIIV(__functionAddress, target, levels, internalformat, width, height, depth);
    }

    public static void nglGetInternalformativ(int target, int internalformat, int pname, int bufSize, long params) {
        long __functionAddress = GLES30.getInstance().GetInternalformativ;
        JNI.callIIIIPV(__functionAddress, target, internalformat, pname, bufSize, params);
    }

    public static void glGetInternalformativ(int target, int internalformat, int pname, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        GLES30.nglGetInternalformativ(target, internalformat, pname, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetInternalformativ(int target, int internalformat, int pname, IntBuffer params) {
        GLES30.nglGetInternalformativ(target, internalformat, pname, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static int glGetInternalformati(int target, int internalformat, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES30.nglGetInternalformativ(target, internalformat, pname, 1, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

