/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class OESDrawElementsBaseVertex {
    public final long DrawElementsBaseVertexOES;
    public final long DrawRangeElementsBaseVertexOES;
    public final long DrawElementsInstancedBaseVertexOES;
    public final long MultiDrawElementsBaseVertexOES;

    protected OESDrawElementsBaseVertex() {
        throw new UnsupportedOperationException();
    }

    public OESDrawElementsBaseVertex(FunctionProvider provider) {
        this.DrawElementsBaseVertexOES = provider.getFunctionAddress("glDrawElementsBaseVertexOES");
        this.DrawRangeElementsBaseVertexOES = provider.getFunctionAddress("glDrawRangeElementsBaseVertexOES");
        this.DrawElementsInstancedBaseVertexOES = provider.getFunctionAddress("glDrawElementsInstancedBaseVertexOES");
        this.MultiDrawElementsBaseVertexOES = provider.getFunctionAddress("glMultiDrawElementsBaseVertexOES");
    }

    public static OESDrawElementsBaseVertex getInstance() {
        return OESDrawElementsBaseVertex.getInstance(GLES.getCapabilities());
    }

    public static OESDrawElementsBaseVertex getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__OESDrawElementsBaseVertex);
    }

    static OESDrawElementsBaseVertex create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_OES_draw_elements_base_vertex")) {
            return null;
        }
        OESDrawElementsBaseVertex funcs = new OESDrawElementsBaseVertex(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawElementsBaseVertexOES, ext.contains("GLES30") ? funcs.DrawRangeElementsBaseVertexOES : -1L, ext.contains("GLES30") ? funcs.DrawElementsInstancedBaseVertexOES : -1L, ext.contains("EXT_multi_draw_arrays") ? funcs.MultiDrawElementsBaseVertexOES : -1L);
        return GLES.checkExtension("GL_OES_draw_elements_base_vertex", funcs, supported);
    }

    public static void nglDrawElementsBaseVertexOES(int mode, int count, int type, long indices, int basevertex) {
        long __functionAddress = OESDrawElementsBaseVertex.getInstance().DrawElementsBaseVertexOES;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, int count, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, count, type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, int count, int type, long indicesOffset, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, count, type, indicesOffset, basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexOES(int mode, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsBaseVertexOES(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawRangeElementsBaseVertexOES(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        long __functionAddress = OESDrawElementsBaseVertex.getInstance().DrawRangeElementsBaseVertexOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIIPIV(__functionAddress, mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, int count, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, count, type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, int count, int type, long indicesOffset, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, count, type, indicesOffset, basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexOES(int mode, int start, int end, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexOES(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawElementsInstancedBaseVertexOES(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        long __functionAddress = OESDrawElementsBaseVertex.getInstance().DrawElementsInstancedBaseVertexOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIPIIV(__functionAddress, mode, count, type, indices, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, int count, int type, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, count, type, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, int count, int type, long indicesOffset, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, count, type, indicesOffset, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, int type, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, ShortBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexOES(int mode, IntBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        OESDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexOES(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void nglMultiDrawElementsBaseVertexOES(int mode, long count, int type, long indices, int primcount, long basevertex) {
        long __functionAddress = OESDrawElementsBaseVertex.getInstance().MultiDrawElementsBaseVertexOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPIPIPV(__functionAddress, mode, count, type, indices, primcount, basevertex);
    }

    public static void glMultiDrawElementsBaseVertexOES(int mode, ByteBuffer count, int type, ByteBuffer indices, int primcount, ByteBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, primcount << 2);
            Checks.checkBuffer((Buffer)indices, primcount << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)basevertex, primcount << 2);
        }
        OESDrawElementsBaseVertex.nglMultiDrawElementsBaseVertexOES(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), primcount, MemoryUtil.memAddress(basevertex));
    }

    public static void glMultiDrawElementsBaseVertexOES(int mode, IntBuffer count, int type, PointerBuffer indices, IntBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(indices, count.remaining());
            Checks.checkBuffer((Buffer)basevertex, count.remaining());
        }
        OESDrawElementsBaseVertex.nglMultiDrawElementsBaseVertexOES(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining(), MemoryUtil.memAddress(basevertex));
    }
}

