/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class OESMapbuffer {
    public static final int GL_WRITE_ONLY_OES = 35001;
    public static final int GL_BUFFER_ACCESS_OES = 35003;
    public static final int GL_BUFFER_MAPPED_OES = 35004;
    public static final int GL_BUFFER_MAP_POINTER_OES = 35005;
    public final long MapBufferOES;
    public final long UnmapBufferOES;
    public final long GetBufferPointervOES;

    protected OESMapbuffer() {
        throw new UnsupportedOperationException();
    }

    public OESMapbuffer(FunctionProvider provider) {
        this.MapBufferOES = provider.getFunctionAddress("glMapBufferOES");
        this.UnmapBufferOES = provider.getFunctionAddress("glUnmapBufferOES");
        this.GetBufferPointervOES = provider.getFunctionAddress("glGetBufferPointervOES");
    }

    public static OESMapbuffer getInstance() {
        return OESMapbuffer.getInstance(GLES.getCapabilities());
    }

    public static OESMapbuffer getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__OESMapbuffer);
    }

    static OESMapbuffer create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_OES_mapbuffer")) {
            return null;
        }
        OESMapbuffer funcs = new OESMapbuffer(provider);
        boolean supported = Checks.checkFunctions(funcs.MapBufferOES, funcs.UnmapBufferOES, funcs.GetBufferPointervOES);
        return GLES.checkExtension("GL_OES_mapbuffer", funcs, supported);
    }

    public static long nglMapBufferOES(int target, int access) {
        long __functionAddress = OESMapbuffer.getInstance().MapBufferOES;
        return JNI.callIIP(__functionAddress, target, access);
    }

    public static ByteBuffer glMapBufferOES(int target, int access) {
        long __result = OESMapbuffer.nglMapBufferOES(target, access);
        return MemoryUtil.memByteBuffer(__result, GLES20.glGetBufferParameteri(target, 34660));
    }

    public static ByteBuffer glMapBufferOES(int target, int access, ByteBuffer old_buffer) {
        long __result = OESMapbuffer.nglMapBufferOES(target, access);
        int length = GLES20.glGetBufferParameteri(target, 34660);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, length) : MemoryUtil.memSetupBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapBufferOES(int target, int access, long length, ByteBuffer old_buffer) {
        long __result = OESMapbuffer.nglMapBufferOES(target, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static boolean glUnmapBufferOES(int target) {
        long __functionAddress = OESMapbuffer.getInstance().UnmapBufferOES;
        return JNI.callIZ(__functionAddress, target);
    }

    public static void nglGetBufferPointervOES(int target, int pname, long params) {
        long __functionAddress = OESMapbuffer.getInstance().GetBufferPointervOES;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferPointervOES(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1 << Pointer.POINTER_SHIFT);
        }
        OESMapbuffer.nglGetBufferPointervOES(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferPointervOES(int target, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        OESMapbuffer.nglGetBufferPointervOES(target, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetBufferPointerOES(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.pointerParam();
        OESMapbuffer.nglGetBufferPointervOES(target, pname, __buffer.address(params));
        return __buffer.pointerValue(params);
    }
}

