/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class QCOMExtendedGet2 {
    public final long ExtGetShadersQCOM;
    public final long ExtGetProgramsQCOM;
    public final long ExtIsProgramBinaryQCOM;
    public final long ExtGetProgramBinarySourceQCOM;

    protected QCOMExtendedGet2() {
        throw new UnsupportedOperationException();
    }

    public QCOMExtendedGet2(FunctionProvider provider) {
        this.ExtGetShadersQCOM = provider.getFunctionAddress("glExtGetShadersQCOM");
        this.ExtGetProgramsQCOM = provider.getFunctionAddress("glExtGetProgramsQCOM");
        this.ExtIsProgramBinaryQCOM = provider.getFunctionAddress("glExtIsProgramBinaryQCOM");
        this.ExtGetProgramBinarySourceQCOM = provider.getFunctionAddress("glExtGetProgramBinarySourceQCOM");
    }

    public static QCOMExtendedGet2 getInstance() {
        return QCOMExtendedGet2.getInstance(GLES.getCapabilities());
    }

    public static QCOMExtendedGet2 getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__QCOMExtendedGet2);
    }

    static QCOMExtendedGet2 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_QCOM_extended_get2")) {
            return null;
        }
        QCOMExtendedGet2 funcs = new QCOMExtendedGet2(provider);
        boolean supported = Checks.checkFunctions(funcs.ExtGetShadersQCOM, funcs.ExtGetProgramsQCOM, funcs.ExtIsProgramBinaryQCOM, funcs.ExtGetProgramBinarySourceQCOM);
        return GLES.checkExtension("GL_QCOM_extended_get2", funcs, supported);
    }

    public static void nglExtGetShadersQCOM(long shaders, int maxShaders, long numShaders) {
        long __functionAddress = QCOMExtendedGet2.getInstance().ExtGetShadersQCOM;
        JNI.callPIPV(__functionAddress, shaders, maxShaders, numShaders);
    }

    public static void glExtGetShadersQCOM(ByteBuffer shaders, int maxShaders, ByteBuffer numShaders) {
        if (Checks.CHECKS) {
            if (shaders != null) {
                Checks.checkBuffer((Buffer)shaders, maxShaders << 2);
            }
            if (numShaders != null) {
                Checks.checkBuffer((Buffer)numShaders, 4);
            }
        }
        QCOMExtendedGet2.nglExtGetShadersQCOM(MemoryUtil.memAddressSafe(shaders), maxShaders, MemoryUtil.memAddressSafe(numShaders));
    }

    public static void glExtGetShadersQCOM(IntBuffer shaders, IntBuffer numShaders) {
        if (Checks.CHECKS && numShaders != null) {
            Checks.checkBuffer((Buffer)numShaders, 1);
        }
        QCOMExtendedGet2.nglExtGetShadersQCOM(MemoryUtil.memAddressSafe(shaders), shaders == null ? 0 : shaders.remaining(), MemoryUtil.memAddressSafe(numShaders));
    }

    public static void nglExtGetProgramsQCOM(long programs, int maxPrograms, long numPrograms) {
        long __functionAddress = QCOMExtendedGet2.getInstance().ExtGetProgramsQCOM;
        JNI.callPIPV(__functionAddress, programs, maxPrograms, numPrograms);
    }

    public static void glExtGetProgramsQCOM(ByteBuffer programs, int maxPrograms, ByteBuffer numPrograms) {
        if (Checks.CHECKS) {
            if (programs != null) {
                Checks.checkBuffer((Buffer)programs, maxPrograms << 2);
            }
            if (numPrograms != null) {
                Checks.checkBuffer((Buffer)numPrograms, 4);
            }
        }
        QCOMExtendedGet2.nglExtGetProgramsQCOM(MemoryUtil.memAddressSafe(programs), maxPrograms, MemoryUtil.memAddressSafe(numPrograms));
    }

    public static void glExtGetProgramsQCOM(IntBuffer programs, IntBuffer numPrograms) {
        if (Checks.CHECKS && numPrograms != null) {
            Checks.checkBuffer((Buffer)numPrograms, 1);
        }
        QCOMExtendedGet2.nglExtGetProgramsQCOM(MemoryUtil.memAddressSafe(programs), programs == null ? 0 : programs.remaining(), MemoryUtil.memAddressSafe(numPrograms));
    }

    public static boolean glExtIsProgramBinaryQCOM(int program) {
        long __functionAddress = QCOMExtendedGet2.getInstance().ExtIsProgramBinaryQCOM;
        return JNI.callIZ(__functionAddress, program);
    }

    public static void nglExtGetProgramBinarySourceQCOM(int program, int shadertype, long source, long length) {
        long __functionAddress = QCOMExtendedGet2.getInstance().ExtGetProgramBinarySourceQCOM;
        JNI.callIIPPV(__functionAddress, program, shadertype, source, length);
    }

    public static void glExtGetProgramBinarySourceQCOM(int program, int shadertype, ByteBuffer source, ByteBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 4);
        }
        QCOMExtendedGet2.nglExtGetProgramBinarySourceQCOM(program, shadertype, MemoryUtil.memAddressSafe(source), MemoryUtil.memAddressSafe(length));
    }

    public static void glExtGetProgramBinarySourceQCOM(int program, int shadertype, ByteBuffer source, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        QCOMExtendedGet2.nglExtGetProgramBinarySourceQCOM(program, shadertype, MemoryUtil.memAddressSafe(source), MemoryUtil.memAddressSafe(length));
    }
}

