/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRInputState
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int TIMEINSECONDS;
    public static final int CONNECTEDCONTROLLERTYPES;
    public static final int BUTTONS;
    public static final int TOUCHES;
    public static final int INDEXTRIGGER;
    public static final int HANDTRIGGER;
    public static final int THUMBSTICK;

    OVRInputState(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRInputState(long struct) {
        this(struct, null);
    }

    public OVRInputState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double TimeInSeconds() {
        return OVRInputState.nTimeInSeconds(this.address());
    }

    public int ConnectedControllerTypes() {
        return OVRInputState.nConnectedControllerTypes(this.address());
    }

    public int Buttons() {
        return OVRInputState.nButtons(this.address());
    }

    public int Touches() {
        return OVRInputState.nTouches(this.address());
    }

    public FloatBuffer IndexTrigger() {
        return OVRInputState.nIndexTrigger(this.address());
    }

    public float IndexTrigger(int index) {
        return OVRInputState.nIndexTrigger(this.address(), index);
    }

    public FloatBuffer HandTrigger() {
        return OVRInputState.nHandTrigger(this.address());
    }

    public float HandTrigger(int index) {
        return OVRInputState.nHandTrigger(this.address(), index);
    }

    public OVRVector2f.Buffer Thumbstick() {
        return OVRInputState.nThumbstick(this.address());
    }

    public OVRVector2f Thumbstick(int index) {
        return OVRInputState.nThumbstick(this.address(), index);
    }

    public OVRInputState TimeInSeconds(double value) {
        OVRInputState.nTimeInSeconds(this.address(), value);
        return this;
    }

    public OVRInputState ConnectedControllerTypes(int value) {
        OVRInputState.nConnectedControllerTypes(this.address(), value);
        return this;
    }

    public OVRInputState Buttons(int value) {
        OVRInputState.nButtons(this.address(), value);
        return this;
    }

    public OVRInputState Touches(int value) {
        OVRInputState.nTouches(this.address(), value);
        return this;
    }

    public OVRInputState IndexTrigger(FloatBuffer value) {
        OVRInputState.nIndexTrigger(this.address(), value);
        return this;
    }

    public OVRInputState IndexTrigger(int index, float value) {
        OVRInputState.nIndexTrigger(this.address(), index, value);
        return this;
    }

    public OVRInputState HandTrigger(FloatBuffer value) {
        OVRInputState.nHandTrigger(this.address(), value);
        return this;
    }

    public OVRInputState HandTrigger(int index, float value) {
        OVRInputState.nHandTrigger(this.address(), index, value);
        return this;
    }

    public OVRInputState Thumbstick(OVRVector2f.Buffer value) {
        OVRInputState.nThumbstick(this.address(), value);
        return this;
    }

    public OVRInputState Thumbstick(int index, OVRVector2f value) {
        OVRInputState.nThumbstick(this.address(), index, value);
        return this;
    }

    public OVRInputState set(double TimeInSeconds, int ConnectedControllerTypes, int Buttons, int Touches, FloatBuffer IndexTrigger, FloatBuffer HandTrigger, OVRVector2f.Buffer Thumbstick) {
        this.TimeInSeconds(TimeInSeconds);
        this.ConnectedControllerTypes(ConnectedControllerTypes);
        this.Buttons(Buttons);
        this.Touches(Touches);
        this.IndexTrigger(IndexTrigger);
        this.HandTrigger(HandTrigger);
        this.Thumbstick(Thumbstick);
        return this;
    }

    public OVRInputState nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRInputState set(OVRInputState src) {
        return this.nset(src.address());
    }

    public OVRInputState set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRInputState malloc() {
        return new OVRInputState(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRInputState calloc() {
        return new OVRInputState(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRInputState create() {
        return new OVRInputState(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static double nTimeInSeconds(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)TIMEINSECONDS);
    }

    public static int nConnectedControllerTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONNECTEDCONTROLLERTYPES);
    }

    public static int nButtons(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUTTONS);
    }

    public static int nTouches(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOUCHES);
    }

    public static FloatBuffer nIndexTrigger(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)INDEXTRIGGER, 2);
    }

    public static float nIndexTrigger(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)INDEXTRIGGER + (long)(index * 4));
    }

    public static FloatBuffer nHandTrigger(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)HANDTRIGGER, 2);
    }

    public static float nHandTrigger(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)HANDTRIGGER + (long)(index * 4));
    }

    public static OVRVector2f.Buffer nThumbstick(long struct) {
        return OVRVector2f.createBuffer(struct + (long)THUMBSTICK, 2);
    }

    public static OVRVector2f nThumbstick(long struct, int index) {
        return new OVRVector2f(struct + (long)THUMBSTICK + (long)(index * OVRVector2f.SIZEOF));
    }

    public static void nTimeInSeconds(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)TIMEINSECONDS, value);
    }

    public static void nConnectedControllerTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONNECTEDCONTROLLERTYPES, value);
    }

    public static void nButtons(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BUTTONS, value);
    }

    public static void nTouches(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TOUCHES, value);
    }

    public static void nIndexTrigger(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)INDEXTRIGGER, value.remaining() * 4);
    }

    public static void nIndexTrigger(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)INDEXTRIGGER + (long)(index * 4), value);
    }

    public static void nHandTrigger(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)HANDTRIGGER, value.remaining() * 4);
    }

    public static void nHandTrigger(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)HANDTRIGGER + (long)(index * 4), value);
    }

    public static void nThumbstick(long struct, OVRVector2f.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)THUMBSTICK, value.remaining() * OVRVector2f.SIZEOF);
    }

    public static void nThumbstick(long struct, int index, OVRVector2f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)THUMBSTICK + (long)(index * OVRVector2f.SIZEOF), OVRVector2f.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRInputState.__struct(OVRInputState.__member(8), OVRInputState.__member(4), OVRInputState.__member(4), OVRInputState.__member(4), OVRInputState.__array(4, 2), OVRInputState.__array(4, 2), OVRInputState.__array(OVRVector2f.SIZEOF, OVRVector2f.__ALIGNMENT, 2));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        TIMEINSECONDS = layout.offsetof(0);
        CONNECTEDCONTROLLERTYPES = layout.offsetof(1);
        BUTTONS = layout.offsetof(2);
        TOUCHES = layout.offsetof(3);
        INDEXTRIGGER = layout.offsetof(4);
        HANDTRIGGER = layout.offsetof(5);
        THUMBSTICK = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<OVRInputState, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRInputState newInstance(long address) {
            return new OVRInputState(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public double TimeInSeconds() {
            return OVRInputState.nTimeInSeconds(this.address());
        }

        public int ConnectedControllerTypes() {
            return OVRInputState.nConnectedControllerTypes(this.address());
        }

        public int Buttons() {
            return OVRInputState.nButtons(this.address());
        }

        public int Touches() {
            return OVRInputState.nTouches(this.address());
        }

        public FloatBuffer IndexTrigger() {
            return OVRInputState.nIndexTrigger(this.address());
        }

        public float IndexTrigger(int index) {
            return OVRInputState.nIndexTrigger(this.address(), index);
        }

        public FloatBuffer HandTrigger() {
            return OVRInputState.nHandTrigger(this.address());
        }

        public float HandTrigger(int index) {
            return OVRInputState.nHandTrigger(this.address(), index);
        }

        public OVRVector2f.Buffer Thumbstick() {
            return OVRInputState.nThumbstick(this.address());
        }

        public OVRVector2f Thumbstick(int index) {
            return OVRInputState.nThumbstick(this.address(), index);
        }

        public Buffer TimeInSeconds(double value) {
            OVRInputState.nTimeInSeconds(this.address(), value);
            return this;
        }

        public Buffer ConnectedControllerTypes(int value) {
            OVRInputState.nConnectedControllerTypes(this.address(), value);
            return this;
        }

        public Buffer Buttons(int value) {
            OVRInputState.nButtons(this.address(), value);
            return this;
        }

        public Buffer Touches(int value) {
            OVRInputState.nTouches(this.address(), value);
            return this;
        }

        public Buffer IndexTrigger(FloatBuffer value) {
            OVRInputState.nIndexTrigger(this.address(), value);
            return this;
        }

        public Buffer IndexTrigger(int index, float value) {
            OVRInputState.nIndexTrigger(this.address(), index, value);
            return this;
        }

        public Buffer HandTrigger(FloatBuffer value) {
            OVRInputState.nHandTrigger(this.address(), value);
            return this;
        }

        public Buffer HandTrigger(int index, float value) {
            OVRInputState.nHandTrigger(this.address(), index, value);
            return this;
        }

        public Buffer Thumbstick(OVRVector2f.Buffer value) {
            OVRInputState.nThumbstick(this.address(), value);
            return this;
        }

        public Buffer Thumbstick(int index, OVRVector2f value) {
            OVRInputState.nThumbstick(this.address(), index, value);
            return this;
        }
    }
}

