/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRQuatf
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    OVRQuatf(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRQuatf(long struct) {
        this(struct, null);
    }

    public OVRQuatf(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return OVRQuatf.nx(this.address());
    }

    public float y() {
        return OVRQuatf.ny(this.address());
    }

    public float z() {
        return OVRQuatf.nz(this.address());
    }

    public float w() {
        return OVRQuatf.nw(this.address());
    }

    public OVRQuatf x(float value) {
        OVRQuatf.nx(this.address(), value);
        return this;
    }

    public OVRQuatf y(float value) {
        OVRQuatf.ny(this.address(), value);
        return this;
    }

    public OVRQuatf z(float value) {
        OVRQuatf.nz(this.address(), value);
        return this;
    }

    public OVRQuatf w(float value) {
        OVRQuatf.nw(this.address(), value);
        return this;
    }

    public OVRQuatf set(float x, float y, float z, float w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public OVRQuatf nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRQuatf set(OVRQuatf src) {
        return this.nset(src.address());
    }

    public OVRQuatf set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRQuatf malloc() {
        return new OVRQuatf(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRQuatf calloc() {
        return new OVRQuatf(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRQuatf create() {
        return new OVRQuatf(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)W);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    public static void nw(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)W, value);
    }

    static {
        Struct.Layout layout = OVRQuatf.__struct(OVRQuatf.__member(4), OVRQuatf.__member(4), OVRQuatf.__member(4), OVRQuatf.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<OVRQuatf, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRQuatf newInstance(long address) {
            return new OVRQuatf(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return OVRQuatf.nx(this.address());
        }

        public float y() {
            return OVRQuatf.ny(this.address());
        }

        public float z() {
            return OVRQuatf.nz(this.address());
        }

        public float w() {
            return OVRQuatf.nw(this.address());
        }

        public Buffer x(float value) {
            OVRQuatf.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            OVRQuatf.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            OVRQuatf.nz(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            OVRQuatf.nw(this.address(), value);
            return this;
        }
    }
}

