/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRVector2f
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int X;
    public static final int Y;

    OVRVector2f(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRVector2f(long struct) {
        this(struct, null);
    }

    public OVRVector2f(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return OVRVector2f.nx(this.address());
    }

    public float y() {
        return OVRVector2f.ny(this.address());
    }

    public OVRVector2f x(float value) {
        OVRVector2f.nx(this.address(), value);
        return this;
    }

    public OVRVector2f y(float value) {
        OVRVector2f.ny(this.address(), value);
        return this;
    }

    public OVRVector2f set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public OVRVector2f nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRVector2f set(OVRVector2f src) {
        return this.nset(src.address());
    }

    public OVRVector2f set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRVector2f malloc() {
        return new OVRVector2f(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRVector2f calloc() {
        return new OVRVector2f(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRVector2f create() {
        return new OVRVector2f(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = OVRVector2f.__struct(OVRVector2f.__member(4), OVRVector2f.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRVector2f, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRVector2f newInstance(long address) {
            return new OVRVector2f(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return OVRVector2f.nx(this.address());
        }

        public float y() {
            return OVRVector2f.ny(this.address());
        }

        public Buffer x(float value) {
            OVRVector2f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            OVRVector2f.ny(this.address(), value);
            return this;
        }
    }
}

