/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRVector2i
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int X;
    public static final int Y;

    OVRVector2i(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRVector2i(long struct) {
        this(struct, null);
    }

    public OVRVector2i(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return OVRVector2i.nx(this.address());
    }

    public int y() {
        return OVRVector2i.ny(this.address());
    }

    public OVRVector2i x(int value) {
        OVRVector2i.nx(this.address(), value);
        return this;
    }

    public OVRVector2i y(int value) {
        OVRVector2i.ny(this.address(), value);
        return this;
    }

    public OVRVector2i set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public OVRVector2i nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRVector2i set(OVRVector2i src) {
        return this.nset(src.address());
    }

    public OVRVector2i set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRVector2i malloc() {
        return new OVRVector2i(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRVector2i calloc() {
        return new OVRVector2i(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRVector2i create() {
        return new OVRVector2i(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = OVRVector2i.__struct(OVRVector2i.__member(4), OVRVector2i.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRVector2i, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRVector2i newInstance(long address) {
            return new OVRVector2i(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int x() {
            return OVRVector2i.nx(this.address());
        }

        public int y() {
            return OVRVector2i.ny(this.address());
        }

        public Buffer x(int value) {
            OVRVector2i.nx(this.address(), value);
            return this;
        }

        public Buffer y(int value) {
            OVRVector2i.ny(this.address(), value);
            return this;
        }
    }
}

