/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.stb.STBIIOCallbacks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class STBImage {
    public static final int STBI_grey = 1;
    public static final int STBI_grey_alpha = 2;
    public static final int STBI_rgb = 3;
    public static final int STBI_rgb_alpha = 4;
    public static final int STBI_default = 0;

    protected STBImage() {
        throw new UnsupportedOperationException();
    }

    public static native long nstbi_load(long var0, long var2, long var4, long var6, int var8);

    public static ByteBuffer stbi_load(ByteBuffer filename, ByteBuffer x, ByteBuffer y, ByteBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)x, 4);
            Checks.checkBuffer((Buffer)y, 4);
            Checks.checkBuffer((Buffer)comp, 4);
        }
        long __result = STBImage.nstbi_load(MemoryUtil.memAddress(filename), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memByteBuffer(__result, x.getInt(x.position()) * y.getInt(y.position()) * comp.getInt(comp.position()));
    }

    public static ByteBuffer stbi_load(ByteBuffer filename, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        long __result = STBImage.nstbi_load(MemoryUtil.memAddress(filename), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memByteBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static ByteBuffer stbi_load(CharSequence filename, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int filenameEncoded = __buffer.stringParamASCII(filename, true);
        long __result = STBImage.nstbi_load(__buffer.address(filenameEncoded), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memByteBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static native long nstbi_load_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    public static ByteBuffer stbi_load_from_memory(ByteBuffer buffer, int len, ByteBuffer x, ByteBuffer y, ByteBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffer, len);
            Checks.checkBuffer((Buffer)x, 4);
            Checks.checkBuffer((Buffer)y, 4);
            Checks.checkBuffer((Buffer)comp, 4);
        }
        long __result = STBImage.nstbi_load_from_memory(MemoryUtil.memAddress(buffer), len, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memByteBuffer(__result, x.getInt(x.position()) * y.getInt(y.position()) * comp.getInt(comp.position()));
    }

    public static ByteBuffer stbi_load_from_memory(ByteBuffer buffer, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        long __result = STBImage.nstbi_load_from_memory(MemoryUtil.memAddress(buffer), buffer.remaining(), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memByteBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static native long nstbi_load_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    public static ByteBuffer stbi_load_from_callbacks(STBIIOCallbacks clbk, ByteBuffer user, ByteBuffer x, ByteBuffer y, ByteBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 4);
            Checks.checkBuffer((Buffer)y, 4);
            Checks.checkBuffer((Buffer)comp, 4);
        }
        long __result = STBImage.nstbi_load_from_callbacks(clbk.address(), MemoryUtil.memAddressSafe(user), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memByteBuffer(__result, x.getInt(x.position()) * y.getInt(y.position()) * comp.getInt(comp.position()));
    }

    public static ByteBuffer stbi_load_from_callbacks(STBIIOCallbacks clbk, ByteBuffer user, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        long __result = STBImage.nstbi_load_from_callbacks(clbk.address(), MemoryUtil.memAddressSafe(user), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memByteBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static native long nstbi_loadf(long var0, long var2, long var4, long var6, int var8);

    public static FloatBuffer stbi_loadf(ByteBuffer filename, ByteBuffer x, ByteBuffer y, ByteBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)x, 4);
            Checks.checkBuffer((Buffer)y, 4);
            Checks.checkBuffer((Buffer)comp, 4);
        }
        long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress(filename), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memFloatBuffer(__result, x.getInt(x.position()) * y.getInt(y.position()) * comp.getInt(comp.position()));
    }

    public static FloatBuffer stbi_loadf(ByteBuffer filename, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress(filename), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memFloatBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static FloatBuffer stbi_loadf(CharSequence filename, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int filenameEncoded = __buffer.stringParamASCII(filename, true);
        long __result = STBImage.nstbi_loadf(__buffer.address(filenameEncoded), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memFloatBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static native long nstbi_loadf_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    public static FloatBuffer stbi_loadf_from_memory(ByteBuffer buffer, int len, ByteBuffer x, ByteBuffer y, ByteBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffer, len);
            Checks.checkBuffer((Buffer)x, 4);
            Checks.checkBuffer((Buffer)y, 4);
            Checks.checkBuffer((Buffer)comp, 4);
        }
        long __result = STBImage.nstbi_loadf_from_memory(MemoryUtil.memAddress(buffer), len, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memFloatBuffer(__result, x.getInt(x.position()) * y.getInt(y.position()) * comp.getInt(comp.position()));
    }

    public static FloatBuffer stbi_loadf_from_memory(ByteBuffer buffer, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        long __result = STBImage.nstbi_loadf_from_memory(MemoryUtil.memAddress(buffer), buffer.remaining(), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memFloatBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static native long nstbi_loadf_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    public static FloatBuffer stbi_loadf_from_callbacks(STBIIOCallbacks clbk, ByteBuffer user, ByteBuffer x, ByteBuffer y, ByteBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 4);
            Checks.checkBuffer((Buffer)y, 4);
            Checks.checkBuffer((Buffer)comp, 4);
        }
        long __result = STBImage.nstbi_loadf_from_callbacks(clbk.address(), MemoryUtil.memAddressSafe(user), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memFloatBuffer(__result, x.getInt(x.position()) * y.getInt(y.position()) * comp.getInt(comp.position()));
    }

    public static FloatBuffer stbi_loadf_from_callbacks(STBIIOCallbacks clbk, ByteBuffer user, IntBuffer x, IntBuffer y, IntBuffer comp, int req_comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        long __result = STBImage.nstbi_loadf_from_callbacks(clbk.address(), MemoryUtil.memAddressSafe(user), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp), req_comp);
        return MemoryUtil.memFloatBuffer(__result, x.get(x.position()) * y.get(y.position()) * comp.get(comp.position()));
    }

    public static native void stbi_hdr_to_ldr_gamma(float var0);

    public static native void stbi_hdr_to_ldr_scale(float var0);

    public static native void stbi_ldr_to_hdr_gamma(float var0);

    public static native void stbi_ldr_to_hdr_scale(float var0);

    public static native int nstbi_is_hdr(long var0);

    public static int stbi_is_hdr(ByteBuffer filename) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
        }
        return STBImage.nstbi_is_hdr(MemoryUtil.memAddress(filename));
    }

    public static int stbi_is_hdr(CharSequence filename) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int filenameEncoded = __buffer.stringParamASCII(filename, true);
        return STBImage.nstbi_is_hdr(__buffer.address(filenameEncoded));
    }

    public static native int nstbi_is_hdr_from_memory(long var0, int var2);

    public static int stbi_is_hdr_from_memory(ByteBuffer buffer, int len) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffer, len);
        }
        return STBImage.nstbi_is_hdr_from_memory(MemoryUtil.memAddress(buffer), len);
    }

    public static int stbi_is_hdr_from_memory(ByteBuffer buffer) {
        return STBImage.nstbi_is_hdr_from_memory(MemoryUtil.memAddress(buffer), buffer.remaining());
    }

    public static native int nstbi_is_hdr_from_callbacks(long var0, long var2);

    public static int stbi_is_hdr_from_callbacks(STBIIOCallbacks clbk, ByteBuffer user) {
        return STBImage.nstbi_is_hdr_from_callbacks(clbk.address(), MemoryUtil.memAddressSafe(user));
    }

    public static native long nstbi_failure_reason();

    public static String stbi_failure_reason() {
        long __result = STBImage.nstbi_failure_reason();
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static native void nstbi_image_free(long var0);

    public static void stbi_image_free(ByteBuffer retval_from_stbi_load) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress(retval_from_stbi_load));
    }

    public static native int nstbi_info(long var0, long var2, long var4, long var6);

    public static int stbi_info(ByteBuffer filename, ByteBuffer x, ByteBuffer y, ByteBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)x, 4);
            Checks.checkBuffer((Buffer)y, 4);
            Checks.checkBuffer((Buffer)comp, 4);
        }
        return STBImage.nstbi_info(MemoryUtil.memAddress(filename), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
    }

    public static int stbi_info(ByteBuffer filename, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        return STBImage.nstbi_info(MemoryUtil.memAddress(filename), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
    }

    public static int stbi_info(CharSequence filename, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int filenameEncoded = __buffer.stringParamASCII(filename, true);
        return STBImage.nstbi_info(__buffer.address(filenameEncoded), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
    }

    public static native int nstbi_info_from_memory(long var0, int var2, long var3, long var5, long var7);

    public static int stbi_info_from_memory(ByteBuffer buffer, int len, ByteBuffer x, ByteBuffer y, ByteBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffer, len);
            Checks.checkBuffer((Buffer)x, 4);
            Checks.checkBuffer((Buffer)y, 4);
            Checks.checkBuffer((Buffer)comp, 4);
        }
        return STBImage.nstbi_info_from_memory(MemoryUtil.memAddress(buffer), len, MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
    }

    public static int stbi_info_from_memory(ByteBuffer buffer, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        return STBImage.nstbi_info_from_memory(MemoryUtil.memAddress(buffer), buffer.remaining(), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
    }

    public static native int nstbi_info_from_callbacks(long var0, long var2, long var4, long var6, long var8);

    public static int stbi_info_from_callbacks(STBIIOCallbacks clbk, ByteBuffer user, ByteBuffer x, ByteBuffer y, ByteBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 4);
            Checks.checkBuffer((Buffer)y, 4);
            Checks.checkBuffer((Buffer)comp, 4);
        }
        return STBImage.nstbi_info_from_callbacks(clbk.address(), MemoryUtil.memAddressSafe(user), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
    }

    public static int stbi_info_from_callbacks(STBIIOCallbacks clbk, ByteBuffer user, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)x, 1);
            Checks.checkBuffer((Buffer)y, 1);
            Checks.checkBuffer((Buffer)comp, 1);
        }
        return STBImage.nstbi_info_from_callbacks(clbk.address(), MemoryUtil.memAddressSafe(user), MemoryUtil.memAddress(x), MemoryUtil.memAddress(y), MemoryUtil.memAddress(comp));
    }

    public static native void stbi_set_unpremultiply_on_load(int var0);

    public static native void stbi_convert_iphone_png_to_rgb(int var0);

    public static native void stbi_set_flip_vertically_on_load(int var0);

    public static native long nstbi_zlib_decode_malloc_guesssize(long var0, int var2, int var3, long var4);

    public static ByteBuffer stbi_zlib_decode_malloc_guesssize(ByteBuffer buffer, int len, int initial_size) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffer, len);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outlen = __buffer.intParam();
        long __result = STBImage.nstbi_zlib_decode_malloc_guesssize(MemoryUtil.memAddress(buffer), len, initial_size, __buffer.address(outlen));
        return MemoryUtil.memByteBuffer(__result, __buffer.intValue(outlen));
    }

    public static ByteBuffer stbi_zlib_decode_malloc_guesssize(ByteBuffer buffer, int initial_size) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outlen = __buffer.intParam();
        long __result = STBImage.nstbi_zlib_decode_malloc_guesssize(MemoryUtil.memAddress(buffer), buffer.remaining(), initial_size, __buffer.address(outlen));
        return MemoryUtil.memByteBuffer(__result, __buffer.intValue(outlen));
    }

    public static native long nstbi_zlib_decode_malloc_guesssize_headerflag(long var0, int var2, int var3, long var4, int var6);

    public static ByteBuffer stbi_zlib_decode_malloc_guesssize_headerflag(ByteBuffer buffer, int len, int initial_size, int parse_header) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffer, len);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outlen = __buffer.intParam();
        long __result = STBImage.nstbi_zlib_decode_malloc_guesssize_headerflag(MemoryUtil.memAddress(buffer), len, initial_size, __buffer.address(outlen), parse_header);
        return MemoryUtil.memByteBuffer(__result, __buffer.intValue(outlen));
    }

    public static ByteBuffer stbi_zlib_decode_malloc_guesssize_headerflag(ByteBuffer buffer, int initial_size, int parse_header) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outlen = __buffer.intParam();
        long __result = STBImage.nstbi_zlib_decode_malloc_guesssize_headerflag(MemoryUtil.memAddress(buffer), buffer.remaining(), initial_size, __buffer.address(outlen), parse_header);
        return MemoryUtil.memByteBuffer(__result, __buffer.intValue(outlen));
    }

    public static native long nstbi_zlib_decode_malloc(long var0, int var2, long var3);

    public static ByteBuffer stbi_zlib_decode_malloc(ByteBuffer buffer, int len) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffer, len);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outlen = __buffer.intParam();
        long __result = STBImage.nstbi_zlib_decode_malloc(MemoryUtil.memAddress(buffer), len, __buffer.address(outlen));
        return MemoryUtil.memByteBuffer(__result, __buffer.intValue(outlen));
    }

    public static ByteBuffer stbi_zlib_decode_malloc(ByteBuffer buffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outlen = __buffer.intParam();
        long __result = STBImage.nstbi_zlib_decode_malloc(MemoryUtil.memAddress(buffer), buffer.remaining(), __buffer.address(outlen));
        return MemoryUtil.memByteBuffer(__result, __buffer.intValue(outlen));
    }

    public static native int nstbi_zlib_decode_buffer(long var0, int var2, long var3, int var5);

    public static int stbi_zlib_decode_buffer(ByteBuffer obuffer, int olen, ByteBuffer ibuffer, int ilen) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)obuffer, olen);
            Checks.checkBuffer((Buffer)ibuffer, ilen);
        }
        return STBImage.nstbi_zlib_decode_buffer(MemoryUtil.memAddress(obuffer), olen, MemoryUtil.memAddress(ibuffer), ilen);
    }

    public static int stbi_zlib_decode_buffer(ByteBuffer obuffer, ByteBuffer ibuffer) {
        return STBImage.nstbi_zlib_decode_buffer(MemoryUtil.memAddress(obuffer), obuffer.remaining(), MemoryUtil.memAddress(ibuffer), ibuffer.remaining());
    }

    public static native long nstbi_zlib_decode_noheader_malloc(long var0, int var2, long var3);

    public static ByteBuffer stbi_zlib_decode_noheader_malloc(ByteBuffer buffer, int len) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffer, len);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outlen = __buffer.intParam();
        long __result = STBImage.nstbi_zlib_decode_noheader_malloc(MemoryUtil.memAddress(buffer), len, __buffer.address(outlen));
        return MemoryUtil.memByteBuffer(__result, __buffer.intValue(outlen));
    }

    public static ByteBuffer stbi_zlib_decode_noheader_malloc(ByteBuffer buffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outlen = __buffer.intParam();
        long __result = STBImage.nstbi_zlib_decode_noheader_malloc(MemoryUtil.memAddress(buffer), buffer.remaining(), __buffer.address(outlen));
        return MemoryUtil.memByteBuffer(__result, __buffer.intValue(outlen));
    }

    public static native int nstbi_zlib_decode_noheader_buffer(long var0, int var2, long var3, int var5);

    public static int stbi_zlib_decode_noheader_buffer(ByteBuffer obuffer, int olen, ByteBuffer ibuffer, int ilen) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)obuffer, olen);
            Checks.checkBuffer((Buffer)ibuffer, ilen);
        }
        return STBImage.nstbi_zlib_decode_noheader_buffer(MemoryUtil.memAddress(obuffer), olen, MemoryUtil.memAddress(ibuffer), ilen);
    }

    public static int stbi_zlib_decode_noheader_buffer(ByteBuffer obuffer, ByteBuffer ibuffer) {
        return STBImage.nstbi_zlib_decode_noheader_buffer(MemoryUtil.memAddress(obuffer), obuffer.remaining(), MemoryUtil.memAddress(ibuffer), ibuffer.remaining());
    }

    static {
        Library.initialize();
    }
}

