/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBTTBakedChar
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int X0;
    public static final int Y0;
    public static final int X1;
    public static final int Y1;
    public static final int XOFF;
    public static final int YOFF;
    public static final int XADVANCE;

    STBTTBakedChar(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public STBTTBakedChar(long struct) {
        this(struct, null);
    }

    public STBTTBakedChar(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short x0() {
        return STBTTBakedChar.nx0(this.address());
    }

    public short y0() {
        return STBTTBakedChar.ny0(this.address());
    }

    public short x1() {
        return STBTTBakedChar.nx1(this.address());
    }

    public short y1() {
        return STBTTBakedChar.ny1(this.address());
    }

    public float xoff() {
        return STBTTBakedChar.nxoff(this.address());
    }

    public float yoff() {
        return STBTTBakedChar.nyoff(this.address());
    }

    public float xadvance() {
        return STBTTBakedChar.nxadvance(this.address());
    }

    public static STBTTBakedChar malloc() {
        return new STBTTBakedChar(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBTTBakedChar calloc() {
        return new STBTTBakedChar(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBTTBakedChar create() {
        return new STBTTBakedChar(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static short nx0(long struct) {
        return MemoryUtil.memGetShort(struct + (long)X0);
    }

    public static short ny0(long struct) {
        return MemoryUtil.memGetShort(struct + (long)Y0);
    }

    public static short nx1(long struct) {
        return MemoryUtil.memGetShort(struct + (long)X1);
    }

    public static short ny1(long struct) {
        return MemoryUtil.memGetShort(struct + (long)Y1);
    }

    public static float nxoff(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XOFF);
    }

    public static float nyoff(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)YOFF);
    }

    public static float nxadvance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XADVANCE);
    }

    static {
        Struct.Layout layout = STBTTBakedChar.__struct(STBTTBakedChar.__member(2), STBTTBakedChar.__member(2), STBTTBakedChar.__member(2), STBTTBakedChar.__member(2), STBTTBakedChar.__member(4), STBTTBakedChar.__member(4), STBTTBakedChar.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        X0 = layout.offsetof(0);
        Y0 = layout.offsetof(1);
        X1 = layout.offsetof(2);
        Y1 = layout.offsetof(3);
        XOFF = layout.offsetof(4);
        YOFF = layout.offsetof(5);
        XADVANCE = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<STBTTBakedChar, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected STBTTBakedChar newInstance(long address) {
            return new STBTTBakedChar(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public short x0() {
            return STBTTBakedChar.nx0(this.address());
        }

        public short y0() {
            return STBTTBakedChar.ny0(this.address());
        }

        public short x1() {
            return STBTTBakedChar.nx1(this.address());
        }

        public short y1() {
            return STBTTBakedChar.ny1(this.address());
        }

        public float xoff() {
            return STBTTBakedChar.nxoff(this.address());
        }

        public float yoff() {
            return STBTTBakedChar.nyoff(this.address());
        }

        public float xadvance() {
            return STBTTBakedChar.nxadvance(this.address());
        }
    }
}

