/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.PointerWrapper;
import org.lwjgl.system.Struct;

public abstract class StructBuffer<T extends Struct, SELF extends StructBuffer<T, SELF>>
implements Comparable<SELF>,
Pointer {
    protected final ByteBuffer container;

    protected StructBuffer(ByteBuffer container, int SIZEOF) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)container, SIZEOF);
        }
        this.container = container;
    }

    protected abstract SELF self();

    protected abstract SELF newBufferInstance(ByteBuffer var1);

    protected abstract T newInstance(long var1);

    protected abstract int sizeof();

    public long address0() {
        return MemoryUtil.memAddress0(this.container);
    }

    @Override
    public long address() {
        return MemoryUtil.memAddress(this.container);
    }

    public int capacity() {
        return this.container.capacity() / this.sizeof();
    }

    public int position() {
        return this.container.position() / this.sizeof();
    }

    public SELF position(int newPosition) {
        this.container.position(newPosition * this.sizeof());
        return this.self();
    }

    public int limit() {
        return this.container.limit() / this.sizeof();
    }

    public SELF limit(int newLimit) {
        this.container.limit(newLimit * this.sizeof());
        return this.self();
    }

    public SELF mark() {
        this.container.mark();
        return this.self();
    }

    public SELF reset() {
        this.container.reset();
        return this.self();
    }

    public SELF clear() {
        this.container.clear();
        return this.self();
    }

    public SELF flip() {
        this.container.flip();
        return this.self();
    }

    public SELF rewind() {
        this.container.rewind();
        return this.self();
    }

    public int remaining() {
        return this.container.remaining() / this.sizeof();
    }

    public boolean hasRemaining() {
        return this.container.hasRemaining();
    }

    public SELF slice() {
        return this.newBufferInstance(this.container.slice());
    }

    public SELF duplicate() {
        return this.newBufferInstance(this.container.duplicate());
    }

    public SELF asReadOnlyBuffer() {
        return this.newBufferInstance(this.container.asReadOnlyBuffer());
    }

    public boolean isReadOnly() {
        return this.container.isReadOnly();
    }

    public T get() {
        int curr = this.container.position();
        int next = curr + this.sizeof();
        if (this.container.limit() < next) {
            throw new BufferUnderflowException();
        }
        T value = this.newInstance(this.address0() + (long)curr);
        this.container.position(next);
        return value;
    }

    public SELF get(T value) {
        int sizeof = this.sizeof();
        MemoryUtil.memCopy(this.address0() + (long)StructBuffer.nextGetIndex(this.container, sizeof), ((PointerWrapper)value).address(), sizeof);
        return this.self();
    }

    public SELF put(T value) {
        int sizeof = this.sizeof();
        MemoryUtil.memCopy(((PointerWrapper)value).address(), this.address0() + (long)StructBuffer.nextPutIndex(this.container, sizeof), sizeof);
        return this.self();
    }

    public T get(int index) {
        return this.newInstance(this.address0() + (long)StructBuffer.checkIndex(this.container, index * this.sizeof()));
    }

    public SELF get(int index, T value) {
        int sizeof = this.sizeof();
        MemoryUtil.memCopy(this.address0() + (long)StructBuffer.checkIndex(this.container, index * sizeof), ((PointerWrapper)value).address(), sizeof);
        return this.self();
    }

    public SELF put(int index, T value) {
        int sizeof = this.sizeof();
        MemoryUtil.memCopy(((PointerWrapper)value).address(), this.address0() + (long)StructBuffer.checkIndex(this.container, index * sizeof), sizeof);
        return this.self();
    }

    public SELF get(byte[] dst) {
        return this.get(dst, 0, dst.length / this.sizeof());
    }

    public SELF get(byte[] dst, int offset, int length) {
        this.container.get(dst, offset, length * this.sizeof());
        return this.self();
    }

    public SELF put(SELF src) {
        this.container.put(((StructBuffer)src).container);
        return this.self();
    }

    public SELF put(byte[] src) {
        return this.put(src, 0, src.length / this.sizeof());
    }

    public SELF put(byte[] src, int offset, int length) {
        this.container.put(src, offset, length * this.sizeof());
        return this.self();
    }

    public SELF compact() {
        this.container.compact();
        return this.self();
    }

    public ByteOrder order() {
        return this.container.order();
    }

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        return this.container.hashCode();
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof StructBuffer)) {
            return false;
        }
        StructBuffer that = (StructBuffer)ob;
        return this.container.equals(that.container);
    }

    @Override
    public int compareTo(SELF that) {
        return this.container.compareTo(((StructBuffer)that).container);
    }

    private static int nextGetIndex(ByteBuffer container, int sizeof) {
        int curr = container.position();
        int next = curr + sizeof;
        if (container.limit() < next) {
            throw new BufferUnderflowException();
        }
        container.position(next);
        return curr;
    }

    private static int nextPutIndex(ByteBuffer container, int sizeof) {
        int curr = container.position();
        int next = curr + sizeof;
        if (container.limit() < next) {
            throw new BufferOverflowException();
        }
        container.position(next);
        return curr;
    }

    private static int checkIndex(ByteBuffer container, int index) {
        if (index < 0 || container.limit() < index) {
            throw new IndexOutOfBoundsException();
        }
        return index;
    }
}

