/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class ObjCMethodDescription
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int NAME;
    public static final int TYPES;

    ObjCMethodDescription(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public ObjCMethodDescription(long struct) {
        this(struct, null);
    }

    public ObjCMethodDescription(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long name() {
        return ObjCMethodDescription.nname(this.address());
    }

    public ByteBuffer types() {
        return ObjCMethodDescription.ntypes(this.address());
    }

    public String typesString() {
        return ObjCMethodDescription.ntypesString(this.address());
    }

    public static ObjCMethodDescription malloc() {
        return new ObjCMethodDescription(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static ObjCMethodDescription calloc() {
        return new ObjCMethodDescription(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static ObjCMethodDescription create() {
        return new ObjCMethodDescription(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static long nname(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NAME);
    }

    public static ByteBuffer ntypes(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)TYPES));
    }

    public static String ntypesString(long struct) {
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memGetAddress(struct + (long)TYPES));
    }

    static {
        Struct.Layout layout = ObjCMethodDescription.__struct(ObjCMethodDescription.__member(Pointer.POINTER_SIZE), ObjCMethodDescription.__member(Pointer.POINTER_SIZE));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        NAME = layout.offsetof(0);
        TYPES = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<ObjCMethodDescription, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected ObjCMethodDescription newInstance(long address) {
            return new ObjCMethodDescription(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long name() {
            return ObjCMethodDescription.nname(this.address());
        }

        public ByteBuffer types() {
            return ObjCMethodDescription.ntypes(this.address());
        }

        public String typesString() {
            return ObjCMethodDescription.ntypesString(this.address());
        }
    }
}

