/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class RECT
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int LEFT;
    public static final int TOP;
    public static final int RIGHT;
    public static final int BOTTOM;

    RECT(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public RECT(long struct) {
        this(struct, null);
    }

    public RECT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int left() {
        return RECT.nleft(this.address());
    }

    public int top() {
        return RECT.ntop(this.address());
    }

    public int right() {
        return RECT.nright(this.address());
    }

    public int bottom() {
        return RECT.nbottom(this.address());
    }

    public RECT left(int value) {
        RECT.nleft(this.address(), value);
        return this;
    }

    public RECT top(int value) {
        RECT.ntop(this.address(), value);
        return this;
    }

    public RECT right(int value) {
        RECT.nright(this.address(), value);
        return this;
    }

    public RECT bottom(int value) {
        RECT.nbottom(this.address(), value);
        return this;
    }

    public RECT set(int left, int top, int right, int bottom) {
        this.left(left);
        this.top(top);
        this.right(right);
        this.bottom(bottom);
        return this;
    }

    public RECT nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public RECT set(RECT src) {
        return this.nset(src.address());
    }

    public RECT set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static RECT malloc() {
        return new RECT(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static RECT calloc() {
        return new RECT(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static RECT create() {
        return new RECT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nleft(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LEFT);
    }

    public static int ntop(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOP);
    }

    public static int nright(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RIGHT);
    }

    public static int nbottom(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BOTTOM);
    }

    public static void nleft(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LEFT, value);
    }

    public static void ntop(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TOP, value);
    }

    public static void nright(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RIGHT, value);
    }

    public static void nbottom(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BOTTOM, value);
    }

    static {
        Struct.Layout layout = RECT.__struct(RECT.__member(4), RECT.__member(4), RECT.__member(4), RECT.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        LEFT = layout.offsetof(0);
        TOP = layout.offsetof(1);
        RIGHT = layout.offsetof(2);
        BOTTOM = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<RECT, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected RECT newInstance(long address) {
            return new RECT(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int left() {
            return RECT.nleft(this.address());
        }

        public int top() {
            return RECT.ntop(this.address());
        }

        public int right() {
            return RECT.nright(this.address());
        }

        public int bottom() {
            return RECT.nbottom(this.address());
        }

        public Buffer left(int value) {
            RECT.nleft(this.address(), value);
            return this;
        }

        public Buffer top(int value) {
            RECT.ntop(this.address(), value);
            return this;
        }

        public Buffer right(int value) {
            RECT.nright(this.address(), value);
            return this;
        }

        public Buffer bottom(int value) {
            RECT.nbottom(this.address(), value);
            return this;
        }
    }
}

