/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Library;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.windows.WinBase;
import org.lwjgl.system.windows.WindowsUtil;

public class WindowsLibrary
extends SharedLibrary.Default {
    public static final long HINSTANCE = WinBase.GetModuleHandle(Library.JNI_LIBRARY_NAME);
    private final long handle;

    public WindowsLibrary(String name) {
        super(name);
        this.handle = WinBase.LoadLibrary(name);
        if (this.handle == 0L) {
            WindowsUtil.windowsThrowException("Failed to load library: " + name);
        }
        APIUtil.apiLog("Loaded native library: " + name);
    }

    @Override
    public long address() {
        return this.handle;
    }

    @Override
    public long getFunctionAddress(CharSequence name) {
        return WinBase.GetProcAddress(this.handle, name);
    }

    @Override
    protected void destroy() {
        if (WinBase.FreeLibrary(this.handle) == 0) {
            WindowsUtil.windowsThrowException("Failed to unload library: " + this.getName());
        }
    }

    static {
        if (HINSTANCE == 0L) {
            throw new RuntimeException("Failed to retrieve LWJGL module handle.");
        }
    }
}

