/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class DefaultEmptyCellRenderer
extends GridCellRenderer {
    @Override
    public void paint(GC gc, Object value) {
        Grid table = null;
        if (value instanceof Grid) {
            table = (Grid)((Object)value);
        }
        if (value instanceof GridItem) {
            GridItem item = (GridItem)((Object)value);
            table = item.getParent();
        }
        boolean drawBackground = true;
        if (this.isSelected()) {
            boolean hasFocus = table.isFocusOnGrid();
            Color backgroundColor = hasFocus ? this.getDisplay().getSystemColor(26) : this.getDisplay().getSystemColor(19);
            Color foregroundColor = hasFocus ? this.getDisplay().getSystemColor(27) : this.getDisplay().getSystemColor(2);
            gc.setBackground(backgroundColor);
            gc.setForeground(foregroundColor);
        } else {
            if (table.isEnabled()) {
                drawBackground = false;
            } else {
                gc.setBackground(this.getDisplay().getSystemColor(22));
            }
            gc.setForeground(table.getForeground());
        }
        if (drawBackground) {
            gc.fillRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width + 1, this.getBounds().height);
        }
        if (table.getLinesVisible()) {
            gc.setForeground(table.getLineColor());
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height, this.getBounds().x + this.getBounds().width, this.getBounds().y + this.getBounds().height);
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
        }
    }

    @Override
    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        return new Point(wHint, hHint);
    }

    @Override
    public boolean notify(int event, Point point, Object value) {
        return false;
    }
}

