/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.compose;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.model.AwayGoal;
import org.fortiss.af3.safetycases.model.ContextualElement;
import org.fortiss.af3.safetycases.model.ExitConnector;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.model.InContextOf;
import org.fortiss.af3.safetycases.model.SafetyCasesConnection;
import org.fortiss.af3.safetycases.model.SafetyCasesConnector;
import org.fortiss.af3.safetycases.model.SupportedBy;
import org.fortiss.af3.safetycases.utils.SafetyCasesAnalysisUtils;
import org.fortiss.af3.safetycases.utils.SafetyCasesModelElementFactory;
import org.fortiss.tooling.base.compose.ConnectorConnectionCompositorBase;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.base.ExitConnectorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;

public class ConnectionCompositor
extends ConnectorConnectionCompositorBase<ArgumentElementBase, SafetyCasesConnector, SafetyCasesConnector> {
    protected boolean allowManyToOne() {
        return false;
    }

    protected boolean allowOneToMany() {
        return false;
    }

    public boolean canDisconnect(EObject connection) {
        return connection instanceof InContextOf || connection instanceof SupportedBy;
    }

    protected IConnection createConnection(IConnector source, IConnector target, ArgumentElementBase parent, ITopLevelElement topElement) {
        SafetyCasesConnection connection = SafetyCasesModelElementFactory.createSupportedBy();
        if (source instanceof SafetyCasesConnector && target instanceof SafetyCasesConnector && ((SafetyCasesConnector)target).getGSNElement() instanceof ContextualElement) {
            connection = SafetyCasesModelElementFactory.createInContextOf();
        }
        if (topElement != null) {
            topElement.prepareIDs((EObject)connection);
        }
        parent.getConnections().add((Object)connection);
        boolean swap = false;
        if (source instanceof EntryConnectorBase) {
            if (target instanceof EntryConnectorBase) {
                if (source.eContainer() != target.eContainer().eContainer()) {
                    swap = true;
                }
            } else if (target instanceof ExitConnectorBase) {
                swap = true;
            }
        } else if (source instanceof ExitConnectorBase && target instanceof ExitConnectorBase && source.eContainer() == target.eContainer().eContainer()) {
            swap = true;
        }
        if (swap) {
            connection.setSource(target);
            connection.setTarget(source);
        } else {
            connection.setSource(source);
            connection.setTarget(target);
        }
        return connection;
    }

    public boolean canConnect(SafetyCasesConnector source, SafetyCasesConnector target, ArgumentElementBase parent, IConnectionCompositionContext context) {
        if (source instanceof ExitConnector) {
            ArgumentElementBase dst;
            if (source.getOutgoing().size() != 0) {
                return false;
            }
            ArgumentElementBase src = (ArgumentElementBase)source.getGSNElement();
            if (SafetyCasesAnalysisUtils.createsACircleDependency(src, dst = (ArgumentElementBase)target.getGSNElement()) || SafetyCasesAnalysisUtils.alreadyExistingConnection(src, dst)) {
                return false;
            }
            if ((dst instanceof Goal || dst instanceof AwayGoal) && (src instanceof Goal || src instanceof AwayGoal)) {
                return false;
            }
        }
        return true;
    }

    protected IConnection createConnection() {
        return SafetyCasesModelElementFactory.createSupportedBy();
    }
}

