/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.compose;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.EntryConnector;
import org.fortiss.af3.safetycases.model.ExitConnector;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.model.SafetyCase;
import org.fortiss.af3.safetycases.model.SafetyModule;
import org.fortiss.af3.safetycases.model.SpinalElement;
import org.fortiss.af3.safetycases.model.Strategy;
import org.fortiss.af3.safetycases.utils.SafetyCasesAnalysisUtils;
import org.fortiss.af3.safetycases.utils.SafetyCasesModelElementFactory;
import org.fortiss.tooling.base.compose.HierarchicElementConnectionCompositorBase;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public class GoalSupportedByCompositor
extends HierarchicElementConnectionCompositorBase<HierarchicElementBase, Goal, SpinalElement> {
    public boolean canConnect(Goal source, SpinalElement target, HierarchicElementBase parent, IConnectionCompositionContext context) {
        if (!(parent instanceof SafetyCase) && !(parent instanceof SafetyModule) && source.eContainer() != target.eContainer()) {
            return false;
        }
        if (source.equals(target)) {
            return false;
        }
        if (SafetyCasesAnalysisUtils.createsACircleDependency(source, target)) {
            String message = "The " + source.getName() + " goal and the " + target.getName() + " argument element cannot be connected as there would be a dependency circle created.";
            Shell activeShell = Display.getCurrent().getActiveShell();
            MessageDialog.openInformation((Shell)activeShell, (String)"Information", (String)message);
            return false;
        }
        return super.canConnect((IHierarchicElement)source, (IHierarchicElement)target, (IHierarchicElement)parent, context);
    }

    protected IConnection createConnection() {
        return SafetyCasesModelElementFactory.createSupportedBy();
    }

    public boolean connect(final Goal source, final SpinalElement target, final HierarchicElementBase parent, IConnectionCompositionContext context) {
        if (target instanceof Goal) {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)parent);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    Shell activeShell = Display.getCurrent().getActiveShell();
                    MessageDialog.openInformation((Shell)activeShell, (String)"Information", (String)"The refinement relationshp between two goals shall be always explained via a strategy element.");
                    GoalSupportedByCompositor.this.enforceStrategyExplanation(source, target, parent);
                }
            });
        } else {
            IConnector sourceConnector = this.createExitConnector();
            this.avoidDuplicateConnectorName((IHierarchicElement)source, sourceConnector);
            IConnector targetConnector = this.createEntryConnector();
            this.avoidDuplicateConnectorName((IHierarchicElement)target, targetConnector);
            this.createNewSourceDropContext((IHierarchicElement)source, context, (EObject)sourceConnector);
            this.createNewTargetDropContext((IHierarchicElement)target, context, (EObject)targetConnector);
            ITopLevelElement topElement = IPersistencyService.getInstance().getTopLevelElementFor((EObject)parent);
            this.createConnection(sourceConnector, targetConnector, (IHierarchicElement)parent, topElement);
        }
        return true;
    }

    private void enforceStrategyExplanation(Goal source, SpinalElement target, HierarchicElementBase parent) {
        Strategy strategy = SafetyCasesModelElementFactory.createStrategy();
        parent.getContainedElements().add((Object)strategy);
        ExitConnector connector1 = SafetyCasesModelElementFactory.createSafetyExitConnector();
        connector1.setOwner((IHierarchicElement)source);
        EntryConnector connector2 = SafetyCasesModelElementFactory.createSafetyEntryConnector();
        connector2.setOwner((IHierarchicElement)strategy);
        ITopLevelElement topElement = IPersistencyService.getInstance().getTopLevelElementFor((EObject)parent);
        this.createConnection((IConnector)connector1, (IConnector)connector2, (IHierarchicElement)parent, topElement);
        ExitConnector connector3 = SafetyCasesModelElementFactory.createSafetyExitConnector();
        connector3.setOwner((IHierarchicElement)strategy);
        EntryConnector connector4 = SafetyCasesModelElementFactory.createSafetyEntryConnector();
        connector4.setOwner((IHierarchicElement)target);
        this.createConnection((IConnector)connector3, (IConnector)connector4, (IHierarchicElement)parent, topElement);
    }

    protected IConnector createEntryConnector() {
        return SafetyCasesModelElementFactory.createSafetyEntryConnector();
    }

    protected IConnector createExitConnector() {
        return SafetyCasesModelElementFactory.createSafetyExitConnector();
    }
}

