/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.compose;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.SafetyCase;
import org.fortiss.af3.safetycases.model.SafetyModule;
import org.fortiss.af3.safetycases.utils.SafetyCasesAnalysisUtils;
import org.fortiss.af3.safetycases.utils.SafetyCasesModelElementFactory;
import org.fortiss.tooling.base.compose.HierarchicElementConnectionCompositorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;

public class ModuleSupportedByCompositor
extends HierarchicElementConnectionCompositorBase<SafetyCase, SafetyModule, SafetyModule> {
    public boolean canConnect(SafetyModule source, SafetyModule target, SafetyCase parent, IConnectionCompositionContext context) {
        if (source.eContainer() != target.eContainer()) {
            return false;
        }
        if (source.equals(target)) {
            return false;
        }
        if (SafetyCasesAnalysisUtils.createsACircleDependency(source, target)) {
            String message = "The " + source.getName() + " module and the " + target.getName() + " module cannot be connected as there would be a dependency circle created.";
            Shell activeShell = Display.getCurrent().getActiveShell();
            MessageDialog.openInformation((Shell)activeShell, (String)"Information", (String)message);
            return false;
        }
        return super.canConnect((IHierarchicElement)source, (IHierarchicElement)target, (IHierarchicElement)parent, context);
    }

    protected IConnection createConnection() {
        return SafetyCasesModelElementFactory.createSupportedBy();
    }

    protected IConnector createEntryConnector() {
        return SafetyCasesModelElementFactory.createSafetyEntryConnector();
    }

    protected IConnector createExitConnector() {
        return SafetyCasesModelElementFactory.createSafetyExitConnector();
    }
}

