/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.compose;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.DecomposableSpinalElement;
import org.fortiss.af3.safetycases.model.Strategy;
import org.fortiss.af3.safetycases.utils.SafetyCasesAnalysisUtils;
import org.fortiss.af3.safetycases.utils.SafetyCasesModelElementFactory;
import org.fortiss.tooling.base.compose.HierarchicElementConnectionCompositorBase;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;

public class StrategySupportedByCompositor
extends HierarchicElementConnectionCompositorBase<HierarchicElementBase, Strategy, DecomposableSpinalElement> {
    public boolean canConnect(Strategy source, DecomposableSpinalElement target, HierarchicElementBase parent, IConnectionCompositionContext context) {
        if (target instanceof Strategy) {
            return false;
        }
        if (source.eContainer() != target.eContainer()) {
            return false;
        }
        if (SafetyCasesAnalysisUtils.createsACircleDependency(source, target)) {
            String message = "The " + source.getName() + " strategy and the " + target.getName() + " argument element cannot be connected as there would be a dependency circle created.";
            Shell activeShell = Display.getCurrent().getActiveShell();
            MessageDialog.openInformation((Shell)activeShell, (String)"Information", (String)message);
            return false;
        }
        return super.canConnect((IHierarchicElement)source, (IHierarchicElement)target, (IHierarchicElement)parent, context);
    }

    protected IConnection createConnection() {
        return SafetyCasesModelElementFactory.createSupportedBy();
    }

    protected IConnector createEntryConnector() {
        return SafetyCasesModelElementFactory.createSafetyEntryConnector();
    }

    protected IConnector createExitConnector() {
        return SafetyCasesModelElementFactory.createSafetyExitConnector();
    }
}

