/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.listener;

import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.platform.model.IPlatformArchitectureElement;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.safetyargumentationpackage.model.SafetyArgumentationPackage;
import org.fortiss.af3.safetycases.AF3SafetyCasesActivator;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.DecomposableSpinalElement;
import org.fortiss.af3.safetycases.model.ExitConnector;
import org.fortiss.af3.safetycases.utils.SafetyCasesUtils;
import org.fortiss.af3.state.model.State;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class AutomaticSetListener
extends EContentAdapter {
    private static volatile AutomaticSetListener INSTANCE;

    private AutomaticSetListener() {
    }

    public static synchronized AutomaticSetListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AutomaticSetListener();
        }
        return INSTANCE;
    }

    public static void installAutomaticSetListeners(ITopLevelElement element) {
        EObject rootElement = element.getRootModelElement();
        if (!(rootElement instanceof FileProject)) {
            LoggingUtils.warning((Plugin)AF3SafetyCasesActivator.getDefault(), (String)"Got a root element that is not a file project while trying to install listeners. This could indicate a model corruption.");
            return;
        }
        FileProject fileProject = (FileProject)rootElement;
        EList safetyPackages = EcoreUtils.pickInstanceOf(SafetyArgumentationPackage.class, (List)fileProject.getRootElements());
        LambdaUtils.filter((Collection)safetyPackages, argEl -> !argEl.eAdapters().contains((Object)AutomaticSetListener.getInstance())).forEach(argEl -> {
            boolean bl = argEl.eAdapters().add((Object)AutomaticSetListener.getInstance());
        });
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getNotifier() instanceof ArgumentElement && notification.getEventType() == 1) {
            if (!(notification.getFeature() instanceof EAttribute)) {
                return;
            }
            EAttribute attribute = (EAttribute)notification.getFeature();
            if (attribute.getName().equals("textualInformation")) {
                ArgumentElement argElement = (ArgumentElement)notification.getNotifier();
                String textualInformation = argElement.getTextualInformation();
                String toMatch = "(.*?)@(.*?)\\(\\<(\\bno\\b)[ ]{1,}(\\bcomponent|\\bmode|\\bstate|\\brequirement|\\ballocation|\\bplatform)\\>\\)(.*?)";
                if (!(Pattern.matches("^\\{((.|\\n)*)}$", textualInformation) || textualInformation.isEmpty() || Pattern.matches(toMatch, textualInformation))) {
                    argElement.setToBeInstantiated(false);
                } else {
                    argElement.setToBeInstantiated(true);
                }
                this.matchMe(textualInformation, argElement);
            }
            return;
        }
        if (notification.getNotifier() instanceof ExitConnector && (notification.getEventType() == 3 || notification.getEventType() == 4)) {
            List connectors;
            HierarchicElementBase element = ((ExitConnector)notification.getNotifier()).getGSNElement();
            if (notification.getEventType() == 3) {
                if (element instanceof DecomposableSpinalElement) {
                    ((DecomposableSpinalElement)element).setToBeDeveloped(false);
                }
            } else if (notification.getEventType() == 4 && element instanceof DecomposableSpinalElement && (connectors = ((DecomposableSpinalElement)element).getExitConnectors().stream().filter(e -> !e.getOutgoing().isEmpty()).collect(Collectors.toList())).isEmpty()) {
                ((DecomposableSpinalElement)element).setToBeDeveloped(true);
            }
        }
    }

    private void matchMe(String textualInformation, ArgumentElement argElement) {
        block23: {
            if (textualInformation.isEmpty() || textualInformation.charAt(0) == ' ') break block23;
            String text = " " + textualInformation;
            Matcher m = Pattern.compile("\\@(.*?)\\((.*?)\\)").matcher(text);
            while (m.find()) {
                switch (m.group(1)) {
                    case "component": {
                        this.referenceComponents(argElement, m.group(2));
                        break;
                    }
                    case "state": {
                        this.referenceStates(argElement, m.group(2));
                        break;
                    }
                    case "mode": {
                        this.referenceModes(argElement, m.group(2));
                        break;
                    }
                    case "platform": {
                        this.referencePlatforms(argElement, m.group(2));
                        break;
                    }
                    case "allocation": {
                        this.referenceAllocation(argElement, m.group(2));
                        break;
                    }
                    case "requirement": {
                        this.referenceRequirement(argElement, m.group(2));
                    }
                }
            }
        }
    }

    private void referenceRequirement(ArgumentElement argElement, String name) {
        List list;
        boolean containsReference = argElement.getReferencedRequirements().stream().map(i -> i.getName()).anyMatch(e -> e.equals(name));
        if (!containsReference && SafetyCasesUtils.getAllRequirements(argElement) != null && !(list = SafetyCasesUtils.getAllRequirements(argElement).stream().filter(i -> i.getName() != null).filter(i -> i.getName().equals(name)).collect(Collectors.toList())).isEmpty()) {
            argElement.getReferencedRequirements().add((Object)((Requirement)list.get(0)));
        }
    }

    private void referenceAllocation(ArgumentElement argElement, String name) {
        List list;
        boolean containsReference = argElement.getReferencedDeployments().stream().map(i -> i.getName()).anyMatch(e -> e.equals(name));
        if (!containsReference && SafetyCasesUtils.getAllAllocations(argElement) != null && !(list = SafetyCasesUtils.getAllAllocations(argElement).stream().filter(i -> i.getName().equals(name)).collect(Collectors.toList())).isEmpty()) {
            argElement.getReferencedDeployments().add((Object)((AllocationTable)list.get(0)));
        }
    }

    private void referencePlatforms(ArgumentElement argElement, String name) {
        List list;
        boolean containsReference = argElement.getReferencedPTA().stream().map(i -> i.getName()).anyMatch(e -> e.equals(name));
        if (!containsReference && SafetyCasesUtils.getAllPlatformArchitecture(argElement) != null && !(list = SafetyCasesUtils.getAllPlatformArchitecture(argElement).stream().filter(i -> i.getName().equals(name)).collect(Collectors.toList())).isEmpty()) {
            argElement.getReferencedPTA().add((Object)((IPlatformArchitectureElement)list.get(0)));
        }
    }

    private void referenceModes(ArgumentElement argElement, String name) {
        List list;
        boolean containsReference = argElement.getReferencedModes().stream().map(i -> i.getName()).anyMatch(e -> e.equals(name));
        if (!containsReference && SafetyCasesUtils.getAllModes(argElement) != null && !(list = SafetyCasesUtils.getAllModes(argElement).stream().filter(i -> i.getName().equals(name)).collect(Collectors.toList())).isEmpty()) {
            argElement.getReferencedModes().add((Object)((Mode)list.get(0)));
        }
    }

    private void referenceStates(ArgumentElement argElement, String name) {
        List list;
        boolean containsReference = argElement.getReferencedStates().stream().map(i -> i.getName()).anyMatch(e -> e.equals(name));
        if (!containsReference && SafetyCasesUtils.getAllStates(argElement) != null && !(list = SafetyCasesUtils.getAllStates(argElement).stream().filter(i -> i.getName().equals(name)).collect(Collectors.toList())).isEmpty()) {
            argElement.getReferencedStates().add((Object)((State)list.get(0)));
        }
    }

    private void referenceComponents(ArgumentElement argElement, String name) {
        List list;
        boolean containsReference = argElement.getReferencedComponents().stream().map(i -> i.getName()).anyMatch(e -> e.equals(name));
        if (!containsReference && SafetyCasesUtils.getAllLogicalComponents(argElement) != null && !(list = SafetyCasesUtils.getAllLogicalComponents(argElement).stream().filter(i -> i.getName().equals(name)).collect(Collectors.toList())).isEmpty()) {
            argElement.getReferencedComponents().add((Object)((Component)list.get(0)));
        }
    }
}

