/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ASSESSMENT_STATUS implements Enumerator
{
    NOT_REVIEWED(0, "Not_Reviewed", "Not_Reviewed"),
    ACCEPTED(2, "Accepted", "Accepted"),
    INCORRECT(4, "Incorrect", "Incorrect"),
    WEAK(3, "Weak", "Weak"),
    REVIEW_LATER(1, "Review_Later", "Review_Later");

    public static final int NOT_REVIEWED_VALUE = 0;
    public static final int ACCEPTED_VALUE = 2;
    public static final int INCORRECT_VALUE = 4;
    public static final int WEAK_VALUE = 3;
    public static final int REVIEW_LATER_VALUE = 1;
    private static final ASSESSMENT_STATUS[] VALUES_ARRAY;
    public static final List<ASSESSMENT_STATUS> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ASSESSMENT_STATUS[]{NOT_REVIEWED, ACCEPTED, INCORRECT, WEAK, REVIEW_LATER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ASSESSMENT_STATUS get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ASSESSMENT_STATUS result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ASSESSMENT_STATUS getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ASSESSMENT_STATUS result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ASSESSMENT_STATUS get(int value) {
        switch (value) {
            case 0: {
                return NOT_REVIEWED;
            }
            case 2: {
                return ACCEPTED;
            }
            case 4: {
                return INCORRECT;
            }
            case 3: {
                return WEAK;
            }
            case 1: {
                return REVIEW_LATER;
            }
        }
        return null;
    }

    private ASSESSMENT_STATUS(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

