/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentModule;
import org.fortiss.af3.safetycases.model.Assumption;
import org.fortiss.af3.safetycases.model.Context;
import org.fortiss.af3.safetycases.model.EntryConnector;
import org.fortiss.af3.safetycases.model.ExitConnector;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.model.Justification;
import org.fortiss.af3.safetycases.model.SafetyCase;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.af3.safetycases.model.Strategy;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class SafetyCasesModellingUtils {
    public static void setUniqueArgEleName(ArgumentElement newArgEle, SafetyCase safetyCase) {
        if (newArgEle instanceof Goal) {
            SafetyCasesModellingUtils.setUniqueNameHelper(newArgEle, "G");
        } else if (newArgEle instanceof Strategy) {
            SafetyCasesModellingUtils.setUniqueNameHelper(newArgEle, "S");
        } else if (newArgEle instanceof Solution) {
            SafetyCasesModellingUtils.setUniqueNameHelper(newArgEle, "Sn");
        } else if (newArgEle instanceof Justification) {
            SafetyCasesModellingUtils.setUniqueNameHelper(newArgEle, "J");
        } else if (newArgEle instanceof Assumption) {
            SafetyCasesModellingUtils.setUniqueNameHelper(newArgEle, "A");
        } else if (newArgEle instanceof Context) {
            SafetyCasesModellingUtils.setUniqueNameHelper(newArgEle, "C");
        }
    }

    private static void setUniqueNameHelper(ArgumentElement newArgElem, String s) {
        int nrOfArgElem = EcoreUtils.getChildrenWithType((EObject)newArgElem.getContainer(), newArgElem.getClass()).size();
        KernelModelElementUtils.setNameComment((INamedCommentedElement)newArgElem, (String)(s + nrOfArgElem), (String)"");
    }

    public static void deleteExistingIntraModuleConnections(SafetyCase selectedSafetyCase) {
        for (IConnection connection : selectedSafetyCase.getConnections()) {
            if (connection.getSource() == null) continue;
            HierarchicElementBase src = ((ExitConnector)connection.getSource()).getGSNElement();
            boolean srcIsArgModule = src instanceof ArgumentModule;
            HierarchicElementBase target = ((EntryConnector)connection.getTarget()).getGSNElement();
            boolean tIsArgModule = target instanceof ArgumentModule;
            if (!srcIsArgModule || !tIsArgModule) continue;
            ExitConnector exitConnector = (ExitConnector)connection.getSource();
            EntryConnector entryConnector = (EntryConnector)connection.getTarget();
            EcoreUtil.delete((EObject)entryConnector);
            EcoreUtil.delete((EObject)exitConnector);
        }
    }
}

