/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.utils.ComponentUtils;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.RequirementsContainer;
import org.fortiss.af3.mira.model.RequirementsPackage;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.platform.model.IPlatformArchitectureElement;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.safetyargumentationpackage.model.SafetyArgumentationPackage;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.model.ArgumentModule;
import org.fortiss.af3.safetycases.model.ContextualElement;
import org.fortiss.af3.safetycases.model.DecomposableSpinalElement;
import org.fortiss.af3.safetycases.model.SafetyCase;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class SafetyCasesUtils {
    public static ArrayList<ArgumentElement> getAllOfSameType(ArgumentElement argElem) {
        SafetyCase safetyCase = argElem.getContainerSafetyCase();
        ArrayList argModuleList = new ArrayList();
        argModuleList.addAll(EcoreUtils.pickInstanceOf(ArgumentModule.class, (List)safetyCase.getContainedElements()));
        ArrayList<ArgumentElement> argElements = new ArrayList<ArgumentElement>();
        for (ArgumentModule argModule : argModuleList) {
            for (ArgumentElementBase ae : EcoreUtils.pickInstanceOf(argElem.getClass(), (List)argModule.getContainedElements())) {
                argElements.add((ArgumentElement)ae);
            }
        }
        return argElements;
    }

    public static ArrayList<Component> getAllLogicalComponents(HierarchicElementBase element) {
        List compArchList = KernelModelElementUtils.getRootElements((EObject)element, ComponentArchitecture.class);
        ArrayList<Component> compList = new ArrayList<Component>();
        for (ComponentArchitecture compArch : compArchList) {
            Component parent = compArch.getTopComponent();
            compList.add(parent);
            compList.addAll(ComponentUtils.getAllSubComponentsRecursively((Component)parent));
        }
        return compList;
    }

    public static ArrayList<INamedElement> getAllModes(HierarchicElementBase element) {
        ArrayList<INamedElement> list = new ArrayList<INamedElement>();
        ArrayList<Component> componentsList = SafetyCasesUtils.getAllLogicalComponents(element);
        for (Component comp : componentsList) {
            EList modeAutomata = EcoreUtils.pickInstanceOf(ModeAutomaton.class, (List)comp.getSpecifications());
            for (ModeAutomaton ma : modeAutomata) {
                for (Mode m : ma.getRootMode().getSubModes()) {
                    list.add((INamedElement)m);
                }
            }
        }
        return list;
    }

    public static ArrayList<INamedElement> getAllStates(HierarchicElementBase element) {
        ArrayList<INamedElement> list = new ArrayList<INamedElement>();
        EList stateAutomata = new ArrayList();
        ArrayList<Component> componentsList = SafetyCasesUtils.getAllLogicalComponents(element);
        for (Component comp : componentsList) {
            stateAutomata = EcoreUtils.pickInstanceOf(StateAutomaton.class, (List)comp.getSpecifications());
            for (StateAutomaton sa : stateAutomata) {
                for (State s : sa.getRootState().getSubStates()) {
                    list.add((INamedElement)s);
                }
            }
        }
        return list;
    }

    public static ArrayList<INamedElement> getAllRequirements(HierarchicElementBase element) {
        ArrayList<INamedElement> list = new ArrayList<INamedElement>();
        List analysisList = KernelModelElementUtils.getRootElements((EObject)element, Analysis.class);
        for (Analysis an : analysisList) {
            EList req = EcoreUtils.pickInstanceOf(Arrays.asList(RequirementsContainer.class, RequirementsPackage.class, Requirement.class), (List)an.getRequirementsList());
            for (Requirement r : req) {
                list.add((INamedElement)r);
            }
        }
        return list;
    }

    public static ArrayList<INamedElement> getAllPlatformArchitecture(HierarchicElementBase element) {
        ArrayList<INamedElement> list = new ArrayList<INamedElement>();
        List parchList = KernelModelElementUtils.getRootElements((EObject)element, PlatformArchitecture.class);
        for (PlatformArchitecture pa : parchList) {
            if (pa instanceof IPlatformArchitectureElement) {
                list.add((INamedElement)pa);
            }
            for (IHierarchicElement ihe : pa.getContainedElements()) {
                if (!(ihe instanceof INamedElement) || !(ihe instanceof IPlatformArchitectureElement)) continue;
                list.add((INamedElement)ihe);
            }
        }
        return list;
    }

    public static ArrayList<INamedElement> getAllAllocations(HierarchicElementBase element) {
        ArrayList<INamedElement> list = new ArrayList<INamedElement>();
        EList ca2hwList = AllocationUtils.getAllocationTables((EObject)element, ComponentToExecutionUnitAllocationTable.class);
        for (ComponentToExecutionUnitAllocationTable ca2hw : ca2hwList) {
            list.add((INamedElement)ca2hw);
        }
        return list;
    }

    public static ArrayList<INamedElement> getAllElementsFromPackage(HierarchicElementBase element) {
        EList modeAutomata = new ArrayList();
        EList stateAutomata = new ArrayList();
        ArrayList<Component> componentsList = SafetyCasesUtils.getAllLogicalComponents(element);
        ArrayList<INamedElement> list = new ArrayList<INamedElement>();
        list.addAll(componentsList);
        List analysisList = KernelModelElementUtils.getRootElements((EObject)element, Analysis.class);
        for (Analysis an : analysisList) {
            EList req = EcoreUtils.pickInstanceOf(Arrays.asList(RequirementsContainer.class, RequirementsPackage.class, Requirement.class), (List)an.getRequirementsList());
            for (Requirement r : req) {
                list.add((INamedElement)r);
            }
        }
        for (Component comp : componentsList) {
            modeAutomata = EcoreUtils.pickInstanceOf(ModeAutomaton.class, (List)comp.getSpecifications());
            for (ModeAutomaton ma : modeAutomata) {
                for (Mode m : ma.getRootMode().getSubModes()) {
                    list.add((INamedElement)m);
                }
            }
            stateAutomata = EcoreUtils.pickInstanceOf(StateAutomaton.class, (List)comp.getSpecifications());
            for (StateAutomaton sa : stateAutomata) {
                for (State s : sa.getRootState().getSubStates()) {
                    list.add((INamedElement)s);
                }
            }
        }
        List parchList = KernelModelElementUtils.getRootElements((EObject)element, PlatformArchitecture.class);
        for (PlatformArchitecture pa : parchList) {
            list.add((INamedElement)pa);
            for (IHierarchicElement ihe : pa.getContainedElements()) {
                if (!(ihe instanceof INamedElement)) continue;
                list.add((INamedElement)ihe);
            }
        }
        EList ca2hwList = AllocationUtils.getAllocationTables((EObject)element, ComponentToExecutionUnitAllocationTable.class);
        for (ComponentToExecutionUnitAllocationTable ca2hw : ca2hwList) {
            list.add((INamedElement)ca2hw);
        }
        return list;
    }

    public static ArrayList<SafetyCase> getExistingSafetyCases(SafetyArgumentationPackage safetyArgPackage) {
        ArrayList<SafetyCase> safetyCasesList = new ArrayList<SafetyCase>();
        for (EObject obj : safetyArgPackage.eContents()) {
            if (!(obj instanceof SafetyCase)) continue;
            safetyCasesList.add((SafetyCase)obj);
        }
        return safetyCasesList;
    }

    public static DecomposableSpinalElement getReferredSpinalElement(ContextualElement contextualElement) {
        IConnector connector = (IConnector)contextualElement.getConnectors().get(0);
        DecomposableSpinalElement referredSpinalElement = (DecomposableSpinalElement)((IConnection)connector.getIncoming().get(0)).getSource().getOwner();
        return referredSpinalElement;
    }
}

