/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.ui.editor.data;

import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.behavior.common.IDataStateVariableProvider;
import org.fortiss.af3.component.utils.BehaviorModelElementFactory;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.ui.databinding.validate.StringToTypeValidator;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.state.ui.editor.data.DataStateEditorContentProvider;
import org.fortiss.af3.state.ui.editor.data.DataStateEditorUIProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.common.ui.javafx.util.GraphicUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.ToolingKernelUIActivator;
import org.fortiss.tooling.kernel.ui.extension.base.FXEditorBase;
import org.fortiss.tooling.kernel.utils.KernelServiceBasedModelListenerBase;

public abstract class DataStateEditorBase<T extends IDataStateVariableProvider>
extends FXEditorBase<T> {
    private static final String DESCRIPTION = "Define data state variables with the table below:";
    private DynamicTreeTableViewer<EObject> viewer;
    private Button removeButton;
    private Button addButton;
    private KernelServiceBasedModelListenerBase<IDataStateVariableProvider> modelListener;
    private Label descriptionError;

    protected Parent createSceneRoot() {
        IDataStateVariableProvider provider = (IDataStateVariableProvider)this.getEditedObject();
        this.modelListener = new KernelServiceBasedModelListenerBase<IDataStateVariableProvider>(provider){

            public void updateComplete(List<Notification> notifications) {
                DataStateEditorBase.this.viewer.update();
            }
        };
        this.modelListener.register();
        DataStateEditorContentProvider contentProvider = new DataStateEditorContentProvider();
        DataStateEditorUIProvider uiProvider = new DataStateEditorUIProvider(){

            public void validateOnKeyReleased(KeyEvent event, int colIndex, EObject item, String text) {
                StringToTypeValidator validator;
                IStatus status;
                String message = DataStateEditorBase.DESCRIPTION;
                ImageView icon = null;
                if (event.getCode() != KeyCode.ESCAPE && colIndex == 1 && !(status = (validator = new StringToTypeValidator(item)).validate((Object)text)).isOK()) {
                    message = status.getMessage();
                    icon = new ImageView(GraphicUtils.getFXImage((String)ToolingKernelUIActivator.PLUGIN_ID, (String)"/icons/error.png"));
                }
                DataStateEditorBase.this.descriptionError.setText(message);
                DataStateEditorBase.this.descriptionError.setGraphic(icon);
                event.consume();
            }

            public void validateOnCancelEdit(int colIndex, EObject item) {
                DataStateEditorBase.this.descriptionError.setText(DataStateEditorBase.DESCRIPTION);
                DataStateEditorBase.this.descriptionError.setGraphic(null);
            }
        };
        BorderPane mainPane = new BorderPane();
        this.descriptionError = new Label(DESCRIPTION);
        mainPane.setTop((Node)this.descriptionError);
        this.viewer = new DynamicTreeTableViewer((Object)provider, false, 2, (DynamicTreeContentProviderBase)contentProvider, (DynamicTreeTableUIProviderBase)uiProvider);
        this.viewer.addColumn("Variable", 160);
        this.viewer.addColumn("Type", 160);
        this.viewer.addColumn("Initial Value", 160);
        this.viewer.addColumn("Lower Bound", 160);
        this.viewer.addColumn("Upper bound", 160);
        BorderPane lateralPane = new BorderPane();
        this.removeButton = new Button("Remove");
        this.addButton = new Button("Add");
        this.removeButton.setPrefWidth(100.0);
        this.removeButton.setPrefHeight(60.0);
        this.addButton.setPrefWidth(100.0);
        this.addButton.setPrefHeight(60.0);
        VBox vbox = new VBox(5.0);
        vbox.getChildren().addAll((Object[])new Node[]{this.addButton, this.removeButton});
        mainPane.setCenter((Node)this.viewer.getControl());
        mainPane.setRight((Node)lateralPane);
        lateralPane.setBottom((Node)vbox);
        this.removeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                DataStateEditorBase.this.removeSelectedVariable();
            }
        });
        this.addButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                DataStateEditorBase.this.addNewVariable();
            }
        });
        return mainPane;
    }

    protected void addNewVariable() {
        String name = "v" + (((IDataStateVariableProvider)this.getEditedObject()).getDataStateVariables().size() + 1);
        final DataStateVariable variable = BehaviorModelElementFactory.createDataStateVariable((String)name, (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)0));
        final ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor(this.getEditedObject());
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                topLevel.prepareIDs((EObject)variable);
                ((IDataStateVariableProvider)DataStateEditorBase.this.getEditedObject()).getDataStateVariables().add((Object)variable);
            }
        });
    }

    protected void removeSelectedVariable() {
        EObject object = (EObject)((TreeItem)this.viewer.getControl().getSelectionModel().getSelectedItem()).getValue();
        if (!(object instanceof DataStateVariable)) {
            return;
        }
        final DataStateVariable variable = (DataStateVariable)object;
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor(this.getEditedObject());
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                EcoreUtil.delete((EObject)variable, (boolean)true);
                ((IDataStateVariableProvider)DataStateEditorBase.this.getEditedObject()).getDataStateVariables().remove((Object)variable);
            }
        });
    }

    public void dispose() {
        this.modelListener.unregister();
        super.dispose();
    }
}

