/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.ui.editor.data;

import javafx.scene.control.ContextMenu;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.ui.databinding.convert.StringToIExpressionTermConverter;
import org.fortiss.af3.expression.ui.databinding.convert.StringToTypeConverter;
import org.fortiss.af3.expression.ui.databinding.convert.StringToVarConverter;
import org.fortiss.af3.expression.ui.databinding.validate.StringToIExpressionTermWithTypeCheckValidatorBase;
import org.fortiss.af3.expression.ui.databinding.validate.StringToITermValidator;
import org.fortiss.af3.expression.ui.databinding.validate.StringToTypeValidator;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.tooling.base.ui.utils.ContextMenuUtils;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public class DataStateEditorUIProvider
extends DynamicTreeTableUIProviderBase<EObject> {
    public String getLabel(EObject element, int column) {
        switch (column) {
            case 0: {
                return ((DataStateVariable)element).getIdentifier();
            }
            case 1: {
                IType type = ((DataStateVariable)element).getType();
                return type != null ? type.toString() : "";
            }
            case 2: {
                IExpressionTerm term = ((DataStateVariable)element).getInitialValue();
                return term != null ? term.toString() : "";
            }
            case 3: {
                IType type = ((IVariableDefinition)element).getVariableType();
                if (type instanceof TInt) {
                    return Integer.toString(((TInt)type).getLowerBound());
                }
                return "";
            }
            case 4: {
                IType type = ((IVariableDefinition)element).getVariableType();
                if (type instanceof TInt) {
                    return Integer.toString(((TInt)type).getUpperBound());
                }
                return "";
            }
        }
        return "";
    }

    public boolean isEditable(int column) {
        return true;
    }

    public void updateValue(EObject element, int column, Object value) {
        switch (column) {
            case 0: {
                this.updateName(element, (String)value);
                break;
            }
            case 1: {
                this.updateType(element, (String)value);
                break;
            }
            case 2: {
                this.updateInitialValue(element, (String)value);
                break;
            }
            case 3: {
                this.updateBound(element, (String)value, true);
                break;
            }
            case 4: {
                this.updateBound(element, (String)value, false);
            }
        }
    }

    private void updateBound(EObject element, String value, final boolean editLowerBound) {
        IType type;
        if (element instanceof IVariableDefinition && (type = ((IVariableDefinition)element).getVariableType()) instanceof TInt) {
            int bound;
            TInt intType = (TInt)type;
            final int newValue = Integer.parseInt(value.toString());
            int n = bound = editLowerBound ? intType.getLowerBound() : intType.getUpperBound();
            if (newValue != bound) {
                final TInt tint = (TInt)((IVariableDefinition)element).getVariableType();
                ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)tint);
                topLevel.runAsCommand(new Runnable(){

                    @Override
                    public void run() {
                        if (editLowerBound) {
                            tint.setLowerBound(newValue);
                        } else {
                            tint.setUpperBound(newValue);
                        }
                    }
                });
            }
        }
    }

    private void updateInitialValue(final EObject element, String value) {
        DataStateVariable elem;
        StringToIExpressionTermWithTypeCheckValidatorBase validator;
        if (element instanceof DataStateVariable && (validator = new StringToIExpressionTermWithTypeCheckValidatorBase((EObject)(elem = (DataStateVariable)element)){

            protected boolean isNoValAllowed() {
                return false;
            }

            protected String getUnknownTypeMessage() {
                return "Unknown type " + String.valueOf(this.getType()) + ". Cannot verify value. ";
            }

            protected IType getType() {
                return ((DataStateVariable)element).getType();
            }
        }).validate((Object)value).isOK()) {
            ICommandStackService.getInstance().runAsCommand((EObject)elem, () -> elem.setInitialValue(new StringToIExpressionTermConverter((EObject)elem).convert((Object)value)));
        }
    }

    private void updateType(EObject element, String value) {
        DataStateVariable elem;
        if (element instanceof DataStateVariable && new StringToTypeValidator((EObject)(elem = (DataStateVariable)element)).validate((Object)value).isOK()) {
            ICommandStackService.getInstance().runAsCommand((EObject)elem, () -> {
                IType type = new StringToTypeConverter((EObject)elem).convert((Object)value);
                elem.setType(type);
                elem.setInitialValue(ExpressionUtils.createDefaultConst((IType)type, (EObject)DataDictionaryUtils.findDataDictionary((EObject)elem)));
            });
        }
    }

    private void updateName(EObject element, String value) {
        DataStateVariable elem;
        if (element instanceof DataStateVariable && new StringToITermValidator((EObject)(elem = (DataStateVariable)element)).validate((Object)value).isOK()) {
            ICommandStackService.getInstance().runAsCommand((EObject)elem, () -> elem.setVariable(new StringToVarConverter((EObject)elem).convert((Object)value)));
        }
    }

    public ContextMenu createContextMenu(EObject element, int column) {
        if (element == null || column != 0) {
            return null;
        }
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().add((Object)ContextMenuUtils.createDeleteMenu((EObject)element));
        return contextMenu;
    }
}

