/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.ui.examples;

import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.ui.examples.SimpleTrafficLightsComponentArchitectureExample;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.model.TransitionSegment;
import org.fortiss.af3.state.ui.utils.TransitionLayoutUtils;
import org.fortiss.af3.state.utils.StateAutomatonUtils;
import org.fortiss.af3.state.utils.StateModelElementFactory;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.ui.utils.EllipseLayoutUIUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;

public class SimpleTrafficLightsStateAutomatonExample
extends SimpleTrafficLightsComponentArchitectureExample {
    public static final SimpleTrafficLightsStateAutomatonExample INSTANCE = new SimpleTrafficLightsStateAutomatonExample();

    protected SimpleTrafficLightsStateAutomatonExample() {
    }

    protected void createComponentBehaviorMerge(Component merge) {
        this.createComponentStateAutomatonMerge(merge);
    }

    protected void createComponentBehaviorBehavior(Component behavior) {
        this.createComponentStateAutomatonBehavior(behavior);
    }

    private void createComponentStateAutomatonMerge(Component merge) {
        StateAutomaton mergeAutomaton = StateModelElementFactory.createStateAutomaton((Component)merge);
        State rootState = mergeAutomaton.getRootState();
        State mergeState = StateModelElementFactory.createState((State)rootState, (String)"Merge", (boolean)true);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)mergeState, (int)80, (int)120, (int)162, (int)86);
        TransitionSegment forwardA = StateModelElementFactory.createTransitionSegment((State)rootState, (State)mergeState, (State)mergeState, (String)"forwardA");
        StateAutomatonUtils.setGuard((TransitionSegment)forwardA, (String)"mergeInButtonA == Present() && mergeInButtonB != Present()");
        StateAutomatonUtils.addAction((TransitionSegment)forwardA, (String)"mergeOutRequest", (String)"Present()");
        TransitionLayoutUtils.layoutTransition(forwardA, EllipseLayoutUIUtils.getRadianFromDegree((double)60.0), EllipseLayoutUIUtils.getRadianFromDegree((double)120.0), 160, 260);
        TransitionSegment forwardB = StateModelElementFactory.createTransitionSegment((State)rootState, (State)mergeState, (State)mergeState, (String)"forwardB");
        StateAutomatonUtils.setGuard((TransitionSegment)forwardB, (String)"mergeInButtonB == Present() && mergeInButtonA != Present()");
        StateAutomatonUtils.addAction((TransitionSegment)forwardB, (String)"mergeOutRequest", (String)"Present()");
        TransitionLayoutUtils.layoutTransition(forwardB, EllipseLayoutUIUtils.getRadianFromDegree((double)240.0), EllipseLayoutUIUtils.getRadianFromDegree((double)300.0), 160, 70);
        TransitionSegment forwardBoth = StateModelElementFactory.createTransitionSegment((State)rootState, (State)mergeState, (State)mergeState, (String)"forwardBoth");
        StateAutomatonUtils.setGuard((TransitionSegment)forwardBoth, (String)"mergeInButtonB == Present() && mergeInButtonA == Present()");
        StateAutomatonUtils.addAction((TransitionSegment)forwardBoth, (String)"mergeOutRequest", (String)"Present()");
        TransitionLayoutUtils.layoutTransition(forwardBoth, EllipseLayoutUIUtils.getRadianFromDegree((double)20.0), EllipseLayoutUIUtils.getRadianFromDegree((double)340.0), 300, 165);
    }

    private void createComponentStateAutomatonBehavior(Component behavior) {
        StateAutomaton behaviorAutomaton = StateModelElementFactory.createStateAutomaton((Component)behavior);
        State rootState = behaviorAutomaton.getRootState();
        State initState = StateModelElementFactory.createState((State)rootState, (String)"Init", (boolean)true);
        State greenState = StateModelElementFactory.createState((State)rootState, (String)"Green", (boolean)false);
        State redYellowState = StateModelElementFactory.createState((State)rootState, (String)"RedYellow", (boolean)false);
        State redState = StateModelElementFactory.createState((State)rootState, (String)"Red", (boolean)false);
        State yellowState = StateModelElementFactory.createState((State)rootState, (String)"Yellow", (boolean)false);
        StateModelElementFactory.createDataStateVariable((StateAutomaton)behaviorAutomaton, (String)"time", (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)-1));
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)initState, (int)80, (int)80, (int)108, (int)72);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)greenState, (int)400, (int)100, (int)129, (int)93);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)redYellowState, (int)500, (int)300, (int)172, (int)100);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)redState, (int)370, (int)450, (int)108, (int)72);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)yellowState, (int)120, (int)300, (int)129, (int)93);
        this.createInitToGreenOne(rootState, initState, greenState);
        this.createInitToGreenTwo(rootState, initState, greenState);
        this.createGreenToYellow(rootState, greenState, yellowState);
        this.createYellowToRed(rootState, redState, yellowState);
        this.createRedToRedYellow(rootState, redYellowState, redState);
        this.createRedYellowToGreen(rootState, greenState, redYellowState);
        this.createGreenToGreenRequest(rootState, greenState);
        this.createGreenToGreenCountdown(rootState, greenState);
        this.createYellowToYellowCountdown(rootState, yellowState);
        this.createRedToRedCountdown(rootState, redState);
        this.createRedYellowToRedYellowCountdown(rootState, redYellowState);
    }

    private void createRedYellowToRedYellowCountdown(State rootState, State redYellowState) {
        TransitionSegment redyellow2redyellowCountdown = StateModelElementFactory.createTransitionSegment((State)rootState, (State)redYellowState, (State)redYellowState, (String)"countdown");
        StateAutomatonUtils.setGuard((TransitionSegment)redyellow2redyellowCountdown, (String)"time > 0");
        StateAutomatonUtils.addAction((TransitionSegment)redyellow2redyellowCountdown, (String)"time", (String)"time - 1");
        TransitionLayoutUtils.layoutTransition(redyellow2redyellowCountdown, EllipseLayoutUIUtils.getRadianFromDegree((double)20.0), EllipseLayoutUIUtils.getRadianFromDegree((double)-20.0), 696, 348);
    }

    private void createRedToRedCountdown(State rootState, State redState) {
        TransitionSegment red2redCountdown = StateModelElementFactory.createTransitionSegment((State)rootState, (State)redState, (State)redState, (String)"countdown");
        StateAutomatonUtils.setGuard((TransitionSegment)red2redCountdown, (String)"time > 0");
        StateAutomatonUtils.addAction((TransitionSegment)red2redCountdown, (String)"time", (String)"time - 1");
        TransitionLayoutUtils.layoutTransition(red2redCountdown, EllipseLayoutUIUtils.getRadianFromDegree((double)250.0), EllipseLayoutUIUtils.getRadianFromDegree((double)290.0), 420, 420);
    }

    private void createYellowToYellowCountdown(State rootState, State yellowState) {
        TransitionSegment yellow2yellowCountdown = StateModelElementFactory.createTransitionSegment((State)rootState, (State)yellowState, (State)yellowState, (String)"countdown");
        StateAutomatonUtils.setGuard((TransitionSegment)yellow2yellowCountdown, (String)"time > 0");
        StateAutomatonUtils.addAction((TransitionSegment)yellow2yellowCountdown, (String)"time", (String)"time - 1");
        TransitionLayoutUtils.layoutTransition(yellow2yellowCountdown, EllipseLayoutUIUtils.getRadianFromDegree((double)-20.0), EllipseLayoutUIUtils.getRadianFromDegree((double)20.0), 276, 348);
    }

    private void createGreenToGreenCountdown(State rootState, State greenState) {
        TransitionSegment green2greenCountdown = StateModelElementFactory.createTransitionSegment((State)rootState, (State)greenState, (State)greenState, (String)"countdown");
        StateAutomatonUtils.setGuard((TransitionSegment)green2greenCountdown, (String)"time > 0");
        StateAutomatonUtils.addAction((TransitionSegment)green2greenCountdown, (String)"time", (String)"time - 1");
        TransitionLayoutUtils.layoutTransition(green2greenCountdown, EllipseLayoutUIUtils.getRadianFromDegree((double)290.0), EllipseLayoutUIUtils.getRadianFromDegree((double)250.0), 456, 72);
    }

    private void createGreenToGreenRequest(State rootState, State greenState) {
        TransitionSegment green2greenRequest = StateModelElementFactory.createTransitionSegment((State)rootState, (State)greenState, (State)greenState, (String)"receive");
        StateAutomatonUtils.setGuard((TransitionSegment)green2greenRequest, (String)"time == -1 && behaviorInRequest == Present()");
        StateAutomatonUtils.addAction((TransitionSegment)green2greenRequest, (String)"behaviorOutTrafficSignal", (String)"Green()");
        StateAutomatonUtils.addAction((TransitionSegment)green2greenRequest, (String)"behaviorOutPedestrianSignal", (String)"Stop()");
        StateAutomatonUtils.addAction((TransitionSegment)green2greenRequest, (String)"behaviorOutIndicatorSignal", (String)"On()");
        StateAutomatonUtils.addAction((TransitionSegment)green2greenRequest, (String)"time", (String)"tGreen()");
        TransitionLayoutUtils.layoutTransition(green2greenRequest, EllipseLayoutUIUtils.getRadianFromDegree((double)110.0), EllipseLayoutUIUtils.getRadianFromDegree((double)70.0), 456, 216);
    }

    private void createRedYellowToGreen(State rootState, State greenState, State redYellowState) {
        TransitionSegment redyellow2green = StateModelElementFactory.createTransitionSegment((State)rootState, (State)redYellowState, (State)greenState, (String)"redyellowToGreen");
        StateAutomatonUtils.setGuard((TransitionSegment)redyellow2green, (String)"time == 0");
        StateAutomatonUtils.addAction((TransitionSegment)redyellow2green, (String)"behaviorOutTrafficSignal", (String)"Green()");
        StateAutomatonUtils.addAction((TransitionSegment)redyellow2green, (String)"behaviorOutPedestrianSignal", (String)"Stop()");
        StateAutomatonUtils.addAction((TransitionSegment)redyellow2green, (String)"behaviorOutIndicatorSignal", (String)"Off()");
        StateAutomatonUtils.addAction((TransitionSegment)redyellow2green, (String)"time", (String)"-1");
        TransitionLayoutUtils.layoutTransitionAngles(redyellow2green, EllipseLayoutUIUtils.getRadianFromDegree((double)250.0), EllipseLayoutUIUtils.getRadianFromDegree((double)20.0));
    }

    private void createRedToRedYellow(State rootState, State redYellowState, State redState) {
        TransitionSegment red2redyellow = StateModelElementFactory.createTransitionSegment((State)rootState, (State)redState, (State)redYellowState, (String)"redToRedyellow");
        StateAutomatonUtils.setGuard((TransitionSegment)red2redyellow, (String)"time == 0");
        StateAutomatonUtils.addAction((TransitionSegment)red2redyellow, (String)"behaviorOutTrafficSignal", (String)"RedYellow()");
        StateAutomatonUtils.addAction((TransitionSegment)red2redyellow, (String)"behaviorOutPedestrianSignal", (String)"Stop()");
        StateAutomatonUtils.addAction((TransitionSegment)red2redyellow, (String)"behaviorOutIndicatorSignal", (String)"Off()");
        StateAutomatonUtils.addAction((TransitionSegment)red2redyellow, (String)"time", (String)"tYellow()");
        TransitionLayoutUtils.layoutTransitionAngles(red2redyellow, EllipseLayoutUIUtils.getRadianFromDegree((double)340.0), EllipseLayoutUIUtils.getRadianFromDegree((double)110.0));
    }

    private void createYellowToRed(State rootState, State redState, State yellowState) {
        TransitionSegment yellow2red = StateModelElementFactory.createTransitionSegment((State)rootState, (State)yellowState, (State)redState, (String)"yellowToRed");
        StateAutomatonUtils.setGuard((TransitionSegment)yellow2red, (String)"time == 0");
        StateAutomatonUtils.addAction((TransitionSegment)yellow2red, (String)"behaviorOutTrafficSignal", (String)"Red()");
        StateAutomatonUtils.addAction((TransitionSegment)yellow2red, (String)"behaviorOutPedestrianSignal", (String)"Walk()");
        StateAutomatonUtils.addAction((TransitionSegment)yellow2red, (String)"behaviorOutIndicatorSignal", (String)"Off()");
        StateAutomatonUtils.addAction((TransitionSegment)yellow2red, (String)"time", (String)"tRed()");
        TransitionLayoutUtils.layoutTransitionAngles(yellow2red, EllipseLayoutUIUtils.getRadianFromDegree((double)70.0), EllipseLayoutUIUtils.getRadianFromDegree((double)180.0));
    }

    private void createGreenToYellow(State rootState, State greenState, State yellowState) {
        TransitionSegment green2yellow = StateModelElementFactory.createTransitionSegment((State)rootState, (State)greenState, (State)yellowState, (String)"greenToYellow");
        StateAutomatonUtils.setGuard((TransitionSegment)green2yellow, (String)"time == 0");
        StateAutomatonUtils.addAction((TransitionSegment)green2yellow, (String)"behaviorOutTrafficSignal", (String)"Yellow()");
        StateAutomatonUtils.addAction((TransitionSegment)green2yellow, (String)"behaviorOutPedestrianSignal", (String)"Stop()");
        StateAutomatonUtils.addAction((TransitionSegment)green2yellow, (String)"behaviorOutIndicatorSignal", (String)"On()");
        StateAutomatonUtils.addAction((TransitionSegment)green2yellow, (String)"time", (String)"tYellow()");
        TransitionLayoutUtils.layoutTransitionAngles(green2yellow, EllipseLayoutUIUtils.getRadianFromDegree((double)160.0), EllipseLayoutUIUtils.getRadianFromDegree((double)290.0));
    }

    private void createInitToGreenTwo(State rootState, State initState, State greenState) {
        TransitionSegment init2green = StateModelElementFactory.createTransitionSegment((State)rootState, (State)initState, (State)greenState, (String)"initializeWithPresent");
        StateAutomatonUtils.setGuard((TransitionSegment)init2green, (String)"time == -1 && behaviorInRequest == Present()");
        StateAutomatonUtils.addAction((TransitionSegment)init2green, (String)"behaviorOutTrafficSignal", (String)"Green()");
        StateAutomatonUtils.addAction((TransitionSegment)init2green, (String)"behaviorOutPedestrianSignal", (String)"Stop()");
        StateAutomatonUtils.addAction((TransitionSegment)init2green, (String)"behaviorOutIndicatorSignal", (String)"On()");
        StateAutomatonUtils.addAction((TransitionSegment)init2green, (String)"time", (String)"tGreen()");
        TransitionLayoutUtils.layoutTransitionAngles(init2green, EllipseLayoutUIUtils.getRadianFromDegree((double)30.0), EllipseLayoutUIUtils.getRadianFromDegree((double)180.0));
    }

    private void createInitToGreenOne(State rootState, State initState, State greenState) {
        TransitionSegment init2green = StateModelElementFactory.createTransitionSegment((State)rootState, (State)initState, (State)greenState, (String)"initializeWithNoVal");
        StateAutomatonUtils.setGuard((TransitionSegment)init2green, (String)"time == -1 && behaviorInRequest == NoVal");
        StateAutomatonUtils.addAction((TransitionSegment)init2green, (String)"behaviorOutTrafficSignal", (String)"Green()");
        StateAutomatonUtils.addAction((TransitionSegment)init2green, (String)"behaviorOutPedestrianSignal", (String)"Stop()");
        StateAutomatonUtils.addAction((TransitionSegment)init2green, (String)"behaviorOutIndicatorSignal", (String)"Off()");
        StateAutomatonUtils.addAction((TransitionSegment)init2green, (String)"time", (String)"-1");
        TransitionLayoutUtils.layoutTransitionAngles(init2green, EllipseLayoutUIUtils.getRadianFromDegree((double)-20.0), EllipseLayoutUIUtils.getRadianFromDegree((double)200.0));
    }
}

