/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.ui.properties;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.component.ui.behavior.ActionsToStringConverter;
import org.fortiss.af3.component.ui.behavior.StringToActionsConverter;
import org.fortiss.af3.component.ui.behavior.StringToActionsValidator;
import org.fortiss.af3.state.model.AF3StatePackage;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.model.StateSpecification;
import org.fortiss.af3.state.model.TransitionSegmentSpecification;
import org.fortiss.af3.state.ui.AF3StateUIActivator;
import org.fortiss.af3.state.ui.utils.StateCompletionProposalUtils;
import org.fortiss.tooling.base.ui.fieldassist.FieldAssist;
import org.fortiss.tooling.base.ui.fieldassist.IProposalProvider;
import org.fortiss.tooling.base.ui.fieldassist.ProposalProviderBase;
import org.fortiss.tooling.ext.variability.util.VariabilityUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class StateSpecificationPropertySection
extends PropertySectionBase {
    private State state;
    private StateSpecification specification;
    private TransitionSegmentSpecification idleTransitionSpecification;
    private Text idleActionsText;
    private Button initialButton;
    private boolean userSelection;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.idleActionsText = this.createDecoratedFormText("Idle actions:", 2626);
        this.initialButton = this.getWidgetFactory().createButton(this.composite, "", 32);
        this.setupFieldAssist();
        this.createFormEntry((Control)this.initialButton, "Is initial:");
        this.initialButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (StateSpecificationPropertySection.this.userSelection) {
                    ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)StateSpecificationPropertySection.this.state);
                    topLevel.runAsCommand(new Runnable(){

                        @Override
                        public void run() {
                            StateSpecificationPropertySection.this.selectionChangeHandler();
                        }
                    });
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void selectionChangeHandler() {
        State oldInitialState;
        StateAutomaton automaton;
        if (this.initialButton.getSelection() && (automaton = (StateAutomaton)KernelModelElementUtils.getParentElement((EObject)this.state, StateAutomaton.class, (boolean)true)) != null && (oldInitialState = automaton.getInitialState()) != null && !VariabilityUtils.hasPresenceCondition((EObject)oldInitialState) && !VariabilityUtils.hasPresenceCondition((EObject)this.state)) {
            oldInitialState.getStateSpecification().setInitial(false);
        }
        this.specification.setInitial(this.initialButton.getSelection());
    }

    private void setupFieldAssist() {
        new FieldAssist(this.idleActionsText, (IProposalProvider)new ProposalProviderBase(){

            public String[] getProposals(String currentWord) {
                return StateCompletionProposalUtils.createIdleActionsProposals(StateSpecificationPropertySection.this.state);
            }
        });
    }

    protected void setSectionInput(Object input) {
        this.state = (State)input;
        this.specification = this.state.getStateSpecification();
        if (this.specification == null) {
            LoggingUtils.error((Plugin)AF3StateUIActivator.getDefault(), (String)"StateSpecificationPropertySection input is null!");
        } else {
            this.userSelection = false;
            this.initialButton.setSelection(this.specification.isInitial());
            this.userSelection = true;
        }
        this.idleTransitionSpecification = this.state.getIdleTransitionSpecification();
        if (this.idleTransitionSpecification == null) {
            LoggingUtils.error((Plugin)AF3StateUIActivator.getDefault(), (String)"Idle transition specification is null!");
        }
    }

    public void refresh() {
        super.refresh();
        if (this.specification == null) {
            return;
        }
        IObservableValue actionsObservable = ObservableUtils.observeValue((EObject)this.idleTransitionSpecification, (EStructuralFeature)AF3StatePackage.Literals.TRANSITION_SEGMENT_SPECIFICATION__ACTIONS);
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.idleActionsText, (IObservableValue)actionsObservable, (IConverter)new ActionsToStringConverter(), (IConverter)new StringToActionsConverter((EObject)this.specification), (IValidator)new StringToActionsValidator((EObject)this.specification), null);
    }
}

