/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.ui.properties;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.behavior.common.Action;
import org.fortiss.af3.component.model.behavior.common.CommonFactory;
import org.fortiss.af3.component.model.behavior.common.Guard;
import org.fortiss.af3.component.ui.behavior.ActionsToStringConverter;
import org.fortiss.af3.component.ui.behavior.GuardToStringConverter;
import org.fortiss.af3.component.ui.behavior.StringToActionsConverter;
import org.fortiss.af3.component.ui.behavior.StringToActionsValidator;
import org.fortiss.af3.component.ui.behavior.StringToGuardConverter;
import org.fortiss.af3.component.ui.behavior.StringToGuardValidator;
import org.fortiss.af3.expression.language.TypeSystemHandler;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.typesystem.ITypeSystemCompiler;
import org.fortiss.af3.state.model.AF3StatePackage;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.model.TransitionSegment;
import org.fortiss.af3.state.model.TransitionSegmentSpecification;
import org.fortiss.af3.state.ui.utils.StateCompletionProposalUtils;
import org.fortiss.tooling.base.ui.dialog.CheckBoxTreeDialog;
import org.fortiss.tooling.base.ui.fieldassist.FieldAssist;
import org.fortiss.tooling.base.ui.fieldassist.IProposalProvider;
import org.fortiss.tooling.base.ui.fieldassist.ProposalProviderBase;
import org.fortiss.tooling.base.ui.properties.view.PropertySectionWithCopyPasteBase;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class TransitionSegmentSpecificationPropertySection
extends PropertySectionWithCopyPasteBase<TransitionSegmentSpecification> {
    private static TransitionSegmentSpecification clipboardSpec;
    private Text guardText;
    private Text actionsText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.guardText = this.createDecoratedFormText("Guard", 2626);
        Button check = this.createDecoratedButton("Check NoVal", (Control)this.guardText);
        check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IExpressionTerm guard = TransitionSegmentSpecificationPropertySection.addNoValCheck(TransitionSegmentSpecificationPropertySection.this.guardText.getText(), ((TransitionSegmentSpecification)TransitionSegmentSpecificationPropertySection.this.specification).getTransitionSegment());
                if (guard != null) {
                    TransitionSegmentSpecificationPropertySection.this.guardText.setText(guard.toString());
                    ICommandStackService.getInstance().runAsCommand((EObject)TransitionSegmentSpecificationPropertySection.this.specification, new Runnable(){

                        @Override
                        public void run() {
                            ((TransitionSegmentSpecification)TransitionSegmentSpecificationPropertySection.this.specification).getGuard().setExpression(guard);
                        }
                    });
                }
            }
        });
        this.actionsText = this.createDecoratedFormText("Actions", 2626);
        this.createCopyPasteComposite();
        this.setupFieldAssist();
    }

    private void setupFieldAssist() {
        new FieldAssist(this.guardText, (IProposalProvider)new ProposalProviderBase(){

            public String[] getProposals(String currentWord) {
                return StateCompletionProposalUtils.createGuardProposals((TransitionSegmentSpecification)TransitionSegmentSpecificationPropertySection.this.specification);
            }
        });
        new FieldAssist(this.actionsText, (IProposalProvider)new ProposalProviderBase(){

            public String[] getProposals(String currentWord) {
                return StateCompletionProposalUtils.createActionsProposals((TransitionSegmentSpecification)TransitionSegmentSpecificationPropertySection.this.specification);
            }
        });
    }

    protected void setSectionInput(Object input) {
        this.specification = ((TransitionSegment)input).getTransitionSegmentSpecification();
        this.clipboardPaste.setEnabled(clipboardSpec != null && clipboardSpec != this.specification);
    }

    public void refresh() {
        super.refresh();
        IObservableValue guardObservable = ObservableUtils.observeValue((EObject)this.specification, (EStructuralFeature)AF3StatePackage.Literals.TRANSITION_SEGMENT_SPECIFICATION__GUARD);
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.guardText, (IObservableValue)guardObservable, (IConverter)new GuardToStringConverter(), (IConverter)new StringToGuardConverter((EObject)this.specification), (IValidator)new StringToGuardValidator((EObject)this.specification), null);
        IObservableValue actionsObservable = ObservableUtils.observeValue((EObject)this.specification, (EStructuralFeature)AF3StatePackage.Literals.TRANSITION_SEGMENT_SPECIFICATION__ACTIONS);
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.actionsText, (IObservableValue)actionsObservable, (IConverter)new ActionsToStringConverter(), (IConverter)new StringToActionsConverter((EObject)this.specification), (IValidator)new StringToActionsValidator((EObject)this.specification), null);
    }

    protected void setClipboardSpec(TransitionSegmentSpecification currentSpec) {
        clipboardSpec = currentSpec;
    }

    protected TransitionSegmentSpecification getClipboardSpec() {
        return clipboardSpec;
    }

    protected void doPerformCopy() {
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.specification);
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                TransitionSegment currentTS = ((TransitionSegmentSpecification)TransitionSegmentSpecificationPropertySection.this.specification).getTransitionSegment();
                TransitionSegment clipboardTS = clipboardSpec.getTransitionSegment();
                currentTS.setName(clipboardTS.getName());
                currentTS.setComment(clipboardTS.getComment());
                Guard guard = clipboardSpec.getGuard();
                Guard guardCopy = CommonFactory.eINSTANCE.createGuard();
                guardCopy.setExpression((IExpressionTerm)EcoreUtils.copy((EObject)guard.getExpression()));
                ((TransitionSegmentSpecification)TransitionSegmentSpecificationPropertySection.this.specification).setGuard(guardCopy);
                ((TransitionSegmentSpecification)TransitionSegmentSpecificationPropertySection.this.specification).getActions().clear();
                for (Action action : clipboardSpec.getActions()) {
                    Action copy = CommonFactory.eINSTANCE.createAction();
                    copy.setVariable((Var)EcoreUtils.copy((EObject)action.getVariable()));
                    copy.setValue((IExpressionTerm)EcoreUtils.copy((EObject)action.getValue()));
                    ((TransitionSegmentSpecification)TransitionSegmentSpecificationPropertySection.this.specification).getActions().add((Object)copy);
                }
            }
        });
    }

    public static IExpressionTerm addNoValCheck(String guardText, TransitionSegment ts) {
        Shell shell;
        block7: {
            CheckBoxTreeDialog dialog;
            IExpressionTerm expression;
            block8: {
                StateAutomaton sa = (StateAutomaton)ts.eContainer().eContainer();
                EList inputPorts = sa.getComponent().getInputPorts();
                ITypeSystemCompiler compiler = TypeSystemHandler.INSTANCE.getTypeSystemCompiler();
                shell = Display.getCurrent().getActiveShell();
                expression = (IExpressionTerm)compiler.compileTerm(guardText, (EObject)ts);
                ArrayList<String> ports = new ArrayList<String>();
                for (InputPort port : inputPorts) {
                    if (!ExpressionUtils.isUsed((ITerm)expression, (String)port.getName()).booleanValue() || ExpressionUtils.isNoValChecked((ITerm)expression, (String)port.getName()).booleanValue()) continue;
                    ports.add(port.getName());
                }
                if (ports.size() <= 0) break block7;
                dialog = new CheckBoxTreeDialog(shell, ports, "Missing NoVal Check", guardText);
                if (dialog.open() == 0) break block8;
                return null;
            }
            try {
                ArrayList<String> checkPorts = new ArrayList<String>();
                Object[] objectArray = dialog.getSelectedObjects();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    checkPorts.add((String)obj);
                    ++n2;
                }
                if (checkPorts.size() > 0) {
                    return ExpressionUtils.addNoValCheck((IExpressionTerm)expression, checkPorts);
                }
                return null;
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)shell, (String)"Unable Check", (String)"Guard expression error! Please check your expression.");
                return null;
            }
        }
        MessageDialog.openInformation((Shell)shell, (String)"Successfully Check", (String)"Guard check completed successfully, there is no error.");
        return null;
    }
}

