/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.ui.simulator.views;

import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.ui.simulatorfx.views.GraphicalSimulationFXView;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.model.TransitionSegment;
import org.fortiss.af3.state.simulator.ExecutableStateAutomatonSpecification;
import org.fortiss.af3.state.ui.editor.structure.StateAutomatonControllerFactory;
import org.fortiss.af3.state.ui.editor.structure.StateAutomatonModelFactory;
import org.fortiss.af3.state.ui.editor.structure.StateAutomatonVisualFactory;
import org.fortiss.af3.state.ui.editor.structure.visual.StateVisual;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.base.ui.editor.fx.controller.LayoutedRectangularResizableContentController;
import org.fortiss.tooling.base.ui.editor.fx.visual.NamedLayoutedCurveLinkVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IClickController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ClickControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;

public class GraphicalStateSimulationView
extends GraphicalSimulationFXView<Component> {
    public static final String ID = GraphicalStateSimulationView.class.getName();

    public GraphicalStateSimulationView() {
        super(Component.class);
    }

    public Parent createFXPartScene() {
        StateAutomaton automaton = this.extractStateAutomaton(this.getModelElement());
        StateAutomatonModelFactory delegatingModelFactory = new StateAutomatonModelFactory(automaton);
        SimulationAutomatonVisualFactory delegatingVisualFactory = new SimulationAutomatonVisualFactory();
        SimulationAutomatonControllerFactory delegatingControllerFactory = new SimulationAutomatonControllerFactory();
        this.viewer = new DiagramViewer(delegatingModelFactory, delegatingVisualFactory, delegatingControllerFactory, cb -> this.modelSelected(), chg -> this.applyModelChange()){

            public IDragController createDragController(IMVCBundle bundle, EDragGesture gesture, Node source, DiagramCoordinate lastMouseLocation) {
                return null;
            }
        };
        return this.viewer.getVisualNode();
    }

    protected void setModelElement(Component component) {
        StateAutomaton automaton = this.extractStateAutomaton(this.getModelElement());
        this.viewer.updateModelVisual((Object)automaton);
    }

    private StateAutomaton extractStateAutomaton(Component component) {
        StateAutomaton automaton = null;
        for (IModelElementSpecification sp : component.getSpecifications()) {
            if (!(sp instanceof StateAutomaton)) continue;
            automaton = (StateAutomaton)sp;
            break;
        }
        return automaton;
    }

    protected void updateVisuals(Component component) {
        this.viewer.updateAllVisuals();
    }

    protected void setFxFocus() {
        this.viewer.requestFocus();
    }

    public final class SimulationAutomatonControllerFactory
    extends StateAutomatonControllerFactory {
        @Override
        public IController createContentController(IContentMVCBundle model) {
            return new LayoutedRectangularResizableContentController<State>(model, State.class){

                public IClickController getClickController(Node node, DiagramCoordinate diagramLocation) {
                    return new ClickControllerBase(){

                        public Change doubleClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
                            return null;
                        }
                    };
                }
            };
        }
    }

    public final class SimulationAutomatonVisualFactory
    extends StateAutomatonVisualFactory {
        @Override
        public ILinkVisual createLinkVisual(final ILinkMVCBundle modelBundle) {
            Object linkObj = modelBundle.getModel();
            if (linkObj instanceof TransitionSegment) {
                return new NamedLayoutedCurveLinkVisual<TransitionSegment>(modelBundle, TransitionSegment.class){

                    protected Paint getLineColor() {
                        Object model = modelBundle.getModel();
                        if (model instanceof TransitionSegment && GraphicalStateSimulationView.this.executable != null) {
                            TransitionSegment ts = (TransitionSegment)model;
                            ExecutableStateAutomatonSpecification exec = (ExecutableStateAutomatonSpecification)GraphicalStateSimulationView.this.executable;
                            boolean wasLastFired = exec.getLastFiredTransitionSegments().stream().anyMatch(tsp -> tsp.getTransitionSegment().equals(ts));
                            if (wasLastFired) {
                                return Color.RED;
                            }
                        }
                        return super.getLineColor();
                    }
                };
            }
            return null;
        }

        @Override
        public IContentVisual createContentVisual(final IContentMVCBundle modelBundle) {
            Object modelObj = modelBundle.getModel();
            if (modelObj instanceof State) {
                return new StateVisual(modelBundle){

                    @Override
                    protected Paint getFillColor() {
                        Object model = modelBundle.getModel();
                        if (model instanceof State) {
                            ExecutableStateAutomatonSpecification exec;
                            State currentState;
                            State state = (State)model;
                            if (GraphicalStateSimulationView.this.executable != null && (currentState = (exec = (ExecutableStateAutomatonSpecification)GraphicalStateSimulationView.this.executable).getCurrentState()).equals(state)) {
                                return Color.RED;
                            }
                        }
                        return super.getFillColor();
                    }
                };
            }
            return null;
        }
    }
}

