/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.action;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetyargumentationpackage.model.SafetyArgumentationPackage;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.AwayContext;
import org.fortiss.af3.safetycases.model.Context;
import org.fortiss.af3.safetycases.model.SafetyCase;
import org.fortiss.af3.safetycases.model.SafetyModule;
import org.fortiss.af3.safetycases.model.VISIBILITY;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.utils.GSNSelectionDialogUtils;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.EObjectActionBase;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ConnectAwayContextToContextAction
extends EObjectActionBase<AwayContext> {
    private final Shell shell;

    public ConnectAwayContextToContextAction(AwayContext editedObject, Shell shell) {
        super("ConnectContextToAwayContext", (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)AF3SafetyCasesUIActivator.PLUGIN_ID, (String)"context.png").orElse(null));
        this.setTarget((EObject)editedObject);
        this.shell = shell;
    }

    public void run() {
        Context selectedContext;
        List sapList = KernelModelElementUtils.getRootElements((EObject)this.getTarget(), SafetyArgumentationPackage.class);
        Class[] classes = new Class[]{Context.class, SafetyModule.class, SafetyCase.class, SafetyArgumentationPackage.class};
        List<EObject> referenceable = Utils.noReferenceableAwayArgumentElements((ArgumentElement)this.getTarget(), classes, Context.class);
        if (sapList.isEmpty()) {
            MessageDialog.openError((Shell)this.shell, (String)"Warning", (String)"Cannot find any Assurance Packages! ");
            return;
        }
        if (referenceable.isEmpty()) {
            MessageDialog.openError((Shell)this.shell, (String)"Warning", (String)"No context constructs available in the project!");
            return;
        }
        Context selected = null;
        if (((AwayContext)this.getTarget()).getPointsTo() != null) {
            selected = (Context)((AwayContext)this.getTarget()).getPointsTo();
        }
        if ((selectedContext = GSNSelectionDialogUtils.openContexts(this.shell.getShell(), sapList, selected, (AwayContext)this.getTarget())) == null || selectedContext == selected) {
            return;
        }
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor(selectedContext.eContainer().eContainer());
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                if (selectedContext.getVisibility().equals((Object)VISIBILITY.PRIVATE)) {
                    String message = "This context is set as being private. Its selection will change its visibility! Are you sure you want to proceed?";
                    boolean confirm = MessageDialog.openConfirm((Shell)ConnectAwayContextToContextAction.this.shell, (String)"Warning", (String)message);
                    if (confirm) {
                        selectedContext.setVisibility(VISIBILITY.PUBLIC);
                        this.connectAwayContextWithSelectedContext(selectedContext);
                    }
                } else {
                    this.connectAwayContextWithSelectedContext(selectedContext);
                }
            }

            private void connectAwayContextWithSelectedContext(Context selectedContext2) {
                if (selectedContext2 != null) {
                    ((AwayContext)ConnectAwayContextToContextAction.this.getTarget()).setPointsTo((ArgumentElement)selectedContext2);
                    ((AwayContext)ConnectAwayContextToContextAction.this.getTarget()).setName(selectedContext2.getName());
                    if (selectedContext2.getTextualInformation() != null) {
                        ((AwayContext)ConnectAwayContextToContextAction.this.getTarget()).setTextualInformation(selectedContext2.getTextualInformation());
                    }
                }
            }
        });
    }
}

