/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.action;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetyargumentationpackage.model.SafetyArgumentationPackage;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.AwayGoal;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.model.SafetyCase;
import org.fortiss.af3.safetycases.model.SafetyModule;
import org.fortiss.af3.safetycases.model.VISIBILITY;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.utils.GSNSelectionDialogUtils;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.extension.base.EObjectActionBase;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ConnectAwayGoalToGoalAction
extends EObjectActionBase<AwayGoal> {
    private final Shell shell;

    public ConnectAwayGoalToGoalAction(AwayGoal editedObject, Shell shell) {
        super("ConnectGoalToAwayGoal", (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)AF3SafetyCasesUIActivator.PLUGIN_ID, (String)"goal.png").orElse(null));
        this.setTarget((EObject)editedObject);
        this.shell = shell;
    }

    public void run() {
        Goal selectedGoal;
        List sapList = KernelModelElementUtils.getRootElements((EObject)this.getTarget(), SafetyArgumentationPackage.class);
        Class[] classes = new Class[]{Goal.class, SafetyModule.class, SafetyCase.class, SafetyArgumentationPackage.class};
        List<EObject> referenceable = Utils.noReferenceableAwayArgumentElements((ArgumentElement)this.getTarget(), classes, Goal.class);
        if (sapList.isEmpty()) {
            MessageDialog.openError((Shell)this.shell, (String)"Warning", (String)"Cannot find any Assurance Packages!");
            return;
        }
        if (referenceable.isEmpty()) {
            MessageDialog.openError((Shell)this.shell, (String)"Warning", (String)"No goal constructs available in the project");
            return;
        }
        Goal selected = null;
        if (((AwayGoal)this.getTarget()).getPointsTo() != null) {
            selected = (Goal)((AwayGoal)this.getTarget()).getPointsTo();
        }
        if ((selectedGoal = GSNSelectionDialogUtils.openGoalsToConnectToAwayGoal(this.shell.getShell(), sapList, selected, (AwayGoal)this.getTarget())) == null || selectedGoal == selected) {
            return;
        }
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor(selectedGoal.eContainer().eContainer());
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                if (selectedGoal.getVisibility().equals((Object)VISIBILITY.PRIVATE)) {
                    String message = "The selected goal is defined as being private. Its selection will change its visibility! Are you sure you want to proceed?";
                    boolean confirm = MessageDialog.openConfirm((Shell)ConnectAwayGoalToGoalAction.this.shell, (String)"Warning", (String)message);
                    if (confirm) {
                        selectedGoal.setVisibility(VISIBILITY.PUBLIC);
                        this.connectAwayGoalWithSelectedGoal(selectedGoal);
                    }
                } else {
                    this.connectAwayGoalWithSelectedGoal(selectedGoal);
                }
            }

            private void connectAwayGoalWithSelectedGoal(Goal selectedGoal2) {
                ((AwayGoal)ConnectAwayGoalToGoalAction.this.getTarget()).setPointsTo((ArgumentElement)selectedGoal2);
                if (selectedGoal2.getTextualInformation() != null) {
                    ((AwayGoal)ConnectAwayGoalToGoalAction.this.getTarget()).setTextualInformation(selectedGoal2.getTextualInformation());
                }
            }
        });
    }

    public List<? extends EObject> getChildren(EObject parentElement) {
        IModelElementHandler base = IModelElementHandlerService.getInstance().getModelElementHandler(parentElement);
        if (base != null) {
            return base.getSubnodes(parentElement);
        }
        return Collections.emptyList();
    }
}

