/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.action;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetyargumentationpackage.model.SafetyArgumentationPackage;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.AwaySolution;
import org.fortiss.af3.safetycases.model.SafetyCase;
import org.fortiss.af3.safetycases.model.SafetyModule;
import org.fortiss.af3.safetycases.model.Solution;
import org.fortiss.af3.safetycases.model.VISIBILITY;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.utils.GSNSelectionDialogUtils;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.EObjectActionBase;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ConnectAwaySolutionToSolutionAction
extends EObjectActionBase<AwaySolution> {
    private final Shell shell;

    public ConnectAwaySolutionToSolutionAction(AwaySolution editedObject, Shell shell) {
        super("ConnectSolutionToAwaySolution", (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)AF3SafetyCasesUIActivator.PLUGIN_ID, (String)"solution.png").orElse(null));
        this.setTarget((EObject)editedObject);
        this.shell = shell;
    }

    public void run() {
        Solution selectedSolution;
        List sapList = KernelModelElementUtils.getRootElements((EObject)this.getTarget(), SafetyArgumentationPackage.class);
        Class[] classes = new Class[]{Solution.class, SafetyModule.class, SafetyCase.class, SafetyArgumentationPackage.class};
        List<EObject> referenceable = Utils.noReferenceableAwayArgumentElements((ArgumentElement)this.getTarget(), classes, Solution.class);
        if (sapList.isEmpty()) {
            MessageDialog.openError((Shell)this.shell, (String)"Warning", (String)"Cannot find any Assurance Packages!");
            return;
        }
        if (referenceable.isEmpty()) {
            MessageDialog.openError((Shell)this.shell, (String)"Warning", (String)"No solution constructs available in the project!");
            return;
        }
        Solution selected = null;
        if (((AwaySolution)this.getTarget()).getPointsTo() != null) {
            selected = (Solution)((AwaySolution)this.getTarget()).getPointsTo();
        }
        if ((selectedSolution = GSNSelectionDialogUtils.openSolutions(this.shell.getShell(), sapList, selected, (AwaySolution)this.getTarget())) == null || selectedSolution == selected) {
            return;
        }
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor(selectedSolution.eContainer().eContainer());
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                if (selectedSolution.getVisibility().equals((Object)VISIBILITY.PRIVATE)) {
                    String message = "The selected solution is set as being private. Its selection will change its visibility! Are you sure you want to proceed?";
                    boolean confirm = MessageDialog.openConfirm((Shell)ConnectAwaySolutionToSolutionAction.this.shell, (String)"Warning", (String)message);
                    if (confirm) {
                        selectedSolution.setVisibility(VISIBILITY.PUBLIC);
                        this.connectAwaySolutionWithSelectedSolution(selectedSolution);
                    }
                } else {
                    this.connectAwaySolutionWithSelectedSolution(selectedSolution);
                }
            }

            private void connectAwaySolutionWithSelectedSolution(Solution selectedSolution2) {
                ((AwaySolution)ConnectAwaySolutionToSolutionAction.this.getTarget()).setPointsTo((ArgumentElement)selectedSolution2);
                if (selectedSolution2.getName() != null) {
                    ((AwaySolution)ConnectAwaySolutionToSolutionAction.this.getTarget()).setName(selectedSolution2.getName());
                }
                if (selectedSolution2.getTextualInformation() != "") {
                    ((AwaySolution)ConnectAwaySolutionToSolutionAction.this.getTarget()).setTextualInformation(selectedSolution2.getTextualInformation());
                }
            }
        });
    }
}

