/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.action;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.platform.model.IPlatformArchitectureElement;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.ui.utils.AF3SelectionDialogUtils;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.af3.state.model.State;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.EObjectActionBase;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ConnectToSystemModelElementsAction
extends EObjectActionBase<ArgumentElement> {
    private ArgumentElement selectedArgumentElement = null;
    private List<EObject> alreadyReferenced;
    private Shell shell;

    public ConnectToSystemModelElementsAction(ArgumentElement target, String text, Shell shell) {
        super((EObject)target, text);
        this.setTarget((EObject)target);
        this.shell = shell;
        this.selectedArgumentElement = target;
    }

    public void run() {
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedArgumentElement);
        topLevel.runAsCommand(new Runnable(){
            private List<?> elements;

            @Override
            public void run() {
                if (ConnectToSystemModelElementsAction.this.selectedArgumentElement != null) {
                    ArrayList<Class<PlatformArchitecture>> roots = new ArrayList<Class<PlatformArchitecture>>();
                    EList ca2hwList = AllocationUtils.getAllocationTables((EObject)ConnectToSystemModelElementsAction.this.selectedArgumentElement, ComponentToExecutionUnitAllocationTable.class);
                    roots.add(Analysis.class);
                    roots.add(ComponentArchitecture.class);
                    roots.add(PlatformArchitecture.class);
                    ArrayList analysisList = new ArrayList(KernelModelElementUtils.getRootElements((EObject)ConnectToSystemModelElementsAction.this.selectedArgumentElement, roots));
                    analysisList.addAll(ca2hwList);
                    ConnectToSystemModelElementsAction.this.alreadyReferenced = Utils.alreadyReferencedElements(ConnectToSystemModelElementsAction.this.selectedArgumentElement);
                    this.elements = AF3SelectionDialogUtils.selectMultipleReferences(ConnectToSystemModelElementsAction.this.shell, analysisList, ConnectToSystemModelElementsAction.this.alreadyReferenced, (EObject)ConnectToSystemModelElementsAction.this.selectedArgumentElement);
                    if (this.elements != null) {
                        List<EObject> removedItems = ConnectToSystemModelElementsAction.this.alreadyReferenced.stream().filter(x -> !this.elements.contains(x)).collect(Collectors.toList());
                        ConnectToSystemModelElementsAction.this.removeIfNotContained(ConnectToSystemModelElementsAction.this.selectedArgumentElement, removedItems);
                        this.elements = this.elements.stream().filter(x -> !ConnectToSystemModelElementsAction.this.alreadyReferenced.contains(x)).collect(Collectors.toList());
                        if (!this.elements.isEmpty()) {
                            for (Object element : this.elements) {
                                if (element instanceof Requirement) {
                                    if (ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedRequirements() == null) continue;
                                    ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedRequirements().add((Object)((Requirement)element));
                                    continue;
                                }
                                if (element instanceof Component) {
                                    if (ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedComponents() == null) continue;
                                    ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedComponents().add((Object)((Component)element));
                                    continue;
                                }
                                if (element instanceof State) {
                                    if (ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedStates() == null) continue;
                                    ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedStates().add((Object)((State)element));
                                    continue;
                                }
                                if (element instanceof AllocationTable) {
                                    if (ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedDeployments() == null) continue;
                                    ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedDeployments().add((Object)((AllocationTable)element));
                                    continue;
                                }
                                if (element instanceof Mode) {
                                    if (ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedModes() == null) continue;
                                    ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedModes().add((Object)((Mode)element));
                                    continue;
                                }
                                if (!(element instanceof IPlatformArchitectureElement) || ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedPTA() == null) continue;
                                ConnectToSystemModelElementsAction.this.selectedArgumentElement.getReferencedPTA().add((Object)((IPlatformArchitectureElement)element));
                            }
                        }
                    }
                }
            }
        });
    }

    private void removeIfNotContained(ArgumentElement argElem, List<EObject> removedElements) {
        argElem.getReferencedComponents().removeIf(x -> removedElements.contains(x));
        argElem.getReferencedDeployments().removeIf(x -> removedElements.contains(x));
        argElem.getReferencedModes().removeIf(x -> removedElements.contains(x));
        argElem.getReferencedPTA().removeIf(x -> removedElements.contains(x));
        argElem.getReferencedRequirements().removeIf(x -> removedElements.contains(x));
        argElem.getReferencedStates().removeIf(x -> removedElements.contains(x));
    }
}

