/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.AwayArgumentElement;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.ui.utils.DropdownDialog;
import org.fortiss.af3.safetycases.ui.utils.MaintenanceUtils;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.EObjectActionBase;

public class SolveImpactAction
extends EObjectActionBase<ArgumentElement> {
    private ArgumentElement selectedArgumentElement = null;
    private final Shell shell;
    private String changeDescription = "";
    private List<String> entryList;

    public SolveImpactAction(ArgumentElement target, String text, Shell shell) {
        super((EObject)target, text);
        this.shell = shell;
    }

    public void run() {
        ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedArgumentElement);
        topLevel.runAsCommand(new Runnable(){

            @Override
            public void run() {
                boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set as unchallenged or remove the potentially/actually impacts on this node?");
                if (!go) {
                    return;
                }
                if (SolveImpactAction.this.selectedArgumentElement != null) {
                    EList changes = SolveImpactAction.this.selectedArgumentElement instanceof AwayArgumentElement && ((AwayArgumentElement)SolveImpactAction.this.selectedArgumentElement).getPointsTo() != null ? ((AwayArgumentElement)SolveImpactAction.this.selectedArgumentElement).getPointsTo().getAffectedByCurrentChanges() : SolveImpactAction.this.selectedArgumentElement.getAffectedByCurrentChanges();
                    if (changes == null) {
                        return;
                    }
                    SolveImpactAction.this.entryList = new ArrayList<String>();
                    for (Change currentChange : changes) {
                        if (currentChange.getModelElement() != null && Utils.getNameAndClass(currentChange) != null) {
                            List<String> specifications = Utils.getNameAndClass(currentChange);
                            String name = specifications.get(0);
                            String className = specifications.get(1);
                            SolveImpactAction.this.changeDescription = name + ", " + className + ", " + Utils.returnStringTypeOfMaintenance(currentChange.getMaintainanceCause()) + ", ";
                        }
                        SolveImpactAction.this.changeDescription = currentChange.getPersonalizedTypeOfChange() != null ? String.valueOf(SolveImpactAction.this.changeDescription) + currentChange.getPersonalizedTypeOfChange() : String.valueOf(SolveImpactAction.this.changeDescription) + String.valueOf(currentChange.getPredefinedTypeOfChange());
                        SolveImpactAction.this.entryList.add(SolveImpactAction.this.changeDescription);
                    }
                    DropdownDialog dialog = new DropdownDialog(SolveImpactAction.this.shell.getShell(), "Remove maintainance status", "Select the maintainance status you want to remove", SolveImpactAction.this.entryList);
                    String selected = "";
                    if (dialog.open() == 0) {
                        selected = dialog.getSelection();
                        if (dialog.getSelection() == null) {
                            return;
                        }
                    } else {
                        return;
                    }
                    for (Change change : changes) {
                        List selectedSpecification = Arrays.stream(selected.split(", ")).collect(Collectors.toList());
                        List<String> actualChangeSpecifications = Utils.getNameAndClass(change);
                        actualChangeSpecifications.add(Utils.returnStringTypeOfMaintenance(change.getMaintainanceCause()));
                        if (change.getPersonalizedTypeOfChange() != null) {
                            actualChangeSpecifications.add(change.getPersonalizedTypeOfChange());
                        } else {
                            actualChangeSpecifications.add(Utils.returnStringTypeOfChanges(change.getPredefinedTypeOfChange()));
                        }
                        if (!selectedSpecification.equals(actualChangeSpecifications)) continue;
                        SolveImpactAction.this.selectedArgumentElement.getAffectedByCurrentChanges().remove((Object)change);
                        MaintenanceUtils.removePropagatedImpactOnAwayElements(SolveImpactAction.this.selectedArgumentElement, change);
                        EcoreUtil.delete((EObject)change);
                        break;
                    }
                }
            }
        });
    }
}

