/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.AwayArgumentElement;
import org.fortiss.af3.safetycases.model.AwayContext;
import org.fortiss.af3.safetycases.model.AwayGoal;
import org.fortiss.af3.safetycases.model.AwaySolution;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.action.ConnectAwayContextToContextAction;
import org.fortiss.af3.safetycases.ui.action.ConnectAwayGoalToGoalAction;
import org.fortiss.af3.safetycases.ui.action.ConnectAwaySolutionToSolutionAction;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public class ConnectTheAwayEntity
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof AwayArgumentElement) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            String commandName = "";
            String iconPath = "";
            if (selection instanceof AwayGoal) {
                commandName = "Connect to Goal";
                iconPath = "icons/goal.png";
            } else if (selection instanceof AwayContext) {
                commandName = "Connect to Context";
                iconPath = "icons/context.png";
            } else if (selection instanceof AwaySolution) {
                commandName = "Connect to Solution";
                iconPath = "icons/solution.png";
            }
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new ConnectTheAwayEntityAction((AwayArgumentElement)selection, commandName, iconPath)));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    private class ConnectTheAwayEntityAction
    extends Action {
        private AwayArgumentElement selectedAwayEntity;

        ConnectTheAwayEntityAction(AwayArgumentElement selected, String commandName, String iconPath) {
            super(commandName, AF3SafetyCasesUIActivator.getImageDescriptor(iconPath));
            this.selectedAwayEntity = selected;
        }

        public void run() {
            if (this.selectedAwayEntity.getPointsTo() != null) {
                String message = "The selected away entity already has a scope! Are you sure you want to proceed?";
                boolean confirm = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)message);
                if (confirm) {
                    return;
                }
            }
            if (this.selectedAwayEntity instanceof AwayGoal) {
                new ConnectAwayGoalToGoalAction((AwayGoal)this.selectedAwayEntity, Display.getCurrent().getActiveShell()).run();
            } else if (this.selectedAwayEntity instanceof AwaySolution) {
                new ConnectAwaySolutionToSolutionAction((AwaySolution)this.selectedAwayEntity, Display.getCurrent().getActiveShell()).run();
            } else if (this.selectedAwayEntity instanceof AwayContext) {
                new ConnectAwayContextToContextAction((AwayContext)this.selectedAwayEntity, Display.getCurrent().getActiveShell()).run();
            }
        }
    }
}

