/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.AwayArgumentElement;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.action.ConnectToSystemModelElementsAction;
import org.fortiss.af3.safetycases.ui.utils.AF3SelectionDialogUtils;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;

public class ConnectToSystemModelElements
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof ArgumentElement) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            if (selection instanceof AwayArgumentElement) {
                return Collections.emptyList();
            }
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new ReferenceSystemModelElements((ArgumentElement)selection)));
            ArgumentElement argElement = (ArgumentElement)selection;
            List<EObject> existingReferences = Utils.alreadyReferencedElements(argElement);
            if (!existingReferences.isEmpty()) {
                contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new ShowReferenceSystemModelElements(argElement)));
            }
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    private class ReferenceSystemModelElements
    extends Action {
        private ArgumentElement selectedArgumentElement;

        ReferenceSystemModelElements(ArgumentElement selectedArgumentElement) {
            super("Add Traces to AF3 Models", AF3SafetyCasesUIActivator.getImageDescriptor("icons/connection.png"));
            this.selectedArgumentElement = null;
            this.selectedArgumentElement = selectedArgumentElement;
        }

        public void run() {
            new ConnectToSystemModelElementsAction(this.selectedArgumentElement, "", Display.getCurrent().getActiveShell()).run();
        }
    }

    private class ShowReferenceSystemModelElements
    extends Action {
        private ArgumentElement selectedArgumentElement;
        private Shell shell;

        ShowReferenceSystemModelElements(ArgumentElement selectedArgumentElement) {
            super("Show Traces to AF3 Models", AF3SafetyCasesUIActivator.getImageDescriptor("icons/selectConnection.png"));
            this.selectedArgumentElement = null;
            this.selectedArgumentElement = selectedArgumentElement;
            this.shell = Display.getCurrent().getActiveShell();
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedArgumentElement);
            topLevel.runAsCommand(new Runnable(){
                private List<EObject> elements;

                @Override
                public void run() {
                    this.elements = Utils.alreadyReferencedElements(ShowReferenceSystemModelElements.this.selectedArgumentElement);
                    EObject option = AF3SelectionDialogUtils.selectSystemModelElement(ShowReferenceSystemModelElements.this.shell, this.elements, (EObject)ShowReferenceSystemModelElements.this.selectedArgumentElement);
                    if (option != null) {
                        IModelEditorBindingService.getInstance().openInEditor(option);
                    }
                }
            });
        }
    }
}

