/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.AwayArgumentElement;
import org.fortiss.af3.safetycases.model.AwayContext;
import org.fortiss.af3.safetycases.model.AwayGoal;
import org.fortiss.af3.safetycases.model.AwaySolution;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public class DeleteAwayEntityReference
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof AwayArgumentElement && ((AwayArgumentElement)selection).getPointsTo() != null) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            String commandName = "";
            if (selection instanceof AwayGoal) {
                commandName = "Disconnect From Goal";
            } else if (selection instanceof AwayContext) {
                commandName = "Disconnect From Context";
            } else if (selection instanceof AwaySolution) {
                commandName = "Disconnect From Solution";
            }
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new DeleteAwayEntityReferenceAction((AwayArgumentElement)selection, commandName)));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    private class DeleteAwayEntityReferenceAction
    extends Action {
        private AwayArgumentElement selectedAwayEntity;

        DeleteAwayEntityReferenceAction(AwayArgumentElement selected, String commandName) {
            super(commandName, AF3SafetyCasesUIActivator.getImageDescriptor("icons/delete.png"));
            this.selectedAwayEntity = selected;
        }

        public void run() {
            if (this.selectedAwayEntity.getPointsTo() != null) {
                ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedAwayEntity);
                topLevel.runAsCommand(new Runnable(){

                    @Override
                    public void run() {
                        boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)("Are you sure you want to delete the reference to " + DeleteAwayEntityReferenceAction.this.selectedAwayEntity.getPointsTo().getName() + "?"));
                        if (!go) {
                            return;
                        }
                        DeleteAwayEntityReferenceAction.this.selectedAwayEntity.setPointsTo(null);
                        if (DeleteAwayEntityReferenceAction.this.selectedAwayEntity instanceof AwayGoal) {
                            DeleteAwayEntityReferenceAction.this.selectedAwayEntity.setName("AwayGoal");
                        } else if (DeleteAwayEntityReferenceAction.this.selectedAwayEntity instanceof AwaySolution) {
                            DeleteAwayEntityReferenceAction.this.selectedAwayEntity.setName("AwaySolution");
                        } else if (DeleteAwayEntityReferenceAction.this.selectedAwayEntity instanceof AwayContext) {
                            DeleteAwayEntityReferenceAction.this.selectedAwayEntity.setName("AwayContext");
                        }
                        DeleteAwayEntityReferenceAction.this.selectedAwayEntity.setTextualInformation("");
                    }
                });
            }
        }
    }
}

