/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.ArgumentElementBase;
import org.fortiss.af3.safetycases.model.ArgumentModule;
import org.fortiss.af3.safetycases.model.AwayContext;
import org.fortiss.af3.safetycases.model.AwayGoal;
import org.fortiss.af3.safetycases.model.AwaySolution;
import org.fortiss.af3.safetycases.model.InContextOf;
import org.fortiss.af3.safetycases.model.SafetyCase;
import org.fortiss.af3.safetycases.model.SupportedBy;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.utils.SafetyCasesModelElementFactory;
import org.fortiss.af3.safetycases.utils.SafetyCasesModellingUtils;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public class GenerateModuleConnections
implements IContextMenuContributor {
    static boolean nulReferences = false;

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof SafetyCase) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new GenerateModuleConnectionsAction((SafetyCase)selection)));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "topmost";
    }

    public static ArrayList<ArgumentModule> getContextualArgumentModules(ArgumentModule argumentModule) {
        ArrayList<ArgumentModule> list = new ArrayList<ArgumentModule>();
        for (IHierarchicElement ele : argumentModule.getContainedElements()) {
            boolean refNotNull;
            if (!(ele instanceof AwayContext)) continue;
            boolean bl = refNotNull = ((AwayContext)ele).getPointsTo() != null;
            if (refNotNull) {
                list.add((ArgumentModule)((AwayContext)ele).getPointsTo().getModule());
                continue;
            }
            nulReferences = true;
        }
        return list;
    }

    public static ArrayList<ArgumentModule> getSupportingArgumentModules(ArgumentModule argumentModule) {
        ArrayList<ArgumentModule> list = new ArrayList<ArgumentModule>();
        for (IHierarchicElement ihe : argumentModule.getContainedElements()) {
            boolean refNotNull2;
            if (ihe instanceof AwayGoal) {
                boolean refNotNull;
                boolean bl = refNotNull = ((AwayGoal)ihe).getPointsTo() != null;
                if (refNotNull) {
                    list.add((ArgumentModule)((AwayGoal)ihe).getPointsTo().getModule());
                    continue;
                }
                nulReferences = true;
                continue;
            }
            if (!(ihe instanceof AwaySolution)) continue;
            boolean bl = refNotNull2 = ((AwaySolution)ihe).getPointsTo() != null;
            if (refNotNull2) {
                list.add((ArgumentModule)((AwaySolution)ihe).getPointsTo().getModule());
                continue;
            }
            nulReferences = true;
        }
        return list;
    }

    private class GenerateModuleConnectionsAction
    extends Action {
        private SafetyCase selectedSafetyCase;
        private boolean noConnectionsToBeGenerated;

        GenerateModuleConnectionsAction(SafetyCase selected) {
            super("Generate Module Connections", AF3SafetyCasesUIActivator.getImageDescriptor("icons/generate.png"));
            this.noConnectionsToBeGenerated = true;
            this.selectedSafetyCase = selected;
        }

        public void run() {
            Shell activeShell;
            String message;
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedSafetyCase);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    SafetyCasesModellingUtils.deleteExistingIntraModuleConnections((SafetyCase)GenerateModuleConnectionsAction.this.selectedSafetyCase);
                }
            });
            EList argumentModulesList = this.selectedSafetyCase.getContainedArgumentModules();
            this.generateSupportedByConnections((EList<ArgumentModule>)argumentModulesList);
            this.generateInContextOfConnections((EList<ArgumentModule>)argumentModulesList);
            if (nulReferences) {
                message = "There are away entities in this safey case which do not have a reference!";
                activeShell = Display.getCurrent().getActiveShell();
                MessageDialog.openInformation((Shell)activeShell, (String)"Information", (String)message);
            }
            if (this.noConnectionsToBeGenerated) {
                message = "There are no connections between the existing argument modules to be generated!";
                activeShell = Display.getCurrent().getActiveShell();
                MessageDialog.openInformation((Shell)activeShell, (String)"Information", (String)message);
            }
        }

        private void generateInContextOfConnections(EList<ArgumentModule> argumentModulesList) {
            for (final ArgumentModule argModule : argumentModulesList) {
                ArrayList<ArgumentModule> contextualModulesList = GenerateModuleConnections.getContextualArgumentModules(argModule);
                if (!contextualModulesList.isEmpty()) continue;
                for (final ArgumentModule childArgModule : contextualModulesList) {
                    ITopLevelElement topLevel1 = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedSafetyCase);
                    topLevel1.runAsCommand(new Runnable(){

                        @Override
                        public void run() {
                            SafetyCasesModelElementFactory.createConnectionAndAttach((HierarchicElementBase)GenerateModuleConnectionsAction.this.selectedSafetyCase, (ArgumentElementBase)argModule, (ArgumentElementBase)childArgModule, InContextOf.class);
                            GenerateModuleConnectionsAction.this.noConnectionsToBeGenerated = false;
                        }
                    });
                }
            }
        }

        private void generateSupportedByConnections(EList<ArgumentModule> argumentModulesList) {
            for (final ArgumentModule argModule : argumentModulesList) {
                ArrayList<ArgumentModule> supportingModulesList = GenerateModuleConnections.getSupportingArgumentModules(argModule);
                if (supportingModulesList.isEmpty()) continue;
                for (final ArgumentModule childArgModule : supportingModulesList) {
                    ITopLevelElement topLevel1 = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedSafetyCase.getContainer());
                    topLevel1.runAsCommand(new Runnable(){

                        @Override
                        public void run() {
                            System.out.println(GenerateModuleConnectionsAction.this.selectedSafetyCase.getContainer());
                            SafetyCasesModelElementFactory.createConnectionAndAttach((HierarchicElementBase)GenerateModuleConnectionsAction.this.selectedSafetyCase, (ArgumentElementBase)argModule, (ArgumentElementBase)childArgModule, SupportedBy.class);
                            GenerateModuleConnectionsAction.this.noConnectionsToBeGenerated = false;
                        }
                    });
                }
            }
        }
    }
}

