/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public class GoalToBeSupportedByContract
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof Goal && !((Goal)selection).isToBeSupportedByContract()) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new GoalToBeSupportedByContractAction((Goal)selection)));
            return contributionItems;
        }
        if (selection instanceof Goal && ((Goal)selection).isToBeSupportedByContract()) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new GoalNotToBeSupportedByContractAction((Goal)selection)));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    private class GoalNotToBeSupportedByContractAction
    extends Action {
        private Goal selectedGoal;

        GoalNotToBeSupportedByContractAction(Goal selected) {
            super("Set Not To Be Supported By Contract", AF3SafetyCasesUIActivator.getImageDescriptor("icons/delete.png"));
            this.selectedGoal = selected;
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedGoal);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this goal as not to be supported by contract?");
                    if (!go) {
                        return;
                    }
                    if (GoalNotToBeSupportedByContractAction.this.selectedGoal.isToBeSupportedByContract()) {
                        GoalNotToBeSupportedByContractAction.this.selectedGoal.setToBeSupportedByContract(false);
                    }
                }
            });
        }
    }

    private class GoalToBeSupportedByContractAction
    extends Action {
        private Goal selectedGoal;

        GoalToBeSupportedByContractAction(Goal selected) {
            super("Set To Be Supported By Contract", AF3SafetyCasesUIActivator.getImageDescriptor("icons/contract.png"));
            this.selectedGoal = selected;
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedGoal);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this goal as to be supported by contract?");
                    if (!go) {
                        return;
                    }
                    if (!GoalToBeSupportedByContractAction.this.selectedGoal.isToBeSupportedByContract()) {
                        GoalToBeSupportedByContractAction.this.selectedGoal.setToBeSupportedByContract(true);
                    }
                }
            });
        }
    }
}

