/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.Goal;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public class GoalUndevelopedEntity
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof Goal && !((Goal)selection).isToBeDeveloped()) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new SetUndevelopedEntityAction((Goal)selection)));
            return contributionItems;
        }
        if (selection instanceof Goal && ((Goal)selection).isToBeDeveloped()) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new SetDevelopedEntityAction((Goal)selection)));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    private class SetDevelopedEntityAction
    extends Action {
        private Goal selectedGoal;

        SetDevelopedEntityAction(Goal selected) {
            super("Set Developed Entity", AF3SafetyCasesUIActivator.getImageDescriptor("icons/check.png"));
            this.selectedGoal = selected;
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedGoal);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this goal as developed?");
                    if (!go) {
                        return;
                    }
                    if (SetDevelopedEntityAction.this.selectedGoal.isToBeDeveloped()) {
                        SetDevelopedEntityAction.this.selectedGoal.setToBeDeveloped(false);
                    }
                }
            });
        }
    }

    private class SetUndevelopedEntityAction
    extends Action {
        private Goal selectedGoal;

        SetUndevelopedEntityAction(Goal selected) {
            super("Set Undeveloped Entity", AF3SafetyCasesUIActivator.getImageDescriptor("icons/todo.png"));
            this.selectedGoal = selected;
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedGoal);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this goal as undeveloped?");
                    if (!go) {
                        return;
                    }
                    if (!SetUndevelopedEntityAction.this.selectedGoal.isToBeDeveloped()) {
                        SetUndevelopedEntityAction.this.selectedGoal.setToBeDeveloped(true);
                    }
                }
            });
        }
    }
}

