/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.AwayArgumentElement;
import org.fortiss.af3.safetycases.model.Change;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.af3.safetycases.ui.action.SetAsImpactedAction;
import org.fortiss.af3.safetycases.ui.utils.DropdownDialog;
import org.fortiss.af3.safetycases.ui.utils.MaintenanceUtils;
import org.fortiss.af3.safetycases.ui.utils.Utils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public class SCElementIsImpacted
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
        if (selection instanceof AwayArgumentElement && ((AwayArgumentElement)selection).getPointsTo() == null) {
            return Collections.emptyList();
        }
        if (selection instanceof ArgumentElement) {
            ArgumentElement argElement = (ArgumentElement)selection;
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new SetImpact(argElement)));
            if (!argElement.getAffectedByCurrentChanges().isEmpty() || argElement.getAffectedByCurrentChanges() == null) {
                contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new SolveImpact(argElement)));
            }
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    private class SetImpact
    extends Action {
        private ArgumentElement selectedArgumentElement;

        SetImpact(ArgumentElement selectedArgumentElement) {
            super("Set under Maintenance", AF3SafetyCasesUIActivator.getImageDescriptor("icons/impacted.png"));
            this.selectedArgumentElement = null;
            this.selectedArgumentElement = selectedArgumentElement;
        }

        public void run() {
            boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this argument element as Challenged or Potentially/Actually Impacted?");
            if (!go) {
                return;
            }
            new SetAsImpactedAction(this.selectedArgumentElement, "", Display.getCurrent().getActiveShell()).run();
        }
    }

    private class SolveImpact
    extends Action {
        private ArgumentElement selectedArgumentElement;
        private Shell shell;
        private String changeDescription;
        private List<String> entryList;

        SolveImpact(ArgumentElement selectedArgumentElement) {
            super("Set to Up-to-Date", AF3SafetyCasesUIActivator.getImageDescriptor("icons/set_up-to-date.png"));
            this.selectedArgumentElement = null;
            this.changeDescription = "";
            this.selectedArgumentElement = selectedArgumentElement;
            this.shell = Display.getCurrent().getActiveShell();
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedArgumentElement);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set as unchallenged or remove the potentially/actually impacts on this node?");
                    if (!go) {
                        return;
                    }
                    if (SolveImpact.this.selectedArgumentElement != null) {
                        EList changes = SolveImpact.this.selectedArgumentElement instanceof AwayArgumentElement && ((AwayArgumentElement)SolveImpact.this.selectedArgumentElement).getPointsTo() != null ? ((AwayArgumentElement)SolveImpact.this.selectedArgumentElement).getPointsTo().getAffectedByCurrentChanges() : SolveImpact.this.selectedArgumentElement.getAffectedByCurrentChanges();
                        if (changes == null) {
                            return;
                        }
                        SolveImpact.this.entryList = new ArrayList<String>();
                        for (Change currentChange : changes) {
                            if (currentChange.getModelElement() != null && Utils.getNameAndClass(currentChange) != null) {
                                List<String> specifications = Utils.getNameAndClass(currentChange);
                                String name = specifications.get(0);
                                String className = specifications.get(1);
                                SolveImpact.this.changeDescription = name + ", " + className + ", " + Utils.returnStringTypeOfMaintenance(currentChange.getMaintainanceCause()) + ", ";
                            }
                            SolveImpact.this.changeDescription = currentChange.getPersonalizedTypeOfChange() != null ? String.valueOf(SolveImpact.this.changeDescription) + currentChange.getPersonalizedTypeOfChange() : String.valueOf(SolveImpact.this.changeDescription) + String.valueOf(currentChange.getPredefinedTypeOfChange());
                            SolveImpact.this.entryList.add(SolveImpact.this.changeDescription);
                        }
                        DropdownDialog dialog = new DropdownDialog(SolveImpact.this.shell.getShell(), "Remove maintainance status", "Select the maintainance status you want to remove", SolveImpact.this.entryList);
                        String selected = "";
                        if (dialog.open() == 0) {
                            selected = dialog.getSelection();
                            if (dialog.getSelection() == null) {
                                return;
                            }
                        } else {
                            return;
                        }
                        for (Change change : changes) {
                            List selectedSpecification = Arrays.stream(selected.split(", ")).collect(Collectors.toList());
                            List<String> actualChangeSpecifications = Utils.getNameAndClass(change);
                            actualChangeSpecifications.add(Utils.returnStringTypeOfMaintenance(change.getMaintainanceCause()));
                            if (change.getPersonalizedTypeOfChange() != null) {
                                actualChangeSpecifications.add(change.getPersonalizedTypeOfChange());
                            } else {
                                actualChangeSpecifications.add(Utils.returnStringTypeOfChanges(change.getPredefinedTypeOfChange()));
                            }
                            if (!selectedSpecification.equals(actualChangeSpecifications)) continue;
                            SolveImpact.this.selectedArgumentElement.getAffectedByCurrentChanges().remove((Object)change);
                            MaintenanceUtils.removePropagatedImpactOnAwayElements(SolveImpact.this.selectedArgumentElement, change);
                            EcoreUtil.delete((EObject)change);
                            break;
                        }
                    }
                }
            });
        }
    }
}

