/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.ArgumentElement;
import org.fortiss.af3.safetycases.model.OptionEntity;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public class SCElementIsInstantiated
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof ArgumentElement && !(selection instanceof OptionEntity) && !((ArgumentElement)selection).isToBeInstantiated()) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new ElementIsInstantiatedAction((ArgumentElement)selection)));
            return contributionItems;
        }
        if (selection instanceof ArgumentElement && !(selection instanceof OptionEntity) && ((ArgumentElement)selection).isToBeInstantiated()) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new ElementIsUninstantiatedAction((ArgumentElement)selection)));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    public class ElementIsInstantiatedAction
    extends Action {
        private ArgumentElement selectedArgumentElement;

        ElementIsInstantiatedAction(ArgumentElement selectedArgumentElement) {
            super("Set to Uninstantiated", AF3SafetyCasesUIActivator.getImageDescriptor("icons/todo.png"));
            this.selectedArgumentElement = selectedArgumentElement;
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedArgumentElement);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this argument element as uninstantied?");
                    if (!go) {
                        return;
                    }
                    if (!ElementIsInstantiatedAction.this.selectedArgumentElement.isToBeInstantiated()) {
                        ElementIsInstantiatedAction.this.selectedArgumentElement.setToBeInstantiated(true);
                    }
                }
            });
        }
    }

    private class ElementIsUninstantiatedAction
    extends Action {
        private ArgumentElement selectedArgumentElement;

        ElementIsUninstantiatedAction(ArgumentElement selected) {
            super("Set to Instantiated", AF3SafetyCasesUIActivator.getImageDescriptor("icons/check.png"));
            this.selectedArgumentElement = selected;
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedArgumentElement);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this argument element as instantied?");
                    if (!go) {
                        return;
                    }
                    String textualInformation = ElementIsUninstantiatedAction.this.selectedArgumentElement.getTextualInformation();
                    if (Pattern.matches("^\\{((.|\\n)*)}$", textualInformation)) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"This element cannot be set as instantiated since its claim still contains uninstantiated words!");
                    } else {
                        ElementIsUninstantiatedAction.this.selectedArgumentElement.setToBeInstantiated(false);
                    }
                }
            });
        }
    }
}

