/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safetycases.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.safetycases.model.ArgumentModuleInterface;
import org.fortiss.af3.safetycases.model.VISIBILITY;
import org.fortiss.af3.safetycases.ui.AF3SafetyCasesUIActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public class SCElementIsPrivate
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
        if (selection instanceof ArgumentModuleInterface) {
            ArgumentModuleInterface argumentModuleInterface = (ArgumentModuleInterface)selection;
            if (argumentModuleInterface.getVisibility() != VISIBILITY.PRIVATE) {
                contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new IsPrivateAction(argumentModuleInterface)));
            } else {
                contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new IsPublicAction(argumentModuleInterface)));
            }
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    private class IsPrivateAction
    extends Action {
        private ArgumentModuleInterface selectedArgumentElement;

        IsPrivateAction(ArgumentModuleInterface selected) {
            super("Set to Private", AF3SafetyCasesUIActivator.getImageDescriptor("icons/private.png"));
            this.selectedArgumentElement = null;
            this.selectedArgumentElement = selected;
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedArgumentElement);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this argument element as private?");
                    if (!go) {
                        return;
                    }
                    if (IsPrivateAction.this.selectedArgumentElement != null && IsPrivateAction.this.selectedArgumentElement.getVisibility() == VISIBILITY.PUBLIC) {
                        IsPrivateAction.this.selectedArgumentElement.setVisibility(VISIBILITY.PRIVATE);
                    }
                }
            });
        }
    }

    private class IsPublicAction
    extends Action {
        private ArgumentModuleInterface selectedArgumentElement;

        IsPublicAction(ArgumentModuleInterface selectedArgumentElement) {
            super("Set to Public", AF3SafetyCasesUIActivator.getImageDescriptor("icons/public.png"));
            this.selectedArgumentElement = null;
            this.selectedArgumentElement = selectedArgumentElement;
        }

        public void run() {
            ITopLevelElement topLevel = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.selectedArgumentElement);
            topLevel.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    boolean go = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)"Are you sure you want to set this argument element as public?");
                    if (!go) {
                        return;
                    }
                    if (IsPublicAction.this.selectedArgumentElement != null && IsPublicAction.this.selectedArgumentElement.getVisibility() == VISIBILITY.PRIVATE) {
                        IsPublicAction.this.selectedArgumentElement.setVisibility(VISIBILITY.PUBLIC);
                    }
                }
            });
        }
    }
}

